/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.WrappedSession;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpSession;

public class WrappedHttpSession
implements WrappedSession {
    private final HttpSession session;

    public WrappedHttpSession(HttpSession session) {
        this.session = session;
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.session.getMaxInactiveInterval();
    }

    @Override
    public Object getAttribute(String name) {
        return this.session.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.session.setAttribute(name, value);
    }

    public HttpSession getHttpSession() {
        return this.session;
    }

    @Override
    public Set<String> getAttributeNames() {
        Enumeration attributeNames = this.session.getAttributeNames();
        return WrappedHttpSession.enumerationToSet(attributeNames);
    }

    static <T> Set<T> enumerationToSet(Enumeration<T> values) {
        HashSet<T> set = new HashSet<T>();
        while (values.hasMoreElements()) {
            set.add(values.nextElement());
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public void invalidate() {
        if (this.session == null) {
            throw new IllegalStateException("Session is null and cannot be invalidated");
        }
        if (this.session.getClass().getName().equals("org.atmosphere.util.FakeHttpSession")) {
            throw new UnsupportedOperationException("FakeHttpSession cannot be invalidated. This typically means you are using websockets together with Tomcat 7. Because Tomcat 7 does not support sharing the HTTP session between standard HTTP requests and websockets, a copy of the session is used for websockets. Invalidating this session does not have the desired effect. To resolve this, upgrade to Tomcat 8 or use another transport mechanism than websockets.");
        }
        this.session.invalidate();
    }

    @Override
    public String getId() {
        return this.session.getId();
    }

    @Override
    public long getCreationTime() {
        return this.session.getCreationTime();
    }

    @Override
    public long getLastAccessedTime() {
        return this.session.getLastAccessedTime();
    }

    @Override
    public boolean isNew() {
        return this.session.isNew();
    }

    @Override
    public void removeAttribute(String name) {
        this.session.removeAttribute(name);
    }

    @Override
    public void setMaxInactiveInterval(int interval) {
        this.session.setMaxInactiveInterval(interval);
    }
}

