/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.polymertemplate;

import com.vaadin.flow.component.polymertemplate.AbstractTemplate;
import com.vaadin.flow.component.polymertemplate.Id;
import com.vaadin.flow.internal.AnnotationReader;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.jsoup.nodes.Element;

public class IdCollector {
    private final Map<String, String> tagById = new HashMap<String, String>();
    private final Map<Field, String> idByField = new HashMap<Field, String>();
    private Element templateRoot;
    private Class<?> templateClass;
    private String templateFile;

    public IdCollector(Class<?> templateClass, String templateFile, Element templateRoot) {
        this.templateClass = templateClass;
        this.templateFile = templateFile;
        this.templateRoot = templateRoot;
    }

    public void collectInjectedIds(Set<String> notInjectableElementIds) {
        this.collectInjectedIds(this.templateClass, notInjectableElementIds);
    }

    private void collectInjectedIds(Class<?> cls, Set<String> notInjectableElementIds) {
        if (!AbstractTemplate.class.equals(cls.getSuperclass())) {
            this.collectInjectedIds(cls.getSuperclass(), notInjectableElementIds);
        }
        Stream.of(cls.getDeclaredFields()).filter(field -> !field.isSynthetic()).forEach(field -> this.collectedInjectedId((Field)field, notInjectableElementIds));
    }

    private void collectedInjectedId(Field field, Set<String> notInjectableElementIds) {
        Optional<Id> idAnnotation = AnnotationReader.getAnnotationFor(field, Id.class);
        if (!idAnnotation.isPresent()) {
            return;
        }
        String id = idAnnotation.get().value();
        boolean emptyValue = id.isEmpty();
        if (emptyValue) {
            id = field.getName();
        }
        if (notInjectableElementIds.contains(id)) {
            throw new IllegalStateException(String.format("Class '%s' contains field '%s' annotated with @Id%s. Corresponding element was found in a sub template, for which injection is not supported.", this.templateClass.getName(), field.getName(), emptyValue ? " without value (so the name of the field should match the id of an element in the template)" : "(\"" + id + "\")"));
        }
        if (!this.addTagName(id, field)) {
            throw new IllegalStateException(String.format("There is no element with id='%s' in the template file '%s'. Cannot map it using @%s", id, this.templateFile, Id.class.getSimpleName()));
        }
    }

    private boolean addTagName(String id, Field field) {
        this.idByField.put(field, id);
        if (this.templateRoot != null) {
            Optional<String> tagName = Optional.ofNullable(this.templateRoot.getElementById(id)).map(Element::tagName);
            if (tagName.isPresent()) {
                this.tagById.put(id, tagName.get());
            }
            return tagName.isPresent();
        }
        return true;
    }

    public Map<Field, String> getIdByField() {
        return this.idByField;
    }

    public Map<String, String> getTagById() {
        return this.tagById;
    }
}

