/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.webcomponent;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.webcomponent.WebComponentConfiguration;
import com.vaadin.flow.server.webcomponent.PropertyData;
import com.vaadin.flow.server.webcomponent.UnsupportedPropertyTypeException;
import com.vaadin.flow.shared.util.SharedUtil;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;

public class WebComponentGenerator {
    private static final String HTML_TEMPLATE = "webcomponent-template.html";
    private static final String JS_TEMPLATE = "webcomponent-template.js";
    private static final String SCRIPT_TEMPLATE = "webcomponent-script-template.js";
    private static final String INDENTATION = "    ";

    private WebComponentGenerator() {
    }

    private static String getStringResource(String name) {
        try {
            return IOUtils.toString((InputStream)WebComponentGenerator.class.getResourceAsStream(name), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Couldn't load string resource '" + name + "'!", e);
        }
    }

    private static String getTemplate(boolean compatibilityMode) {
        String templateHead = compatibilityMode ? WebComponentGenerator.getStringResource(HTML_TEMPLATE) : WebComponentGenerator.getStringResource(JS_TEMPLATE);
        String scriptTemplate = WebComponentGenerator.getStringResource(SCRIPT_TEMPLATE);
        return templateHead.replace("_script_template_", scriptTemplate);
    }

    public static String generateModule(Class<? extends WebComponentExporter<? extends Component>> exporterClass, String frontendURI, boolean compatibilityMode) {
        Objects.requireNonNull(exporterClass);
        Objects.requireNonNull(frontendURI);
        WebComponentConfiguration<? extends Component> config = new WebComponentExporter.WebComponentConfigurationFactory().create(exporterClass);
        return WebComponentGenerator.generateModule(config, frontendURI, false, compatibilityMode);
    }

    public static String generateModule(WebComponentConfiguration<? extends Component> webComponentConfiguration, String frontendURI, boolean compatibilityMode) {
        Objects.requireNonNull(webComponentConfiguration);
        Objects.requireNonNull(frontendURI);
        return WebComponentGenerator.generateModule(webComponentConfiguration, frontendURI, true, compatibilityMode);
    }

    private static String generateModule(WebComponentConfiguration<? extends Component> webComponentConfiguration, String frontendURI, boolean generateUiImport, boolean compatibilityMode) {
        Objects.requireNonNull(webComponentConfiguration);
        Objects.requireNonNull(frontendURI);
        Set<PropertyData<? extends Serializable>> propertyDataSet = webComponentConfiguration.getPropertyDataSet();
        Map<String, String> replacements = WebComponentGenerator.getReplacementsMap(webComponentConfiguration.getTag(), propertyDataSet, frontendURI, generateUiImport);
        String template = WebComponentGenerator.getTemplate(compatibilityMode);
        for (Map.Entry<String, String> replacement : replacements.entrySet()) {
            template = template.replace("_" + replacement.getKey() + "_", replacement.getValue());
        }
        return template;
    }

    static Map<String, String> getReplacementsMap(String tag, Set<PropertyData<? extends Serializable>> propertyDataSet, String frontendURI, boolean generateUiImport) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("TagDash", tag);
        replacements.put("TagCamel", SharedUtil.capitalize(SharedUtil.dashSeparatedToCamelCase(tag)));
        replacements.put("PropertyMethods", WebComponentGenerator.getPropertyMethods(propertyDataSet.stream().map(PropertyData::getName)));
        replacements.put("Properties", WebComponentGenerator.getPropertyDefinitions(propertyDataSet));
        replacements.put("frontend_resources", frontendURI);
        replacements.put("ui_import", generateUiImport ? "<link rel='import' href='web-component-ui.html'>" : "");
        return replacements;
    }

    private static String getPropertyDefinitions(Set<PropertyData<?>> properties) {
        JsonObject props = Json.createObject();
        for (PropertyData<?> property : properties) {
            JsonObject prop = WebComponentGenerator.createPropertyDefinition(property);
            props.put(property.getName(), (JsonValue)prop);
        }
        return props.toJson();
    }

    private static JsonObject createPropertyDefinition(PropertyData<?> property) {
        JsonObject prop = Json.createObject();
        prop.put("type", property.getType().getSimpleName());
        if (property.getDefaultValue() != null) {
            String propertyValue = "value";
            if (property.getType() == Boolean.class) {
                prop.put(propertyValue, ((Boolean)property.getDefaultValue()).booleanValue());
            } else if (property.getType() == Double.class) {
                prop.put(propertyValue, ((Double)property.getDefaultValue()).doubleValue());
            } else if (property.getType() == Integer.class) {
                prop.put(propertyValue, (double)((Integer)property.getDefaultValue()).intValue());
            } else if (property.getType() == String.class) {
                prop.put(propertyValue, (String)property.getDefaultValue());
            } else if (JsonValue.class.isAssignableFrom(property.getType())) {
                prop.put(propertyValue, (JsonValue)property.getDefaultValue());
            } else {
                throw new UnsupportedPropertyTypeException(String.format("%s is not a currently supported type for a Property. Please use %s instead.", property.getType().getSimpleName(), JsonValue.class.getSimpleName()));
            }
        }
        prop.put("observer", WebComponentGenerator.getSyncMethod(property.getName()));
        prop.put("notify", true);
        prop.put("reflectToAttribute", false);
        return prop;
    }

    private static String getSyncMethod(String property) {
        return "_sync_" + SharedUtil.dashSeparatedToCamelCase(property);
    }

    private static String getPropertyMethods(Stream<String> properties) {
        StringBuilder methods = new StringBuilder();
        properties.forEach(property -> {
            methods.append(INDENTATION);
            methods.append(WebComponentGenerator.getSyncMethod(property));
            methods.append("(newValue, oldValue) { ");
            methods.append("this._sync('").append((String)property).append("', newValue);");
            methods.append("}\n");
        });
        return methods.toString();
    }
}

