/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.RouteAliasData;
import com.vaadin.flow.router.RouteBaseData;
import com.vaadin.flow.router.RouteData;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.RoutesChangedEvent;
import com.vaadin.flow.router.RoutesChangedListener;
import com.vaadin.flow.router.internal.ConfigureRoutes;
import com.vaadin.flow.router.internal.ConfiguredRoutes;
import com.vaadin.flow.router.internal.ErrorTargetEntry;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.InvalidRouteLayoutConfigurationException;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.startup.RouteTarget;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractRouteRegistry
implements RouteRegistry {
    private final ReentrantLock configurationLock = new ReentrantLock(true);
    private volatile ConfiguredRoutes configuredRoutes = new ConfiguredRoutes();
    private volatile ConfigureRoutes editing = null;
    private CopyOnWriteArrayList<RoutesChangedListener> routesChangedListeners = new CopyOnWriteArrayList();

    protected void configure(Configuration command) {
        this.lock();
        try {
            if (this.editing == null) {
                this.editing = new ConfigureRoutes(this.configuredRoutes);
            }
            command.configure(this.editing);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void update(Command command) {
        this.lock();
        try {
            command.execute();
        }
        finally {
            this.unlock();
        }
    }

    private void lock() {
        this.configurationLock.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void unlock() {
        if (this.configurationLock.getHoldCount() == 1 && this.editing != null) {
            try {
                ConfiguredRoutes oldConfiguration = this.configuredRoutes;
                this.configuredRoutes = new ConfiguredRoutes(this.editing);
                if (this.routesChangedListeners.isEmpty()) return;
                List<RouteBaseData<?>> oldRoutes = this.flattenRoutes(this.getRegisteredRoutes(oldConfiguration));
                List<RouteBaseData<?>> newRoutes = this.flattenRoutes(this.getRegisteredRoutes(this.configuredRoutes));
                ArrayList added = new ArrayList();
                ArrayList removed = new ArrayList();
                oldRoutes.stream().filter(route -> !newRoutes.contains(route)).forEach(removed::add);
                newRoutes.stream().filter(route -> !oldRoutes.contains(route)).forEach(added::add);
                this.fireEvent(new RoutesChangedEvent(this, added, removed));
                return;
            }
            finally {
                this.editing = null;
                this.configurationLock.unlock();
            }
        } else {
            this.configurationLock.unlock();
        }
    }

    protected void fireEvent(RoutesChangedEvent routeChangedEvent) {
        this.routesChangedListeners.forEach(listener -> listener.routesChanged(routeChangedEvent));
    }

    @Override
    public Registration addRoutesChangeListener(RoutesChangedListener listener) {
        this.routesChangedListeners.add(listener);
        return () -> this.routesChangedListeners.remove(listener);
    }

    protected boolean hasLock() {
        return this.configurationLock.isHeldByCurrentThread();
    }

    public ConfiguredRoutes getConfiguration() {
        if (this.configurationLock.isHeldByCurrentThread() && this.editing != null) {
            return this.editing;
        }
        return this.configuredRoutes;
    }

    @Override
    public List<RouteData> getRegisteredRoutes() {
        return this.getRegisteredRoutes(this.getConfiguration());
    }

    private List<RouteData> getRegisteredRoutes(ConfiguredRoutes configuration) {
        ArrayList registeredRoutes = new ArrayList();
        configuration.getTargetRoutes().forEach((target, url) -> {
            List<Class<?>> parameters = this.getRouteParameters((Class<? extends Component>)target);
            ArrayList<RouteAliasData> routeAliases = new ArrayList<RouteAliasData>();
            configuration.getRoutePaths((Class<? extends Component>)target).stream().filter(route -> !route.equals(url)).forEach(route -> routeAliases.add(new RouteAliasData(this.getParentLayouts(configuration, (Class<? extends Component>)target, (String)route), (String)route, parameters, (Class<? extends Component>)target)));
            List<Class<? extends RouterLayout>> parentLayouts = this.getParentLayouts(configuration, (Class<? extends Component>)target, (String)url);
            RouteData route2 = new RouteData(parentLayouts, (String)url, parameters, (Class<? extends Component>)target, (List<RouteAliasData>)routeAliases);
            registeredRoutes.add(route2);
        });
        Collections.sort(registeredRoutes);
        return Collections.unmodifiableList(registeredRoutes);
    }

    private List<RouteBaseData<?>> flattenRoutes(List<RouteData> routeData) {
        ArrayList flatRoutes = new ArrayList();
        for (RouteData route : routeData) {
            RouteData nonAliasCollection = new RouteData(route.getParentLayouts(), route.getUrl(), route.getParameters(), route.getNavigationTarget(), Collections.emptyList());
            flatRoutes.add(nonAliasCollection);
            route.getRouteAliases().forEach(flatRoutes::add);
        }
        return flatRoutes;
    }

    private List<Class<? extends RouterLayout>> getParentLayouts(ConfiguredRoutes configuration, Class<? extends Component> target, String url) {
        RouteTarget routeTarget = configuration.getRouteTarget(url);
        if (routeTarget != null) {
            return routeTarget.getParentLayouts(target);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Class<? extends RouterLayout>> getRouteLayouts(String path, Class<? extends Component> navigationTarget) {
        if (this.getConfiguration().hasRoute(path)) {
            return this.getConfiguration().getParentLayouts(path, navigationTarget);
        }
        return Collections.emptyList();
    }

    private List<Class<?>> getRouteParameters(Class<? extends Component> target) {
        ArrayList parameters = new ArrayList();
        if (HasUrlParameter.class.isAssignableFrom(target)) {
            Class<?> genericInterfaceType = ReflectTools.getGenericInterfaceType(target, HasUrlParameter.class);
            parameters.add(genericInterfaceType);
        }
        return parameters;
    }

    @Override
    public Optional<String> getTargetUrl(Class<? extends Component> navigationTarget) {
        Objects.requireNonNull(navigationTarget, "Target must not be null.");
        return Optional.ofNullable(this.collectRequiredParameters(navigationTarget));
    }

    private String collectRequiredParameters(Class<? extends Component> navigationTarget) {
        if (!this.getConfiguration().hasRouteTarget(navigationTarget)) {
            return null;
        }
        StringBuilder route = new StringBuilder(this.getConfiguration().getTargetRoute(navigationTarget));
        List<Class<?>> routeParameters = this.getRouteParameters(navigationTarget);
        if (!routeParameters.isEmpty()) {
            routeParameters.forEach(param -> route.append("/{").append(param.getSimpleName()).append("}"));
        }
        return route.toString();
    }

    @Override
    public void setRoute(String path, Class<? extends Component> navigationTarget, List<Class<? extends RouterLayout>> parentChain) {
        this.configure(configuration -> {
            RouteTarget routeTarget = this.addRouteToConfiguration(path, navigationTarget, configuration);
            routeTarget.setParentLayouts(navigationTarget, parentChain);
        });
    }

    @Override
    public void removeRoute(Class<? extends Component> routeTarget) {
        if (!this.getConfiguration().hasRouteTarget(routeTarget)) {
            return;
        }
        this.configure(configuration -> configuration.removeRoute(routeTarget));
    }

    @Override
    public void removeRoute(String path) {
        if (!this.getConfiguration().hasRoute(path)) {
            return;
        }
        this.configure(configuration -> configuration.removeRoute(path));
    }

    @Override
    public void removeRoute(String path, Class<? extends Component> navigationTarget) {
        if (!this.getConfiguration().hasRoute(path)) {
            return;
        }
        this.configure(configuration -> configuration.removeRoute(path, navigationTarget));
    }

    @Override
    public void clean() {
        this.configure(ConfigureRoutes::clear);
    }

    private RouteTarget addRouteToConfiguration(String path, Class<? extends Component> navigationTarget, ConfigureRoutes configuration) {
        if (!this.hasLock()) {
            throw new IllegalStateException("addRouteToConfiguration requires the registry lock and a mutable configuration.");
        }
        configuration.setRoute(path, navigationTarget);
        if (!configuration.hasRouteTarget(navigationTarget)) {
            configuration.setTargetRoute(navigationTarget, path);
        }
        return configuration.getRouteTarget(path);
    }

    protected void addErrorTarget(Class<? extends Component> target, Map<Class<? extends Exception>, Class<? extends Component>> exceptionTargetsMap) {
        Class<Exception> exceptionType = ReflectTools.getGenericInterfaceType(target, HasErrorParameter.class).asSubclass(Exception.class);
        if (exceptionTargetsMap.containsKey(exceptionType)) {
            this.handleRegisteredExceptionType(exceptionTargetsMap, target, exceptionType);
        } else {
            exceptionTargetsMap.put(exceptionType, target);
        }
    }

    private void handleRegisteredExceptionType(Map<Class<? extends Exception>, Class<? extends Component>> exceptionTargetsMap, Class<? extends Component> target, Class<? extends Exception> exceptionType) {
        Class<? extends Component> registered = exceptionTargetsMap.get(exceptionType);
        if (registered.isAssignableFrom(target)) {
            exceptionTargetsMap.put(exceptionType, target);
        } else if (!target.isAssignableFrom(registered)) {
            String msg = String.format("Only one target for an exception should be defined. Found '%s' and '%s' for exception '%s'", target.getName(), registered.getName(), exceptionType.getName());
            throw new InvalidRouteLayoutConfigurationException(msg);
        }
    }

    protected Optional<ErrorTargetEntry> searchByCause(Exception exception) {
        Class<? extends Component> targetClass = this.getConfiguration().getExceptionHandlerByClass(exception.getClass());
        if (targetClass != null) {
            return Optional.of(new ErrorTargetEntry(targetClass, exception.getClass()));
        }
        Throwable cause = exception.getCause();
        if (cause instanceof Exception) {
            return this.searchByCause((Exception)cause);
        }
        return Optional.empty();
    }

    protected Optional<ErrorTargetEntry> searchBySuperType(Throwable exception) {
        for (Class<?> superClass = exception.getClass().getSuperclass(); superClass != null && Exception.class.isAssignableFrom(superClass); superClass = superClass.getSuperclass()) {
            Class<? extends Component> targetClass = this.getConfiguration().getExceptionHandlerByClass(superClass);
            if (targetClass == null) continue;
            return Optional.of(new ErrorTargetEntry(targetClass, superClass.asSubclass(Exception.class)));
        }
        return Optional.empty();
    }

    @FunctionalInterface
    public static interface Configuration
    extends Serializable {
        public void configure(ConfigureRoutes var1);
    }
}

