/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.NodeUpdater;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;

public class TaskCreatePackageJson
extends NodeUpdater {
    protected static final String FORCE_INSTALL_HASH = "Main dependencies updated, force install";

    TaskCreatePackageJson(File npmFolder, File generatedPath) {
        super(null, null, npmFolder, generatedPath);
    }

    @Override
    public void execute() {
        try {
            JsonObject customContent;
            this.modified = false;
            JsonObject mainContent = this.getMainPackageJson();
            if (mainContent == null) {
                mainContent = Json.createObject();
            }
            this.modified = this.updateMainDefaultDependencies(mainContent);
            if (this.modified) {
                if (mainContent.hasKey("vaadinAppPackageHash")) {
                    this.log().debug("Main dependencies updated. Forcing npm install.");
                    mainContent.put("vaadinAppPackageHash", FORCE_INSTALL_HASH);
                } else {
                    mainContent.put("vaadinAppPackageHash", "");
                }
                this.writeMainPackageFile(mainContent);
            }
            if ((customContent = this.getAppPackageJson()) == null) {
                customContent = Json.createObject();
                this.updateAppDefaultDependencies(customContent);
                this.writeAppPackageFile(customContent);
                this.modified = true;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

