/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.scanner;

import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.frontend.scanner.AbstractDependenciesScanner;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.CssData;
import com.vaadin.flow.server.frontend.scanner.EndPointData;
import com.vaadin.flow.server.frontend.scanner.FrontendAnnotatedClassVisitor;
import com.vaadin.flow.server.frontend.scanner.FrontendClassVisitor;
import com.vaadin.flow.server.frontend.scanner.ThemeData;
import com.vaadin.flow.server.frontend.scanner.ThemeWrapper;
import com.vaadin.flow.theme.AbstractTheme;
import com.vaadin.flow.theme.NoTheme;
import com.vaadin.flow.theme.ThemeDefinition;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.bytebuddy.jar.asm.ClassReader;
import net.bytebuddy.jar.asm.ClassVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontendDependencies
extends AbstractDependenciesScanner {
    private final HashMap<String, EndPointData> endPoints = new HashMap();
    private ThemeDefinition themeDefinition;
    private AbstractTheme themeInstance;
    private final HashMap<String, String> packages = new HashMap();
    private final Set<String> visited = new HashSet<String>();

    public FrontendDependencies(ClassFinder finder) {
        this(finder, true);
    }

    public FrontendDependencies(ClassFinder finder, boolean generateEmbeddableWebComponents) {
        super(finder);
        FrontendDependencies.log().info("Scanning classes to find frontend configurations and dependencies...");
        long start = System.nanoTime();
        try {
            this.computeEndpoints();
            this.computeApplicationTheme(this.endPoints);
            this.computePackages();
            if (generateEmbeddableWebComponents) {
                this.computeExporters();
            }
            long ms = (System.nanoTime() - start) / 1000000L;
            FrontendDependencies.log().info("Visited {} classes. Took {} ms.", (Object)this.visited.size(), (Object)ms);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Unable to compute frontend dependencies", e);
        }
    }

    @Override
    public Map<String, String> getPackages() {
        return this.packages;
    }

    @Override
    public List<String> getModules() {
        LinkedHashSet<String> all = new LinkedHashSet<String>();
        for (EndPointData data : this.endPoints.values()) {
            all.addAll(data.getThemeModules());
        }
        for (EndPointData data : this.endPoints.values()) {
            all.addAll(data.getModules());
        }
        return new ArrayList<String>(all);
    }

    @Override
    public Set<String> getScripts() {
        LinkedHashSet<String> all = new LinkedHashSet<String>();
        for (EndPointData data : this.endPoints.values()) {
            all.addAll(data.getScripts());
        }
        return all;
    }

    @Override
    public Set<CssData> getCss() {
        LinkedHashSet<CssData> all = new LinkedHashSet<CssData>();
        for (EndPointData data : this.endPoints.values()) {
            all.addAll(data.getCss());
        }
        return all;
    }

    @Override
    public Set<String> getClasses() {
        return this.visited;
    }

    public Collection<EndPointData> getEndPoints() {
        return this.endPoints.values();
    }

    @Override
    public ThemeDefinition getThemeDefinition() {
        return this.themeDefinition;
    }

    @Override
    public AbstractTheme getTheme() {
        return this.themeInstance;
    }

    private void computeEndpoints() throws ClassNotFoundException, IOException {
        Class routeClass = this.getFinder().loadClass(Route.class.getName());
        for (Class<?> clazz : this.getFinder().getAnnotatedClasses(routeClass)) {
            this.collectEndpoints(clazz);
        }
        for (Class<Object> clazz : this.getFinder().getSubTypesOf(this.getFinder().loadClass(UIInitListener.class.getName()))) {
            this.collectEndpoints(clazz);
        }
        for (Class<Object> clazz : this.getFinder().getSubTypesOf(this.getFinder().loadClass(VaadinServiceInitListener.class.getName()))) {
            this.collectEndpoints(clazz);
        }
    }

    private void collectEndpoints(Class<?> entry) throws IOException {
        String className = entry.getName();
        EndPointData data = new EndPointData(entry);
        this.endPoints.put(className, this.visitClass(className, data, false));
    }

    private void computeApplicationTheme(HashMap<String, EndPointData> endPoints) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        for (EndPointData endPoint : endPoints.values()) {
            if (endPoint.getLayout() != null) {
                this.visitClass(endPoint.getLayout(), endPoint, false);
            }
            if (endPoint.getTheme() == null) continue;
            this.visitClass(endPoint.getTheme().getName(), endPoint, true);
        }
        Set themes = endPoints.values().stream().filter(data -> data.getTheme().getName() != null || data.getTheme().isNotheme()).map(data -> data.getTheme()).collect(Collectors.toSet());
        if (themes.size() > 1) {
            String names = String.join((CharSequence)"\n      ", endPoints.values().stream().filter(data -> data.getTheme().getName() != null || data.getTheme().isNotheme()).map(data -> "found '" + (data.getTheme().isNotheme() ? NoTheme.class.getName() : data.getTheme().getName()) + "' in '" + data.getName() + "'").collect(Collectors.toList()));
            throw new IllegalStateException("\n Multiple Theme configuration is not supported:\n      " + names);
        }
        Class<AbstractTheme> theme = null;
        String variant = "";
        if (themes.isEmpty()) {
            theme = this.getDefaultTheme();
        } else {
            ThemeData themeData = (ThemeData)themes.iterator().next();
            if (!themeData.isNotheme()) {
                variant = themeData.getVariant();
                theme = this.getFinder().loadClass(themeData.getName());
            }
        }
        if (theme != null) {
            this.themeDefinition = new ThemeDefinition(theme, variant);
            this.themeInstance = new ThemeWrapper(theme);
        }
    }

    private Class<? extends AbstractTheme> getDefaultTheme() throws IOException {
        Optional<EndPointData> endPointData;
        Class<? extends AbstractTheme> defaultTheme = this.getLumoTheme();
        if (defaultTheme != null && (endPointData = this.endPoints.values().stream().findFirst()).isPresent()) {
            this.visitClass(defaultTheme.getName(), endPointData.get(), true);
            return defaultTheme;
        }
        return null;
    }

    private void computePackages() throws ClassNotFoundException, IOException {
        FrontendAnnotatedClassVisitor npmPackageVisitor = new FrontendAnnotatedClassVisitor(this.getFinder(), NpmPackage.class.getName());
        for (Class<?> component : this.getFinder().getAnnotatedClasses(NpmPackage.class.getName())) {
            npmPackageVisitor.visitClass(component.getName());
        }
        Set dependencies = npmPackageVisitor.getValues("value");
        for (String dependency : dependencies) {
            Set versions = npmPackageVisitor.getValuesForKey("value", dependency, "version");
            String version = (String)versions.iterator().next();
            if (versions.size() > 1) {
                String foundVersions = versions.toString();
                FrontendDependencies.log().warn("Multiple npm versions for {} found:  {}. First version found '{}' will be considered.", new Object[]{dependency, foundVersions, version});
            }
            this.packages.put(dependency, version);
        }
    }

    private static Logger log() {
        return LoggerFactory.getLogger((String)"dev-updater");
    }

    private void computeExporters() throws ClassNotFoundException, IOException, IllegalAccessException, InstantiationException {
        Class routeClass = this.getFinder().loadClass(Route.class.getName());
        Class exporterClass = this.getFinder().loadClass(WebComponentExporter.class.getName());
        Set exporterClasses = this.getFinder().getSubTypesOf(exporterClass);
        if (exporterClasses.isEmpty()) {
            return;
        }
        HashMap<String, EndPointData> exportedPoints = new HashMap<String, EndPointData>();
        for (Class exporter : exporterClasses) {
            Class<?> componentClass;
            String exporterClassName = exporter.getName();
            EndPointData exporterData = new EndPointData(exporter);
            exportedPoints.put(exporterClassName, this.visitClass(exporterClassName, exporterData, false));
            if (Modifier.isAbstract(exporter.getModifiers()) || (componentClass = ReflectTools.getGenericInterfaceType(exporter, exporterClass)) == null || componentClass.isAnnotationPresent(routeClass)) continue;
            String componentClassName = componentClass.getName();
            EndPointData configurationData = new EndPointData(componentClass);
            exportedPoints.put(componentClassName, this.visitClass(componentClassName, configurationData, false));
        }
        this.computeApplicationTheme(exportedPoints);
        this.endPoints.putAll(exportedPoints);
    }

    private EndPointData visitClass(String className, EndPointData endPoint, boolean themeScope) throws IOException {
        if (!this.isVisitable(className) || !themeScope && endPoint.getClasses().contains(className)) {
            return endPoint;
        }
        endPoint.getClasses().add(className);
        URL url = this.getUrl(className);
        if (url == null) {
            return endPoint;
        }
        FrontendClassVisitor visitor = new FrontendClassVisitor(className, endPoint, themeScope);
        ClassReader cr = new ClassReader(url.openStream());
        cr.accept((ClassVisitor)visitor, 8);
        this.visited.add(className);
        for (String clazz : visitor.getChildren()) {
            if (this.visited.contains(clazz)) continue;
            this.visitClass(clazz, endPoint, themeScope);
        }
        return endPoint;
    }

    private boolean isVisitable(String className) {
        return className != null && !className.matches("(^$|.*(slf4j).*|^(java|sun|elemental|javax|org.(apache|atmosphere|jsoup|jboss|w3c|spring|joda|hibernate|glassfish|hsqldb)|com.(helger|spring|gwt|lowagie|fasterxml)|net.(sf|bytebuddy)).*|.*(Exception)$)");
    }

    private URL getUrl(String className) {
        return this.getFinder().getResource(className.replace(".", "/") + ".class");
    }

    public String toString() {
        return this.endPoints.toString();
    }
}

