/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.webcomponent;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.webcomponent.WebComponentUI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementUtil;
import com.vaadin.flow.server.webcomponent.WebComponentBinding;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonValue;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.LoggerFactory;

public class WebComponentWrapper
extends Component {
    private Component child;
    private WebComponentBinding<?> webComponentBinding;
    private Registration disconnectRegistration;
    private long disconnect;

    public WebComponentWrapper(Element rootElement, WebComponentBinding<?> binding) {
        super(rootElement);
        Objects.requireNonNull(binding, "Parameter 'binding' must not be null!");
        this.webComponentBinding = binding;
        this.child = this.webComponentBinding.getComponent();
        this.getElement().appendChild(this.child.getElement());
    }

    @ClientCallable
    public void sync(String property, JsonValue newValue) {
        try {
            this.webComponentBinding.updateProperty(property, newValue);
        }
        catch (IllegalArgumentException e) {
            LoggerFactory.getLogger(this.child.getClass()).error("Failed to synchronise property '{}'", (Object)property, (Object)e);
        }
    }

    @ClientCallable
    public void reconnect() {
        if (this.disconnectRegistration != null) {
            this.disconnectRegistration.remove();
        } else {
            LoggerFactory.getLogger(WebComponentUI.class).warn("Received reconnect request for non disconnected WebComponent '{}'", (Object)this.child.getClass().getName());
        }
    }

    @ClientCallable
    public void disconnected() {
        Optional<UI> uiOptional = this.getUI();
        if (uiOptional.isPresent() && this.disconnectRegistration == null) {
            this.disconnect = System.currentTimeMillis();
            this.disconnectRegistration = uiOptional.get().getInternals().addHeartbeatListener(event -> {
                int disconnectTimeout = event.getSource().getSession().getConfiguration().getWebComponentDisconnect();
                int timeout = 1000 * disconnectTimeout;
                if (event.getSource().getInternals().getLastHeartbeatTimestamp() - this.disconnect > (long)timeout) {
                    ElementUtil.removeVirtualChildFromParent(this.getElement());
                    this.disconnectRegistration.remove();
                }
            });
        }
    }
}

