/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.DevModeHandler;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.frontend.FallbackChunk;
import com.vaadin.flow.server.frontend.FrontendToolsLocator;
import com.vaadin.flow.server.frontend.FrontendVersion;
import com.vaadin.flow.server.frontend.WebpackConnectionException;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontendUtils {
    public static final String PROJECT_BASEDIR = "project.basedir";
    public static final String DEFAULT_NODE_DIR = "./";
    public static final String NODE_MODULES = "node_modules/";
    public static final String FRONTEND = "frontend/";
    public static final String DEFAULT_FRONTEND_DIR = "./frontend/";
    public static final String WEBPACK_CONFIG = "webpack.config.js";
    public static final String WEBPACK_GENERATED = "webpack.generated.js";
    public static final String FLOW_NPM_PACKAGE_NAME = "@vaadin/flow-frontend/";
    public static final String TARGET = "target/";
    public static final String DEFAULT_GENERATED_DIR = "target/frontend/";
    public static final String IMPORTS_NAME = "generated-flow-imports.js";
    public static final String FALLBACK_IMPORTS_NAME = "generated-flow-imports-fallback.js";
    public static final String PARAM_GENERATED_DIR = "vaadin.frontend.generated.folder";
    public static final String PARAM_FRONTEND_DIR = "vaadin.frontend.frontend.folder";
    public static final String PARAM_IGNORE_VERSION_CHECKS = "vaadin.ignoreVersionChecks";
    public static final String WEBPACK_PREFIX_ALIAS = "Frontend/";
    public static final String TOKEN_FILE = "config/flow-build-info.json";
    public static final String CHUNKS = "chunks";
    public static final String FALLBACK = "fallback";
    public static final String CSS_IMPORTS = "cssImports";
    public static final String JS_MODULES = "jsModules";
    public static final String PARAM_TOKEN_FILE = "vaadin.frontend.token.file";
    public static final String INSTALL_NODE_LOCALLY = "%n  $ mvn com.github.eirslett:frontend-maven-plugin:1.7.6:install-node-and-npm -DnodeVersion=\"v12.14.0\" ";
    public static final String DISABLE_CHECK = "%nYou can disable the version check using -D%s=true";
    private static final String NO_CONNECTION = "Webpack-dev-server couldn't be reached for %s.%nCheck the startup logs for exceptions in running webpack-dev-server.%nIf server should be running in production mode check that production mode flag is set correctly.";
    private static final String NODE_NOT_FOUND = "%n%n======================================================================================================%nVaadin requires node.js & npm to be installed. Please install the latest LTS version of node.js (with npm) either by:%n  1) following the https://nodejs.org/en/download/ guide to install it globally. This is the recommended way.%n  2) running the following Maven plugin goal to install it in this project:%n  $ mvn com.github.eirslett:frontend-maven-plugin:1.7.6:install-node-and-npm -DnodeVersion=\"v12.14.0\" %n%nNote that in case you don't install it globally, you'll need to install it again for another Vaadin project.%nIn case you have just installed node.js globally, it was not discovered, so you need to restart your system to get the path variables updated.%n======================================================================================================%n";
    private static final String SHOULD_WORK = "%n%n======================================================================================================%nYour installed '%s' version (%s) is not supported but should still work. Supported versions are %d.%d+%nYou can install a new one:%n  - by following the https://nodejs.org/en/download/ guide to install it globally%n  - or by running the frontend-maven-plugin goal to install it in this project:%n  $ mvn com.github.eirslett:frontend-maven-plugin:1.7.6:install-node-and-npm -DnodeVersion=\"v12.14.0\" %n%nYou can disable the version check using -D%s=true%n======================================================================================================%n";
    private static final String TOO_OLD = "%n%n======================================================================================================%nYour installed '%s' version (%s) is too old. Supported versions are %d.%d+%nPlease install a new one either:%n  - by following the https://nodejs.org/en/download/ guide to install it globally%n  - or by running the frontend-maven-plugin goal to install it in this project:%n  $ mvn com.github.eirslett:frontend-maven-plugin:1.7.6:install-node-and-npm -DnodeVersion=\"v12.14.0\" %n%nYou can disable the version check using -D%s=true%n======================================================================================================%n";
    private static final String BAD_VERSION = "%n%n======================================================================================================%nYour installed '%s' version (%s) is known to have problems.%nPlease update to a new one either:%n  - by following the https://nodejs.org/en/download/ guide to install it globally%s%n  - or by running the frontend-maven-plugin goal to install it in this project:%n  $ mvn com.github.eirslett:frontend-maven-plugin:1.7.6:install-node-and-npm -DnodeVersion=\"v12.14.0\" %n%nYou can disable the version check using -D%s=true%n======================================================================================================%n";
    private static final List<FrontendVersion> NPM_BLACKLISTED_VERSIONS = Arrays.asList(new FrontendVersion("6.11.0"), new FrontendVersion("6.11.1"), new FrontendVersion("6.11.2"));
    private static final FrontendVersion SUPPORTED_NODE_VERSION = new FrontendVersion(10, 0);
    private static final FrontendVersion SHOULD_WORK_NODE_VERSION = new FrontendVersion(8, 9);
    private static final FrontendVersion SUPPORTED_NPM_VERSION = new FrontendVersion(5, 6);
    private static final FrontendVersion SHOULD_WORK_NPM_VERSION = new FrontendVersion(5, 5);
    private static FrontendToolsLocator frontendToolsLocator = new FrontendToolsLocator();
    private static String operatingSystem = null;

    private FrontendUtils() {
    }

    public static String getOsName() {
        if (operatingSystem == null) {
            operatingSystem = System.getProperty("os.name");
        }
        return operatingSystem;
    }

    public static boolean isWindows() {
        return FrontendUtils.getOsName().startsWith("Windows");
    }

    public static String getNodeExecutable(String baseDir) {
        String command = FrontendUtils.isWindows() ? "node.exe" : "node";
        String defaultNode = FrontendUtils.isWindows() ? "node/node.exe" : "node/node";
        return FrontendUtils.getExecutable(baseDir, command, defaultNode).getAbsolutePath();
    }

    public static List<String> getNpmExecutable(String baseDir) {
        File file = new File(baseDir, "node/node_modules/npm/bin/npm-cli.js");
        ArrayList<String> returnCommand = new ArrayList<String>();
        if (file.canRead()) {
            returnCommand.add(FrontendUtils.getNodeExecutable(baseDir));
            returnCommand.add(file.getAbsolutePath());
        } else {
            String command = FrontendUtils.isWindows() ? "npm.cmd" : "npm";
            returnCommand.add(FrontendUtils.getExecutable(baseDir, command, null).getAbsolutePath());
        }
        returnCommand.add("--no-update-notifier");
        returnCommand.add("--no-audit");
        return returnCommand;
    }

    public static List<String> getBowerExecutable(String baseDir) {
        File file = new File(baseDir, "node_modules/bower/bin/bower");
        if (file.canRead()) {
            return Arrays.asList(FrontendUtils.getNodeExecutable(baseDir), file.getAbsolutePath());
        }
        String command = FrontendUtils.isWindows() ? "bower.cmd" : "bower";
        return frontendToolsLocator.tryLocateTool(command).map(File::getPath).map(Collections::singletonList).orElse(Collections.emptyList());
    }

    private static File getExecutable(String baseDir, String cmd, String defaultLocation) {
        File file = null;
        try {
            file = defaultLocation == null ? (File)frontendToolsLocator.tryLocateTool(cmd).orElse(null) : Optional.of(new File(baseDir, defaultLocation)).filter(frontendToolsLocator::verifyTool).orElseGet(() -> frontendToolsLocator.tryLocateTool(cmd).orElse(null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (file == null) {
            throw new IllegalStateException(String.format(NODE_NOT_FOUND, new Object[0]));
        }
        return file;
    }

    public static String streamToString(InputStream inputStream) {
        String ret = "";
        try {
            return IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8).replaceAll("\\R", System.lineSeparator());
        }
        catch (IOException exception) {
            LoggerFactory.getLogger(FrontendUtils.class).warn("Couldn't close template input stream", (Throwable)exception);
            return ret;
        }
    }

    public static ProcessBuilder createProcessBuilder(List<String> command) {
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        File commandFile = new File(command.get(0));
        if (commandFile.isAbsolute()) {
            String pathEnvVar;
            String commandPath = commandFile.getParent();
            Map<String, String> environment = processBuilder.environment();
            String path = environment.get(pathEnvVar = FrontendUtils.isWindows() ? environment.keySet().stream().filter("PATH"::equalsIgnoreCase).findFirst().orElse("Path") : "PATH");
            if (path == null || path.isEmpty()) {
                path = commandPath;
            } else if (!path.contains(commandPath)) {
                path = path + File.pathSeparatorChar + commandPath;
            }
            environment.put(pathEnvVar, path);
        }
        return processBuilder;
    }

    public static String getStatsContent(VaadinService service) throws IOException {
        DeploymentConfiguration config = service.getDeploymentConfiguration();
        InputStream content = null;
        if (!config.isProductionMode() && config.enableDevServer()) {
            content = FrontendUtils.getStatsFromWebpack();
        }
        if (content == null) {
            content = FrontendUtils.getStatsFromClassPath(service);
        }
        return content != null ? IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8) : null;
    }

    public static String getStatsHash(VaadinService service) throws IOException {
        DeploymentConfiguration config = service.getDeploymentConfiguration();
        if (!config.isProductionMode() && config.enableDevServer()) {
            DevModeHandler handler = DevModeHandler.getDevModeHandler();
            HttpURLConnection statsConnection = handler.prepareConnection("/stats.hash", "GET");
            if (statsConnection.getResponseCode() != 200) {
                throw new WebpackConnectionException(String.format(NO_CONNECTION, "getting the stats content hash."));
            }
            return FrontendUtils.streamToString(statsConnection.getInputStream()).replaceAll("\"", "");
        }
        return "";
    }

    private static InputStream getStatsFromWebpack() throws IOException {
        DevModeHandler handler = DevModeHandler.getDevModeHandler();
        HttpURLConnection statsConnection = handler.prepareConnection("/stats.json", "GET");
        if (statsConnection.getResponseCode() != 200) {
            throw new WebpackConnectionException(String.format(NO_CONNECTION, "downloading stats.json"));
        }
        return statsConnection.getInputStream();
    }

    private static InputStream getStatsFromClassPath(VaadinService service) {
        String stats = service.getDeploymentConfiguration().getStringProperty("statistics.file.path", "META-INF/VAADIN/config/stats.json").replaceFirst("^/", "");
        InputStream stream = service.getClassLoader().getResourceAsStream(stats);
        if (stream == null) {
            FrontendUtils.getLogger().error("Cannot get the 'stats.json' from the classpath '{}'", (Object)stats);
        }
        return stream;
    }

    public static String getStatsAssetsByChunkName(VaadinService service) throws IOException {
        DeploymentConfiguration config = service.getDeploymentConfiguration();
        if (!config.isProductionMode() && config.enableDevServer()) {
            DevModeHandler handler = DevModeHandler.getDevModeHandler();
            HttpURLConnection assetsConnection = handler.prepareConnection("/assetsByChunkName", "GET");
            if (assetsConnection.getResponseCode() != 200) {
                throw new WebpackConnectionException(String.format(NO_CONNECTION, "getting assets by chunk name."));
            }
            return FrontendUtils.streamToString(assetsConnection.getInputStream());
        }
        InputStream resourceAsStream = FrontendUtils.getStatsFromClassPath(service);
        if (resourceAsStream == null) {
            return null;
        }
        try (Scanner scan = new Scanner(resourceAsStream, StandardCharsets.UTF_8.name());){
            StringBuilder assets = new StringBuilder();
            assets.append("{");
            FrontendUtils.scanToAssetChunkStart(scan, assets);
            while (scan.hasNextLine()) {
                String line = scan.nextLine().trim();
                if ("}".equals(line) || "},".equals(line)) {
                    String string = assets.append("}").toString();
                    return string;
                }
                if (line.endsWith("}") || line.endsWith("},")) {
                    String string = assets.append(line.substring(0, line.indexOf(125)).trim()).append("}").toString();
                    return string;
                }
                if (line.contains("{")) break;
                assets.append(line);
            }
            FrontendUtils.getLogger().error("Could not parse assetsByChunkName from stats.json");
        }
        return null;
    }

    private static void scanToAssetChunkStart(Scanner scan, StringBuilder assets) {
        do {
            String line;
            if (!(line = scan.nextLine().trim()).startsWith("\"assetsByChunkName\"")) continue;
            if (line.endsWith("{")) break;
            assets.append(line.substring(line.indexOf(123) + 1).trim());
            break;
        } while (scan.hasNextLine());
    }

    public static void validateNodeAndNpmVersion(String baseDir) {
        try {
            ArrayList<String> nodeVersionCommand = new ArrayList<String>();
            nodeVersionCommand.add(FrontendUtils.getNodeExecutable(baseDir));
            nodeVersionCommand.add("--version");
            FrontendVersion nodeVersion = FrontendUtils.getVersion("node", nodeVersionCommand);
            FrontendUtils.validateToolVersion("node", nodeVersion, SUPPORTED_NODE_VERSION, SHOULD_WORK_NODE_VERSION);
        }
        catch (UnknownVersionException e) {
            FrontendUtils.getLogger().warn("Error checking if node is new enough", (Throwable)e);
        }
        try {
            ArrayList<String> npmVersionCommand = new ArrayList<String>(FrontendUtils.getNpmExecutable(baseDir));
            npmVersionCommand.add("--version");
            FrontendVersion npmVersion = FrontendUtils.getVersion("npm", npmVersionCommand);
            FrontendUtils.validateToolVersion("npm", npmVersion, SUPPORTED_NPM_VERSION, SHOULD_WORK_NPM_VERSION);
            FrontendUtils.checkForFaultyNpmVersion(npmVersion);
        }
        catch (UnknownVersionException e) {
            FrontendUtils.getLogger().warn("Error checking if npm is new enough", (Throwable)e);
        }
    }

    static void checkForFaultyNpmVersion(FrontendVersion npmVersion) {
        if (NPM_BLACKLISTED_VERSIONS.contains(npmVersion)) {
            String badNpmVersion = FrontendUtils.buildBadVersionString("npm", npmVersion.getFullVersion(), "by updating your global npm installation with `npm install -g npm@latest`");
            throw new IllegalStateException(badNpmVersion);
        }
    }

    private static String buildTooOldString(String tool, String version, int supportedMajor, int supportedMinor) {
        return String.format(TOO_OLD, tool, version, supportedMajor, supportedMinor, PARAM_IGNORE_VERSION_CHECKS);
    }

    private static String buildShouldWorkString(String tool, String version, int supportedMajor, int supportedMinor) {
        return String.format(SHOULD_WORK, tool, version, supportedMajor, supportedMinor, PARAM_IGNORE_VERSION_CHECKS);
    }

    private static String buildBadVersionString(String tool, String version, String ... extraUpdateInstructions) {
        StringBuilder extraInstructions = new StringBuilder();
        for (String instruction : extraUpdateInstructions) {
            extraInstructions.append("%n  - or ").append(instruction);
        }
        return String.format(BAD_VERSION, tool, version, extraInstructions.toString(), PARAM_IGNORE_VERSION_CHECKS);
    }

    public static boolean isWebpackConfigFile(File file) throws IOException {
        return file.exists() && FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8).contains("./webpack.generated.js");
    }

    public static FallbackChunk readFallbackChunk(JsonObject object) {
        if (!object.hasKey(CHUNKS)) {
            return null;
        }
        JsonObject obj = object.getObject(CHUNKS);
        if (!obj.hasKey(FALLBACK)) {
            return null;
        }
        obj = obj.getObject(FALLBACK);
        ArrayList<String> fallbackModles = new ArrayList<String>();
        JsonArray modules = obj.getArray(JS_MODULES);
        for (int i = 0; i < modules.length(); ++i) {
            fallbackModles.add(modules.getString(i));
        }
        ArrayList<FallbackChunk.CssImportData> fallbackCss = new ArrayList<FallbackChunk.CssImportData>();
        JsonArray css = obj.getArray(CSS_IMPORTS);
        for (int i = 0; i < css.length(); ++i) {
            fallbackCss.add(FrontendUtils.createCssData(css.getObject(i)));
        }
        return new FallbackChunk(fallbackModles, fallbackCss);
    }

    private static FallbackChunk.CssImportData createCssData(JsonObject object) {
        String value = null;
        String id = null;
        String include = null;
        String themeFor = null;
        if (object.hasKey("value")) {
            value = object.getString("value");
        }
        if (object.hasKey("id")) {
            id = object.getString("id");
        }
        if (object.hasKey("include")) {
            include = object.getString("include");
        }
        if (object.hasKey("themeFor")) {
            themeFor = object.getString("themeFor");
        }
        return new FallbackChunk.CssImportData(value, id, include, themeFor);
    }

    static void validateToolVersion(String tool, FrontendVersion toolVersion, FrontendVersion supported, FrontendVersion shouldWork) {
        if ("true".equalsIgnoreCase(System.getProperty(PARAM_IGNORE_VERSION_CHECKS))) {
            return;
        }
        if (FrontendUtils.isVersionAtLeast(toolVersion, supported)) {
            return;
        }
        if (FrontendUtils.isVersionAtLeast(toolVersion, shouldWork)) {
            FrontendUtils.getLogger().warn(FrontendUtils.buildShouldWorkString(tool, toolVersion.getFullVersion(), supported.getMajorVersion(), supported.getMinorVersion()));
            return;
        }
        throw new IllegalStateException(FrontendUtils.buildTooOldString(tool, toolVersion.getFullVersion(), supported.getMajorVersion(), supported.getMinorVersion()));
    }

    static boolean isVersionAtLeast(FrontendVersion toolVersion, FrontendVersion required) {
        int major = toolVersion.getMajorVersion();
        int minor = toolVersion.getMinorVersion();
        return major > required.getMajorVersion() || major == required.getMajorVersion() && minor >= required.getMinorVersion();
    }

    private static FrontendVersion getVersion(String tool, List<String> versionCommand) throws UnknownVersionException {
        try {
            Process process = FrontendUtils.createProcessBuilder(versionCommand).start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new UnknownVersionException(tool, "Using command " + String.join((CharSequence)" ", versionCommand));
            }
            String output = FrontendUtils.streamToString(process.getInputStream());
            return new FrontendVersion(FrontendUtils.parseVersionString(output));
        }
        catch (IOException | InterruptedException e) {
            throw new UnknownVersionException(tool, "Using command " + String.join((CharSequence)" ", versionCommand), e);
        }
    }

    static String parseVersionString(String output) throws IOException {
        Optional<String> lastOuput = Stream.of(output.split("\n")).filter(line -> !line.matches("^[ ]*$")).reduce((first, second) -> second);
        return lastOuput.map(line -> line.replaceFirst("^v", "")).orElseThrow(() -> new IOException("No output"));
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(FrontendUtils.class);
    }

    public static class UnknownVersionException
    extends Exception {
        public UnknownVersionException(String tool, String extraInfo) {
            super("Unable to detect version of " + tool + ". " + extraInfo);
        }

        public UnknownVersionException(String tool, String extraInfo, Exception cause) {
            super("Unable to detect version of " + tool + ". " + extraInfo, cause);
        }
    }
}

