/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.webcomponent.WebComponentConfiguration;
import com.vaadin.flow.internal.CustomElementNameValidator;
import com.vaadin.flow.server.InvalidCustomElementNameException;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.startup.ClassLoaderAwareServletContainerInitializer;
import com.vaadin.flow.server.webcomponent.WebComponentConfigurationRegistry;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;

@HandlesTypes(value={WebComponentExporter.class})
public class WebComponentConfigurationRegistryInitializer
implements ClassLoaderAwareServletContainerInitializer {
    @Override
    public void process(Set<Class<?>> set, ServletContext servletContext) throws ServletException {
        WebComponentConfigurationRegistry instance = WebComponentConfigurationRegistry.getInstance(new VaadinServletContext(servletContext));
        if (set == null || set.isEmpty()) {
            instance.setConfigurations(Collections.emptySet());
            return;
        }
        try {
            Set<Class<? extends WebComponentExporter<? extends Component>>> exporterClasses = set.stream().filter(WebComponentExporter.class::isAssignableFrom).filter(clazz -> !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())).map(aClass -> aClass).collect(Collectors.toSet());
            Set<WebComponentConfiguration<? extends Component>> configurations = WebComponentConfigurationRegistryInitializer.constructConfigurations(exporterClasses);
            WebComponentConfigurationRegistryInitializer.validateTagNames(configurations);
            WebComponentConfigurationRegistryInitializer.validateDistinctTagNames(configurations);
            instance.setConfigurations(configurations);
        }
        catch (Exception e) {
            throw new ServletException(String.format("%s failed to collect %s implementations!", WebComponentConfigurationRegistryInitializer.class.getSimpleName(), WebComponentExporter.class.getSimpleName()), (Throwable)e);
        }
    }

    private static Set<WebComponentConfiguration<? extends Component>> constructConfigurations(Set<Class<? extends WebComponentExporter<? extends Component>>> exporterClasses) {
        Objects.requireNonNull(exporterClasses, "Parameter 'exporterClasses' cannot be null!");
        WebComponentExporter.WebComponentConfigurationFactory factory = new WebComponentExporter.WebComponentConfigurationFactory();
        return exporterClasses.stream().map(factory::create).collect(Collectors.toSet());
    }

    private static void validateTagNames(Set<WebComponentConfiguration<? extends Component>> configurationSet) {
        for (WebComponentConfiguration<? extends Component> configuration : configurationSet) {
            if (CustomElementNameValidator.isCustomElementName(configuration.getTag())) continue;
            throw new InvalidCustomElementNameException(String.format("Tag name '%s' given by '%s' is not a valid custom element name.", configuration.getTag(), configuration.getExporterClass().getCanonicalName()));
        }
    }

    private static void validateDistinctTagNames(Set<WebComponentConfiguration<? extends Component>> configurationSet) {
        long count = configurationSet.stream().map(WebComponentConfiguration::getTag).distinct().count();
        if ((long)configurationSet.size() != count) {
            HashMap<String, WebComponentConfiguration<? extends Component>> items = new HashMap<String, WebComponentConfiguration<? extends Component>>();
            for (WebComponentConfiguration<? extends Component> configuration : configurationSet) {
                String tag = configuration.getTag();
                if (items.containsKey(tag)) {
                    String message = String.format("Found two %s classes '%s' and '%s' for the tag name '%s'. Tag must be unique.", WebComponentExporter.class.getSimpleName(), ((WebComponentConfiguration)items.get(tag)).getExporterClass().getCanonicalName(), configuration.getExporterClass().getCanonicalName(), tag);
                    throw new IllegalArgumentException(message);
                }
                items.put(tag, configuration);
            }
        }
    }
}

