/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MessageDigestUtil {
    private MessageDigestUtil() {
    }

    public static byte[] sha256(String string) {
        return MessageDigestUtil.getSha256().digest(string.getBytes(StandardCharsets.UTF_16));
    }

    private static MessageDigest getSha256() {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            assert (digest.getDigestLength() == 32);
            return digest;
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException("Your Java implementation does not support SHA-256, even though it is required by the Java specification. Change to an implementation which follows the specification.", e);
        }
    }
}

