/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.BootstrapHandler;
import com.vaadin.flow.server.DeploymentConfigurationFactory;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.PwaRegistry;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.ServiceContextUriResolver;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.WebBrowser;
import com.vaadin.flow.server.communication.FaviconHandler;
import com.vaadin.flow.server.communication.PushRequestHandler;
import com.vaadin.flow.server.frontend.FallbackChunk;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import com.vaadin.flow.theme.AbstractTheme;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.servlet.GenericServlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaadinServletService
extends VaadinService {
    private final VaadinServlet servlet;
    private final ServiceContextUriResolver contextResolver = new ServiceContextUriResolver();

    public VaadinServletService(VaadinServlet servlet, DeploymentConfiguration deploymentConfiguration) {
        super(deploymentConfiguration);
        this.servlet = servlet;
    }

    protected VaadinServletService() {
        this.servlet = null;
    }

    @Override
    protected List<RequestHandler> createRequestHandlers() throws ServiceException {
        List<RequestHandler> handlers = super.createRequestHandlers();
        handlers.add(0, new FaviconHandler());
        handlers.add(0, new BootstrapHandler());
        if (this.isAtmosphereAvailable()) {
            try {
                handlers.add(new PushRequestHandler(this));
            }
            catch (ServiceException e) {
                VaadinServletService.getLogger().warn("Error initializing Atmosphere. Push will not work.", (Throwable)e);
            }
        }
        return handlers;
    }

    public VaadinServlet getServlet() {
        return this.servlet;
    }

    @Override
    public String getMimeType(String resourceName) {
        return this.getServlet().getServletContext().getMimeType(resourceName);
    }

    @Override
    protected boolean requestCanCreateSession(VaadinRequest request) {
        return this.isOtherRequest(request);
    }

    @Override
    public void init() throws ServiceException {
        DeploymentConfiguration deploymentConfiguration = this.getDeploymentConfiguration();
        Properties initParameters = deploymentConfiguration.getInitParameters();
        Object object = initParameters.get(DeploymentConfigurationFactory.FALLBACK_CHUNK);
        if (object instanceof FallbackChunk) {
            VaadinContext context = this.getContext();
            context.setAttribute(object);
        }
        super.init();
    }

    private boolean isOtherRequest(VaadinRequest request) {
        return request.getParameter("v-r") == null;
    }

    public static HttpServletRequest getCurrentServletRequest() {
        return VaadinServletRequest.getCurrent();
    }

    public static VaadinServletResponse getCurrentResponse() {
        return VaadinServletResponse.getCurrent();
    }

    @Override
    public String getServiceName() {
        return this.getServlet().getServletName();
    }

    @Override
    public String getMainDivId(VaadinSession session, VaadinRequest request) {
        int hashCode;
        String appId = null;
        try {
            URL appUrl = this.getServlet().getApplicationUrl((HttpServletRequest)((VaadinServletRequest)request));
            appId = appUrl.getPath();
        }
        catch (MalformedURLException appUrl) {
            // empty catch block
        }
        if (appId == null || "".equals(appId) || "/".equals(appId)) {
            appId = "ROOT";
        }
        if ((hashCode = (appId = appId.replaceAll("[^a-zA-Z0-9]", "")).hashCode()) < 0) {
            hashCode = -hashCode;
        }
        appId = appId + "-" + hashCode;
        return appId;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)VaadinServletService.class.getName());
    }

    @Override
    protected RouteRegistry getRouteRegistry() {
        return ApplicationRouteRegistry.getInstance(this.getContext());
    }

    @Override
    protected PwaRegistry getPwaRegistry() {
        return Optional.ofNullable(this.getServlet()).map(GenericServlet::getServletContext).map(PwaRegistry::getInstance).orElse(null);
    }

    @Override
    public String resolveResource(String url, WebBrowser browser) {
        Objects.requireNonNull(url, "Url cannot be null");
        Objects.requireNonNull(browser, "Browser cannot be null");
        DeploymentConfiguration config = this.getDeploymentConfiguration();
        String frontendRootUrl = config.isCompatibilityMode() ? (browser.isEs6Supported() ? config.getEs6FrontendPrefix() : config.getEs5FrontendPrefix()) : config.getNpmFrontendPrefix();
        return this.contextResolver.resolveVaadinUri(url, frontendRootUrl);
    }

    @Override
    public URL getStaticResource(String path) {
        try {
            return this.getServlet().getServletContext().getResource(path);
        }
        catch (MalformedURLException e) {
            VaadinServletService.getLogger().warn("Error finding resource for '{}'", (Object)path, (Object)e);
            return null;
        }
    }

    @Override
    public URL getResource(String path, WebBrowser browser, AbstractTheme theme) {
        return this.getResourceInServletContextOrWebJar(this.getThemedOrRawPath(path, browser, theme));
    }

    @Override
    public InputStream getResourceAsStream(String path, WebBrowser browser, AbstractTheme theme) {
        return this.getResourceInServletContextOrWebJarAsStream(this.getThemedOrRawPath(path, browser, theme));
    }

    @Override
    public Optional<String> getThemedUrl(String url, WebBrowser browser, AbstractTheme theme) {
        if (theme != null && !this.resolveResource(url, browser).equals(this.getThemedOrRawPath(url, browser, theme))) {
            return Optional.of(theme.translateUrl(url));
        }
        return Optional.empty();
    }

    private String getThemedOrRawPath(String url, WebBrowser browser, AbstractTheme theme) {
        URL themeResource;
        String resourcePath = this.resolveResource(url, browser);
        Optional<String> themeResourcePath = this.getThemeResourcePath(resourcePath, theme);
        if (themeResourcePath.isPresent() && (themeResource = this.getResourceInServletContextOrWebJar(themeResourcePath.get())) != null) {
            return themeResourcePath.get();
        }
        return resourcePath;
    }

    private Optional<String> getThemeResourcePath(String path, AbstractTheme theme) {
        if (theme == null) {
            return Optional.empty();
        }
        String themeUrl = theme.translateUrl(path);
        if (path.equals(themeUrl)) {
            return Optional.empty();
        }
        return Optional.of(themeUrl);
    }

    public URL getResourceInServletContextOrWebJar(String path) {
        ServletContext servletContext = this.getServlet().getServletContext();
        try {
            URL url = servletContext.getResource(path);
            if (url != null) {
                return url;
            }
            Optional<String> webJarPath = this.getWebJarPath(path);
            if (webJarPath.isPresent()) {
                return servletContext.getResource(webJarPath.get());
            }
        }
        catch (MalformedURLException e) {
            VaadinServletService.getLogger().warn("Error finding resource for '{}'", (Object)path, (Object)e);
        }
        return null;
    }

    private InputStream getResourceInServletContextOrWebJarAsStream(String path) {
        ServletContext servletContext = this.getServlet().getServletContext();
        InputStream stream = servletContext.getResourceAsStream(path);
        if (stream != null) {
            return stream;
        }
        Optional<String> webJarPath = this.getWebJarPath(path);
        if (webJarPath.isPresent()) {
            return servletContext.getResourceAsStream(webJarPath.get());
        }
        return null;
    }

    private Optional<String> getWebJarPath(String path) {
        return this.getServlet().getWebJarServer().flatMap(server -> server.getWebJarResourcePath(path));
    }

    @Override
    public String getContextRootRelativePath(VaadinRequest request) {
        assert (request instanceof VaadinServletRequest);
        String servletPath = ((VaadinServletRequest)request).getServletPath();
        assert (servletPath != null);
        if (!servletPath.endsWith("/")) {
            servletPath = servletPath + "/";
        }
        return HandlerHelper.getCancelingRelativePath(servletPath) + "/";
    }

    @Override
    protected VaadinContext constructVaadinContext() {
        return new VaadinServletContext(this.getServlet().getServletContext());
    }
}

