/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.polymertemplate;

import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.polymertemplate.BundleParser;
import com.vaadin.flow.component.polymertemplate.JsoupUtils;
import com.vaadin.flow.component.polymertemplate.PolymerTemplate;
import com.vaadin.flow.component.polymertemplate.TemplateParser;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.internal.Pair;
import com.vaadin.flow.server.DependencyFilter;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.startup.FakeBrowser;
import com.vaadin.flow.shared.ui.Dependency;
import elemental.json.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.jsoup.UncheckedIOException;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NpmTemplateParser
implements TemplateParser {
    private static final TemplateParser INSTANCE = new NpmTemplateParser();
    private final HashMap<String, String> cache = new HashMap();
    private final ReentrantLock lock = new ReentrantLock();
    private JsonObject jsonStats;

    protected NpmTemplateParser() {
    }

    public static TemplateParser getInstance() {
        return INSTANCE;
    }

    @Override
    public TemplateParser.TemplateData getTemplateContent(Class<? extends PolymerTemplate<?>> clazz, String tag, VaadinService service) {
        FakeBrowser browser = FakeBrowser.getEs6();
        List<Object> dependencies = AnnotationReader.getAnnotationsFor(clazz, JsModule.class).stream().map(htmlImport -> new Dependency(Dependency.Type.JS_MODULE, htmlImport.value(), htmlImport.loadMode())).collect(Collectors.toList());
        DependencyFilter.FilterContext filterContext = new DependencyFilter.FilterContext(service, browser);
        for (DependencyFilter dependencyFilter : service.getDependencyFilters()) {
            dependencies = dependencyFilter.filter(new ArrayList<Dependency>(dependencies), filterContext);
        }
        Pair<Dependency, String> chosenDep = null;
        for (Dependency dependency : dependencies) {
            if (dependency.getType() != Dependency.Type.JS_MODULE) continue;
            String url = dependency.getUrl();
            String source = this.getSourcesFromTemplate(tag, url);
            if (source == null) {
                try {
                    source = this.getSourcesFromStats(service, url);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            if (source == null) continue;
            if (chosenDep == null) {
                chosenDep = new Pair<Dependency, String>(dependency, source);
            }
            if (!this.dependencyHasTagName(dependency, tag)) continue;
            chosenDep = new Pair<Dependency, String>(dependency, source);
            break;
        }
        if (chosenDep != null) {
            Element element = BundleParser.parseTemplateElement(((Dependency)chosenDep.getFirst()).getUrl(), (String)chosenDep.getSecond());
            if (!JsoupUtils.getDomModule(element, null).isPresent()) {
                Element parent = new Element(tag);
                parent.attr("id", tag);
                element.appendTo(parent);
            }
            return new TemplateParser.TemplateData(((Dependency)chosenDep.getFirst()).getUrl(), element);
        }
        throw new IllegalStateException(String.format("Couldn't find the definition of the element with tag '%s' in any template file declared using '@%s' annotations. Check the availability of the template files in your WAR file or provide alternative implementation of the method getTemplateContent() which should return an element representing the content of the template file", tag, JsModule.class.getSimpleName()));
    }

    private boolean dependencyHasTagName(Dependency dependency, String tag) {
        String url = dependency.getUrl();
        if (url.equalsIgnoreCase(tag + ".js")) {
            return true;
        }
        url = url.toLowerCase(Locale.ENGLISH);
        return url.endsWith("/" + tag + ".js");
    }

    protected String getSourcesFromTemplate(String tag, String url) {
        InputStream content = this.getClass().getClassLoader().getResourceAsStream(url);
        if (content != null) {
            this.getLogger().debug("Found sources from the tag '{}' in the template '{}'", (Object)tag, (Object)url);
            return FrontendUtils.streamToString(content);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSourcesFromStats(VaadinService service, String url) throws IOException {
        try {
            String content;
            this.lock.lock();
            if (this.isStatsFileReadNeeded(service) && (content = FrontendUtils.getStatsContent(service)) != null) {
                this.resetCache(content);
            }
        }
        finally {
            this.lock.unlock();
        }
        if (!this.cache.containsKey(url) && this.jsonStats != null) {
            this.cache.put(url, BundleParser.getSourceFromStatistics(url, this.jsonStats));
        }
        return this.cache.get(url);
    }

    protected boolean isStatsFileReadNeeded(VaadinService service) throws IOException {
        DeploymentConfiguration config = service.getDeploymentConfiguration();
        if (this.jsonStats == null) {
            return true;
        }
        if (this.usesBundleFile(config)) {
            return false;
        }
        return !this.jsonStats.get("hash").asString().equals(FrontendUtils.getStatsHash(service));
    }

    private boolean usesBundleFile(DeploymentConfiguration config) {
        return config.isProductionMode() && !config.enableDevServer();
    }

    private void resetCache(String fileContents) {
        this.cache.clear();
        this.jsonStats = BundleParser.parseJsonStatistics(fileContents);
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger((String)NpmTemplateParser.class.getName());
    }
}

