/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.ErrorNavigationEvent;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.LocationChangeEvent;
import com.vaadin.flow.router.NavigationEvent;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.AbstractNavigationStateRenderer;
import com.vaadin.flow.router.internal.RouteUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

public class ErrorStateRenderer
extends AbstractNavigationStateRenderer {
    public ErrorStateRenderer(NavigationState navigationState) {
        super(navigationState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int handle(NavigationEvent event) {
        assert (event instanceof ErrorNavigationEvent) : "Error handling needs ErrorNavigationEvent";
        ExceptionsTrace trace = ComponentUtil.getData((Component)event.getUI(), ExceptionsTrace.class);
        boolean isFirstCall = trace == null;
        Exception exception = ((ErrorNavigationEvent)event).getErrorParameter().getCaughtException();
        if (isFirstCall) {
            trace = new ExceptionsTrace(exception);
            ComponentUtil.setData((Component)event.getUI(), ExceptionsTrace.class, trace);
        } else if (trace.hasException(exception)) {
            LoggerFactory.getLogger(ErrorStateRenderer.class).error("The same exception {} has been thrown several times during navigation. Can't use any {} view for this error.", new Object[]{exception.getClass().getName(), HasErrorParameter.class.getSimpleName(), trace});
            throw trace;
        }
        trace.addException(exception);
        try {
            int n = super.handle(event);
            return n;
        }
        finally {
            if (isFirstCall) {
                ComponentUtil.setData((Component)event.getUI(), ExceptionsTrace.class, null);
            }
        }
    }

    @Override
    protected void notifyNavigationTarget(Component componentInstance, NavigationEvent navigationEvent, BeforeEnterEvent beforeEnterEvent, LocationChangeEvent locationChangeEvent) {
        int statusCode = ((HasErrorParameter)((Object)componentInstance)).setErrorParameter(beforeEnterEvent, ((ErrorNavigationEvent)navigationEvent).getErrorParameter());
        locationChangeEvent.setStatusCode(statusCode);
    }

    @Override
    public List<Class<? extends RouterLayout>> getRouterLayoutTypes(Class<? extends Component> targetType, Router router) {
        assert (targetType == this.getNavigationState().getNavigationTarget());
        return RouteUtil.getParentLayoutsForNonRouteTarget(targetType);
    }

    @Override
    protected boolean eventActionsSupported() {
        return true;
    }

    static class ExceptionsTrace
    extends RuntimeException {
        private final Set<Class<? extends Exception>> trace = new HashSet<Class<? extends Exception>>();

        private ExceptionsTrace(Exception cause) {
            super(cause);
        }

        void addException(Exception exception) {
            this.trace.add(exception.getClass());
        }

        boolean hasException(Exception exception) {
            return this.trace.contains(exception.getClass());
        }

        @Override
        public String getMessage() {
            return "Exceptions handled by " + HasErrorParameter.class.getSimpleName() + " views are :" + this.trace.stream().filter(clazz -> !clazz.equals(ExceptionsTrace.class)).map(Class::getName).collect(Collectors.joining(", "));
        }
    }
}

