/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.webcomponent;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.webcomponent.EventOptions;
import com.vaadin.flow.component.webcomponent.PropertyConfiguration;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.webcomponent.PropertyConfigurationImpl;
import com.vaadin.flow.server.webcomponent.WebComponentBinding;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.Objects;

public final class WebComponent<C extends Component>
implements Serializable {
    private static final String UPDATE_PROPERTY = "this._updatePropertyFromServer($0, $1);";
    private static final String UPDATE_PROPERTY_NULL = "this._updatePropertyFromServer($0, null);";
    private static final String UPDATE_PROPERTY_FORMAT = "this._updatePropertyFromServer($0, %s);";
    private static final String CUSTOM_EVENT = "this.dispatchEvent(new CustomEvent($0, %s));";
    private static final EventOptions BASIC_OPTIONS = new EventOptions();
    private Element componentHost;
    private WebComponentBinding binding;

    private WebComponent() {
    }

    public WebComponent(WebComponentBinding binding, Element componentHost) {
        Objects.requireNonNull(binding, "Parameter 'binding' must not be null!");
        Objects.requireNonNull(componentHost, "Parameter 'webComponentWrapper' must not be null!");
        this.binding = binding;
        this.componentHost = componentHost;
    }

    public void fireEvent(String eventName) {
        this.fireEvent(eventName, (JsonValue)Json.createNull(), BASIC_OPTIONS);
    }

    public void fireEvent(String eventName, JsonValue objectData) {
        this.fireEvent(eventName, objectData, BASIC_OPTIONS);
    }

    public void fireEvent(String eventName, JsonValue objectData, EventOptions options) {
        Objects.requireNonNull(eventName, "Parameter 'eventName' must not be null!");
        Objects.requireNonNull(options, "Parameter 'options' must not be null");
        JsonObject object = Json.createObject();
        object.put("bubbles", options.isBubbles());
        object.put("cancelable", options.isCancelable());
        object.put("composed", options.isComposed());
        object.put("detail", (JsonValue)(objectData == null ? Json.createNull() : objectData));
        this.componentHost.executeJs(String.format(CUSTOM_EVENT, object.toJson()), new Serializable[]{eventName});
    }

    public <P extends Serializable> void setProperty(PropertyConfiguration<C, P> propertyConfiguration, P value) {
        Objects.requireNonNull(propertyConfiguration, "Parameter 'propertyConfiguration' must not be null!");
        if (!(propertyConfiguration instanceof PropertyConfigurationImpl)) {
            throw new IllegalArgumentException(String.format("Parameter 'propertyConfiguration' is not an implementation of %s", PropertyConfigurationImpl.class));
        }
        PropertyConfigurationImpl propertyConfigurationImpl = (PropertyConfigurationImpl)propertyConfiguration;
        String propertyName = propertyConfigurationImpl.getPropertyData().getName();
        if (!this.binding.hasProperty(propertyName)) {
            throw new IllegalArgumentException(String.format("%s does not have a property identified by '%s'!", WebComponent.class.getSimpleName(), propertyName));
        }
        if (value != null && !this.binding.getPropertyType(propertyName).isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException(String.format("Property '%s' of type '%s' cannot be assigned value of type '%s'!", propertyName, this.binding.getPropertyType(propertyName).getName(), value.getClass().getCanonicalName()));
        }
        this.setProperty(propertyName, value);
    }

    private void setProperty(String propertyName, Object value) {
        if (value == null) {
            this.componentHost.executeJs(UPDATE_PROPERTY_NULL, new Serializable[]{propertyName});
        }
        if (value instanceof Integer) {
            this.componentHost.executeJs(UPDATE_PROPERTY, new Serializable[]{propertyName, (Integer)value});
        } else if (value instanceof Double) {
            this.componentHost.executeJs(UPDATE_PROPERTY, new Serializable[]{propertyName, (Double)value});
        } else if (value instanceof String) {
            this.componentHost.executeJs(UPDATE_PROPERTY, new Serializable[]{propertyName, (String)value});
        } else if (value instanceof Boolean) {
            this.componentHost.executeJs(UPDATE_PROPERTY, new Serializable[]{propertyName, (Boolean)value});
        } else if (value instanceof JsonValue) {
            this.componentHost.executeJs(String.format(UPDATE_PROPERTY_FORMAT, ((JsonValue)value).toJson()), new Serializable[]{propertyName});
        }
    }
}

