/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.Pair;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Stack;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseWriter
implements Serializable {
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private static final Pattern RANGE_HEADER_PATTERN = Pattern.compile("^bytes=((\\d*-\\d*\\s*,\\s*)*\\d*-\\d*\\s*)$");
    private static final Pattern BYTE_RANGE_PATTERN = Pattern.compile("(\\d*)-(\\d*)");
    private static final int MAX_RANGE_COUNT = 16;
    private static final int MAX_OVERLAPPING_RANGE_COUNT = 2;
    private final int bufferSize;
    private final boolean brotliEnabled;
    private final boolean compatibilityMode;

    @Deprecated
    public ResponseWriter() {
        this(32768);
    }

    @Deprecated
    public ResponseWriter(int bufferSize) {
        this(bufferSize, false, true);
    }

    public ResponseWriter(DeploymentConfiguration deploymentConfiguration) {
        this(32768, deploymentConfiguration.isBrotli(), deploymentConfiguration.isCompatibilityMode());
    }

    private ResponseWriter(int bufferSize, boolean brotliEnabled, boolean compatibilityMode) {
        this.brotliEnabled = brotliEnabled;
        this.bufferSize = bufferSize;
        this.compatibilityMode = compatibilityMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeResponseContents(String filenameWithPath, URL resourceUrl, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.writeContentType(filenameWithPath, (ServletRequest)request, (ServletResponse)response);
        URL url = null;
        URLConnection connection = null;
        InputStream dataStream = null;
        if (this.brotliEnabled && this.acceptsBrotliResource(request)) {
            String brotliFilenameWithPath = filenameWithPath + ".br";
            try {
                url = this.getResource(request, brotliFilenameWithPath);
                if (url != null) {
                    connection = url.openConnection();
                    dataStream = connection.getInputStream();
                    response.setHeader("Content-Encoding", "br");
                }
            }
            catch (Exception e) {
                this.getLogger().debug("Unexpected exception looking for Brotli resource {}", (Object)brotliFilenameWithPath, (Object)e);
            }
        }
        if (dataStream == null && this.acceptsGzippedResource(request)) {
            String gzippedFilenameWithPath = filenameWithPath + ".gz";
            try {
                url = this.getResource(request, gzippedFilenameWithPath);
                if (url != null) {
                    connection = url.openConnection();
                    dataStream = connection.getInputStream();
                    response.setHeader("Content-Encoding", "gzip");
                }
            }
            catch (Exception e) {
                this.getLogger().debug("Unexpected exception looking for gzipped resource {}", (Object)gzippedFilenameWithPath, (Object)e);
            }
        }
        if (dataStream == null) {
            url = resourceUrl;
            connection = resourceUrl.openConnection();
            dataStream = connection.getInputStream();
        } else {
            response.setHeader("Vary", "Accept-Encoding");
        }
        try {
            String range = request.getHeader("Range");
            if (range != null) {
                this.closeStream(dataStream);
                dataStream = null;
                this.writeRangeContents(range, response, url);
            } else {
                long contentLength = connection.getContentLengthLong();
                if (0L <= contentLength) {
                    this.setContentLength(response, contentLength);
                }
                this.writeStream(response.getOutputStream(), dataStream, Long.MAX_VALUE);
            }
        }
        catch (IOException e) {
            this.getLogger().debug("Error writing static file to user", (Throwable)e);
        }
        finally {
            if (dataStream != null) {
                this.closeStream(dataStream);
            }
        }
    }

    private void closeStream(Closeable stream) {
        try {
            stream.close();
        }
        catch (IOException e) {
            this.getLogger().debug("Error closing input stream for resource", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRangeContents(String range, HttpServletResponse response, URL resourceURL) throws IOException {
        response.setHeader("Accept-Ranges", "bytes");
        URLConnection connection = resourceURL.openConnection();
        Matcher headerMatcher = RANGE_HEADER_PATTERN.matcher(range);
        if (!headerMatcher.matches()) {
            response.setContentLengthLong(0L);
            response.setStatus(416);
            return;
        }
        String byteRanges = headerMatcher.group(1);
        long resourceLength = connection.getContentLengthLong();
        Matcher rangeMatcher = BYTE_RANGE_PATTERN.matcher(byteRanges);
        Stack<Pair<Long, Long>> ranges = new Stack<Pair<Long, Long>>();
        while (rangeMatcher.find() && ranges.size() < 16) {
            long end;
            String startGroup = rangeMatcher.group(1);
            String endGroup = rangeMatcher.group(2);
            if (startGroup.isEmpty() && endGroup.isEmpty()) {
                response.setContentLengthLong(0L);
                response.setStatus(416);
                this.getLogger().info("received a malformed range: '{}'", (Object)rangeMatcher.group());
                return;
            }
            long start = startGroup.isEmpty() ? 0L : Long.parseLong(startGroup);
            long l = end = endGroup.isEmpty() ? Long.MAX_VALUE : Long.parseLong(endGroup);
            if (end < start || resourceLength >= 0L && start >= resourceLength) {
                this.getLogger().info("received an illegal range '{}' for resource '{}'", (Object)rangeMatcher.group(), (Object)resourceURL);
                response.setContentLengthLong(0L);
                response.setStatus(416);
                return;
            }
            ranges.push(new Pair<Long, Long>(start, end));
            if (this.verifyRangeLimits(ranges)) continue;
            ranges.pop();
            this.getLogger().info("serving only {} ranges for resource '{}' even though more were requested", (Object)ranges.size(), (Object)resourceURL);
            break;
        }
        response.setStatus(206);
        if (ranges.size() == 1) {
            ServletOutputStream outputStream = response.getOutputStream();
            long start = (Long)((Pair)ranges.get(0)).getFirst();
            long end = (Long)((Pair)ranges.get(0)).getSecond();
            if (resourceLength >= 0L) {
                end = Math.min(end, resourceLength - 1L);
            }
            this.setContentLength(response, end - start + 1L);
            response.setHeader("Content-Range", this.createContentRangeHeader(start, end, resourceLength));
            InputStream dataStream = connection.getInputStream();
            try {
                long skipped = dataStream.skip(start);
                assert (skipped == start);
                this.writeStream(outputStream, dataStream, end - start + 1L);
            }
            finally {
                this.closeStream(dataStream);
            }
        } else {
            this.writeMultipartRangeContents(ranges, connection, response, resourceURL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMultipartRangeContents(List<Pair<Long, Long>> ranges, URLConnection connection, HttpServletResponse response, URL resourceURL) throws IOException {
        String partBoundary = UUID.randomUUID().toString();
        response.setContentType(String.format("multipart/byteranges; boundary=%s", partBoundary));
        response.setHeader("Transfer-Encoding", "chunked");
        long position = 0L;
        String mimeType = response.getContentType();
        InputStream dataStream = connection.getInputStream();
        ServletOutputStream outputStream = response.getOutputStream();
        try {
            for (Pair<Long, Long> rangePair : ranges) {
                outputStream.write(String.format("\r\n--%s\r\n", partBoundary).getBytes());
                long start = rangePair.getFirst();
                long end = rangePair.getSecond();
                if (mimeType != null) {
                    outputStream.write(String.format("Content-Type: %s\r\n", mimeType).getBytes());
                }
                outputStream.write(String.format("Content-Range: %s\r\n\r\n", this.createContentRangeHeader(start, end, connection.getContentLengthLong())).getBytes());
                if (position > start) {
                    this.closeStream(connection.getInputStream());
                    connection = resourceURL.openConnection();
                    dataStream = connection.getInputStream();
                    position = 0L;
                }
                long skipped = dataStream.skip(start - position);
                assert (skipped == start - position);
                this.writeStream(outputStream, dataStream, end - start + 1L);
                position = end + 1L;
            }
        }
        finally {
            this.closeStream(dataStream);
        }
        outputStream.write(String.format("\r\n--%s", partBoundary).getBytes());
    }

    private String createContentRangeHeader(long start, long end, long size) {
        String lengthString = size >= 0L ? Long.toString(size) : "*";
        return String.format("bytes %d-%d/%s", start, end, lengthString);
    }

    private void setContentLength(HttpServletResponse response, long contentLength) {
        try {
            response.setContentLengthLong(contentLength);
        }
        catch (Exception e) {
            this.getLogger().debug("Error setting the content length", (Throwable)e);
        }
    }

    private boolean verifyRangeLimits(List<Pair<Long, Long>> ranges) {
        if (ranges.size() > 16) {
            this.getLogger().info("more than {} ranges requested", (Object)16);
            return false;
        }
        int count = 0;
        for (int i = 0; i < ranges.size(); ++i) {
            for (int j = i + 1; j < ranges.size(); ++j) {
                if (ranges.get(i).getFirst() > ranges.get(j).getSecond() || ranges.get(j).getFirst() > ranges.get(i).getSecond()) continue;
                ++count;
            }
        }
        if (count > 2) {
            this.getLogger().info("more than {} overlapping ranges requested", (Object)2);
            return false;
        }
        return true;
    }

    private URL getResource(HttpServletRequest request, String resource) throws MalformedURLException {
        URL url = request.getServletContext().getResource(resource);
        if (url != null) {
            return url;
        }
        if (resource.startsWith("/VAADIN/build/") && this.isAllowedVAADINBuildUrl(resource)) {
            url = request.getServletContext().getClassLoader().getResource("META-INF" + resource);
        }
        return url;
    }

    private boolean isAllowedVAADINBuildUrl(String filenameWithPath) {
        if (this.compatibilityMode) {
            this.getLogger().trace("Serving from the classpath in legacy mode is not accepted. Letting request for '{}' go to servlet context.", (Object)filenameWithPath);
            return false;
        }
        if (!filenameWithPath.startsWith("/VAADIN/build/") || filenameWithPath.contains("/../")) {
            this.getLogger().info("Blocked attempt to access file: {}", (Object)filenameWithPath);
            return false;
        }
        return true;
    }

    private void writeStream(ServletOutputStream outputStream, InputStream dataStream, long count) throws IOException {
        int bytes;
        byte[] buffer = new byte[this.bufferSize];
        for (long bytesTotal = 0L; bytesTotal < count && (bytes = dataStream.read(buffer, 0, (int)Long.min(this.bufferSize, count - bytesTotal))) >= 0; bytesTotal += (long)bytes) {
            outputStream.write(buffer, 0, bytes);
        }
    }

    protected boolean acceptsGzippedResource(HttpServletRequest request) {
        return ResponseWriter.acceptsEncoding(request, "gzip");
    }

    protected boolean acceptsBrotliResource(HttpServletRequest request) {
        return ResponseWriter.acceptsEncoding(request, "br");
    }

    private static boolean acceptsEncoding(HttpServletRequest request, String encodingName) {
        String accept = request.getHeader("Accept-Encoding");
        if (accept == null) {
            return false;
        }
        if ((accept = accept.replace(" ", "")).contains(encodingName)) {
            return !ResponseWriter.isQualityValueZero(accept, encodingName);
        }
        return accept.contains("*") && !ResponseWriter.isQualityValueZero(accept, "*");
    }

    void writeContentType(String filenameWithPath, ServletRequest request, ServletResponse response) {
        String mimetype = request.getServletContext().getMimeType(filenameWithPath);
        if (mimetype != null) {
            response.setContentType(mimetype);
        }
    }

    private static boolean isQualityValueZero(String acceptEncoding, String encoding) {
        String qPrefix = encoding + ";q=";
        int qValueIndex = acceptEncoding.indexOf(qPrefix);
        if (qValueIndex == -1) {
            return false;
        }
        String qValue = acceptEncoding.substring(qValueIndex + qPrefix.length());
        int endOfQValue = qValue.indexOf(44);
        if (endOfQValue != -1) {
            qValue = qValue.substring(0, endOfQValue);
        }
        return Double.valueOf(0.0).equals(Double.valueOf(qValue));
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger((String)this.getClass().getName());
    }
}

