/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.shared.util.SharedUtil;

public class StyleUtil {
    private static String[] vendorPrefixes = new String[]{"webkit", "moz", "ms", "o"};

    private StyleUtil() {
    }

    public static String styleAttributeToProperty(String attributeStyle) {
        String propertyStyle = attributeStyle.startsWith("-") ? attributeStyle.substring(1) : attributeStyle;
        return SharedUtil.dashSeparatedToCamelCase(propertyStyle);
    }

    public static String stylePropertyToAttribute(String propertyStyle) {
        String attributeStyle = SharedUtil.camelCaseToDashSeparated(propertyStyle);
        int dashIndex = attributeStyle.indexOf("-");
        if (dashIndex != -1) {
            String possibleVendorPrefix = propertyStyle.substring(0, dashIndex);
            for (String vendorPrefix : vendorPrefixes) {
                if (!vendorPrefix.equals(possibleVendorPrefix)) continue;
                return "-" + attributeStyle;
            }
        }
        return attributeStyle;
    }
}

