/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.polymertemplate;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.polymertemplate.Id;
import com.vaadin.flow.internal.AnnotationReader;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Element;

public class IdCollector {
    private final Map<String, String> tagById = new HashMap<String, String>();
    private final Map<Field, String> idByField = new HashMap<Field, String>();
    private final Map<String, Map<String, String>> attributesById = new HashMap<String, Map<String, String>>();
    private Element templateRoot;
    private Class<?> templateClass;
    private String templateFile;

    public IdCollector(Class<?> templateClass, String templateFile, Element templateRoot) {
        this.templateClass = templateClass;
        this.templateFile = templateFile;
        this.templateRoot = templateRoot;
    }

    public void collectInjectedIds(Set<String> notInjectableElementIds) {
        this.collectInjectedIds(this.templateClass, notInjectableElementIds);
    }

    private void collectInjectedIds(Class<?> cls, Set<String> notInjectableElementIds) {
        if (!Component.class.equals(cls.getSuperclass())) {
            this.collectInjectedIds(cls.getSuperclass(), notInjectableElementIds);
        }
        Stream.of(cls.getDeclaredFields()).filter(field -> !field.isSynthetic()).forEach(field -> this.collectedInjectedId((Field)field, notInjectableElementIds));
    }

    private void collectedInjectedId(Field field, Set<String> notInjectableElementIds) {
        String id = this.getId(field).orElse(null);
        if (id == null) {
            return;
        }
        boolean emptyValue = id.isEmpty();
        if (emptyValue) {
            id = field.getName();
        }
        if (notInjectableElementIds.contains(id)) {
            throw new IllegalStateException(String.format("Class '%s' contains field '%s' annotated with @Id%s. Corresponding element was found in a sub template, for which injection is not supported.", this.templateClass.getName(), field.getName(), emptyValue ? " without value (so the name of the field should match the id of an element in the template)" : "(\"" + id + "\")"));
        }
        if (!this.collectElementData(id, field)) {
            throw new IllegalStateException(String.format("There is no element with id='%s' in the template file '%s'. Cannot map it using @%s", id, this.templateFile, Id.class.getSimpleName()));
        }
    }

    private Optional<String> getId(Field field) {
        Optional<Id> polymerId = AnnotationReader.getAnnotationFor(field, Id.class);
        if (polymerId.isPresent()) {
            return polymerId.map(Id::value);
        }
        return AnnotationReader.getAnnotationFor(field, com.vaadin.flow.component.template.Id.class).map(com.vaadin.flow.component.template.Id::value);
    }

    private boolean collectElementData(String id, Field field) {
        this.idByField.put(field, id);
        if (this.templateRoot != null) {
            Optional<Element> element = Optional.ofNullable(this.templateRoot.getElementById(id));
            Optional<String> tagName = element.map(Element::tagName);
            if (element.isPresent()) {
                Element domElement = element.get();
                this.tagById.put(id, tagName.get());
                this.fetchAttributes(id, domElement.attributes());
                this.setText(id, domElement);
            }
            return element.isPresent();
        }
        return true;
    }

    public Map<Field, String> getIdByField() {
        return this.idByField;
    }

    public Map<String, String> getTagById() {
        return this.tagById;
    }

    public Map<String, Map<String, String>> getAttributes() {
        return Collections.unmodifiableMap(this.attributesById);
    }

    private void fetchAttributes(String id, Attributes attributes) {
        if (attributes.size() == 0) {
            return;
        }
        Map<String, String> data = this.getAttributeData(id);
        attributes.forEach(attr -> this.setAttributeData((Attribute)attr, data));
    }

    private void setAttributeData(Attribute attribute, Map<String, String> data) {
        if (this.isBooleanAttribute(attribute)) {
            data.put(attribute.getKey(), Boolean.TRUE.toString());
        } else {
            data.put(attribute.getKey(), attribute.getValue());
        }
    }

    private boolean isBooleanAttribute(Attribute attribute) {
        return attribute.getKey().equals(attribute.toString());
    }

    private Map<String, String> getAttributeData(String id) {
        return this.attributesById.computeIfAbsent(id, key -> new HashMap());
    }

    private void setText(String id, Element domElement) {
        if (domElement.children().isEmpty()) {
            this.getAttributeData(id).put("=text", domElement.ownText());
        }
    }
}

