/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.Pair;
import com.vaadin.flow.server.frontend.FrontendToolsLocator;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.FrontendVersion;
import com.vaadin.flow.server.frontend.installer.InstallationException;
import com.vaadin.flow.server.frontend.installer.NodeInstaller;
import com.vaadin.flow.server.frontend.installer.Platform;
import com.vaadin.flow.server.frontend.installer.ProxyConfig;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontendTools {
    public static final String DEFAULT_NODE_VERSION = "v14.21.3";
    public static final String DEFAULT_PNPM_VERSION = "5";
    public static final String INSTALL_NODE_LOCALLY = "%n  $ mvn com.github.eirslett:frontend-maven-plugin:1.10.0:install-node-and-npm -DnodeVersion=\"v14.21.3\" ";
    private static final String MSG_PREFIX = "%n%n======================================================================================================";
    private static final String MSG_SUFFIX = "%n======================================================================================================%n";
    private static final String NODE_NOT_FOUND = "%n%n======================================================================================================%nVaadin requires node.js & npm to be installed. Please install the latest LTS version of node.js (with npm) either by:%n  1) following the https://nodejs.org/en/download/ guide to install it globally. This is the recommended way.%n  2) running the following Maven plugin goal to install it in this project:%n  $ mvn com.github.eirslett:frontend-maven-plugin:1.10.0:install-node-and-npm -DnodeVersion=\"v14.21.3\" %n%nNote that in case you don't install it globally, you'll need to install it again for another Vaadin project.%nIn case you have just installed node.js globally, it was not discovered, so you need to restart your system to get the path variables updated.%n======================================================================================================%n";
    private static final String LOCAL_NODE_NOT_FOUND = "%n%n======================================================================================================%nVaadin requires node.js & npm to be installed. The %s directory already contains 'node' but it's either not a file or not a 'node' executable. Please check %s directory and clean up it: remove '%s'.%n then please run the app or maven goal again.%n======================================================================================================%n";
    private static final String BAD_VERSION = "%n%n======================================================================================================%nYour installed '%s' version (%s) is known to have problems.%nPlease update to a new one either:%n  - by following the https://nodejs.org/en/download/ guide to install it globally%s%n  - or by running the frontend-maven-plugin goal to install it in this project:%n  $ mvn com.github.eirslett:frontend-maven-plugin:1.10.0:install-node-and-npm -DnodeVersion=\"v14.21.3\" %n%nYou can disable the version check using -D%s=true%n======================================================================================================%n";
    private static final List<FrontendVersion> NPM_BLACKLISTED_VERSIONS = Arrays.asList(new FrontendVersion("6.11.0"), new FrontendVersion("6.11.1"), new FrontendVersion("6.11.2"));
    private static final FrontendVersion WHITESPACE_ACCEPTING_NPM_VERSION = new FrontendVersion(7, 0);
    private static final int SUPPORTED_NODE_MAJOR_VERSION = 10;
    private static final int SUPPORTED_NODE_MINOR_VERSION = 0;
    private static final int SUPPORTED_NPM_MAJOR_VERSION = 5;
    private static final int SUPPORTED_NPM_MINOR_VERSION = 6;
    private static final int SHOULD_WORK_NODE_MAJOR_VERSION = 8;
    private static final int SHOULD_WORK_NODE_MINOR_VERSION = 9;
    private static final int SHOULD_WORK_NPM_MAJOR_VERSION = 5;
    private static final int SHOULD_WORK_NPM_MINOR_VERSION = 5;
    private static final FrontendVersion SUPPORTED_NODE_VERSION = new FrontendVersion(10, 0);
    private static final FrontendVersion SHOULD_WORK_NODE_VERSION = new FrontendVersion(8, 9);
    private static final FrontendVersion SUPPORTED_NPM_VERSION = new FrontendVersion(5, 6);
    private static final FrontendVersion SHOULD_WORK_NPM_VERSION = new FrontendVersion(5, 5);
    static final String NPMRC_NOPROXY_PROPERTY_KEY = "noproxy";
    static final String NPMRC_HTTPS_PROXY_PROPERTY_KEY = "https-proxy";
    static final String NPMRC_PROXY_PROPERTY_KEY = "proxy";
    static final String SYSTEM_NOPROXY_PROPERTY_KEY = "NOPROXY";
    static final String SYSTEM_HTTPS_PROXY_PROPERTY_KEY = "HTTPS_PROXY";
    static final String SYSTEM_HTTP_PROXY_PROPERTY_KEY = "HTTP_PROXY";
    public static final int SUPPORTED_PNPM_MAJOR_VERSION = 5;
    public static final int SUPPORTED_PNPM_MINOR_VERSION = 0;
    private static final FrontendVersion SUPPORTED_PNPM_VERSION = new FrontendVersion(5, 0);
    private static final String HIGHEST_FUNCTIONAL_NPM = "latest";
    private final String baseDir;
    private final Supplier<String> alternativeDirGetter;
    private final FrontendToolsLocator frontendToolsLocator = new FrontendToolsLocator();
    private final String nodeVersion;
    private final URI nodeDownloadRoot;
    private final boolean ignoreVersionChecks;
    private final boolean forceAlternativeNode;

    public FrontendTools(String baseDir, Supplier<String> alternativeDirGetter, boolean forceAlternativeNode) {
        this(baseDir, alternativeDirGetter, DEFAULT_NODE_VERSION, URI.create(Platform.guess().getNodeDownloadRoot()), forceAlternativeNode);
    }

    public FrontendTools(String baseDir, Supplier<String> alternativeDirGetter) {
        this(baseDir, alternativeDirGetter, DEFAULT_NODE_VERSION, URI.create("https://nodejs.org/dist/"), false);
    }

    public FrontendTools(String baseDir, Supplier<String> alternativeDirGetter, String nodeVersion, URI nodeDownloadRoot, boolean forceAlternativeNode) {
        this(baseDir, alternativeDirGetter, nodeVersion, nodeDownloadRoot, "true".equalsIgnoreCase(System.getProperty("vaadin.ignoreVersionChecks")), forceAlternativeNode);
    }

    public FrontendTools(String baseDir, Supplier<String> alternativeDirGetter, String nodeVersion, URI nodeDownloadRoot) {
        this(baseDir, alternativeDirGetter, nodeVersion, nodeDownloadRoot, false);
    }

    FrontendTools(String baseDir, Supplier<String> alternativeDirGetter, String nodeVersion, URI nodeDownloadRoot, boolean ignoreVersionChecks, boolean forceAlternativeNode) {
        this.baseDir = Objects.requireNonNull(baseDir);
        this.alternativeDirGetter = alternativeDirGetter;
        this.nodeVersion = Objects.requireNonNull(nodeVersion);
        this.nodeDownloadRoot = Objects.requireNonNull(nodeDownloadRoot);
        this.ignoreVersionChecks = ignoreVersionChecks;
        this.forceAlternativeNode = forceAlternativeNode;
    }

    public String getNodeExecutable() {
        Pair<String, String> nodeCommands = this.getNodeCommands();
        File file = this.getExecutable(this.baseDir, nodeCommands.getSecond());
        if (file == null && !this.forceAlternativeNode) {
            file = this.frontendToolsLocator.tryLocateTool(nodeCommands.getFirst()).orElse(null);
        }
        if (file == null) {
            file = this.getExecutable(this.getAlternativeDir(), nodeCommands.getSecond());
        }
        if (file == null && this.alternativeDirGetter != null) {
            this.getLogger().info("Couldn't find {}. Installing Node and NPM to {}.", (Object)nodeCommands.getFirst(), (Object)this.getAlternativeDir());
            file = new File(this.installNode(this.nodeVersion, this.nodeDownloadRoot));
        }
        if (file == null) {
            throw new IllegalStateException(String.format(NODE_NOT_FOUND, new Object[0]));
        }
        return file.getAbsolutePath();
    }

    public String forceAlternativeNodeExecutable() {
        Pair<String, String> nodeCommands = this.getNodeCommands();
        String dir = this.getAlternativeDir();
        File file = new File(dir, nodeCommands.getSecond());
        if (file.exists()) {
            if (!this.frontendToolsLocator.verifyTool(file)) {
                throw new IllegalStateException(String.format(LOCAL_NODE_NOT_FOUND, dir, dir, file.getAbsolutePath()));
            }
            return file.getAbsolutePath();
        }
        this.getLogger().info("Node not found in {}. Installing node {}.", (Object)dir, (Object)this.nodeVersion);
        return this.installNode(this.nodeVersion, this.nodeDownloadRoot);
    }

    public List<String> getNpmExecutable() {
        return this.getNpmExecutable(true);
    }

    public List<String> getPnpmExecutable() {
        List<String> pnpmCommand = this.getSuitablePnpm();
        assert (!pnpmCommand.isEmpty());
        pnpmCommand = new ArrayList<String>(pnpmCommand);
        pnpmCommand.add("--shamefully-hoist=true");
        return pnpmCommand;
    }

    public void validateNodeAndNpmVersion() {
        if (this.ignoreVersionChecks) {
            return;
        }
        try {
            FrontendVersion foundNodeVersion = this.getNodeVersion();
            FrontendUtils.validateToolVersion("node", foundNodeVersion, SUPPORTED_NODE_VERSION, SHOULD_WORK_NODE_VERSION);
        }
        catch (FrontendUtils.UnknownVersionException e) {
            this.getLogger().warn("Error checking if node is new enough", (Throwable)e);
        }
        try {
            FrontendVersion foundNpmVersion = this.getNpmVersion();
            FrontendUtils.validateToolVersion("npm", foundNpmVersion, SUPPORTED_NPM_VERSION, SHOULD_WORK_NPM_VERSION);
            this.checkForFaultyNpmVersion(foundNpmVersion);
        }
        catch (FrontendUtils.UnknownVersionException e) {
            this.getLogger().warn("Error checking if npm is new enough", (Throwable)e);
        }
    }

    public List<String> getBowerExecutable() {
        File file = new File(this.baseDir, "node_modules/bower/bin/bower");
        if (file.canRead()) {
            return Arrays.asList(this.getNodeExecutable(), file.getAbsolutePath());
        }
        String command = FrontendUtils.isWindows() ? "bower.cmd" : "bower";
        return this.frontendToolsLocator.tryLocateTool(command).map(File::getPath).map(Collections::singletonList).orElse(Collections.emptyList());
    }

    public FrontendVersion getNodeVersion() throws FrontendUtils.UnknownVersionException {
        ArrayList<String> nodeVersionCommand = new ArrayList<String>();
        nodeVersionCommand.add(this.doGetNodeExecutable());
        nodeVersionCommand.add("--version");
        return FrontendUtils.getVersion("node", nodeVersionCommand);
    }

    protected String installNode(String nodeVersion, URI downloadRoot) {
        NodeInstaller nodeInstaller = new NodeInstaller(new File(this.getAlternativeDir()), this.getProxies()).setNodeVersion(nodeVersion);
        if (downloadRoot != null) {
            nodeInstaller.setNodeDownloadRoot(downloadRoot);
        }
        try {
            nodeInstaller.install();
        }
        catch (InstallationException e) {
            throw new IllegalStateException("Failed to install Node", e);
        }
        return new File(nodeInstaller.getInstallDirectory(), this.getNodeCommands().getFirst()).toString();
    }

    protected List<ProxyConfig.Proxy> getProxies() {
        File projectNpmrc = new File(this.baseDir, ".npmrc");
        File userNpmrc = new File(FileUtils.getUserDirectory(), ".npmrc");
        ArrayList<ProxyConfig.Proxy> proxyList = new ArrayList<ProxyConfig.Proxy>();
        proxyList.addAll(this.readProxySettingsFromSystemProperties());
        proxyList.addAll(this.readProxySettingsFromNpmrcFile("user .npmrc", userNpmrc));
        proxyList.addAll(this.readProxySettingsFromNpmrcFile("project .npmrc", projectNpmrc));
        proxyList.addAll(this.readProxySettingsFromEnvironmentVariables());
        return proxyList;
    }

    void checkForFaultyNpmVersion(FrontendVersion npmVersion) {
        if (NPM_BLACKLISTED_VERSIONS.contains(npmVersion)) {
            String badNpmVersion = this.buildBadVersionString("npm", npmVersion.getFullVersion(), "by updating your global npm installation with `npm install -g npm@latest`", "by setting the plugin configuration `<requireHomeNodeExec>true</requireHomeNodeExec>`", "by giving the system property `require.home.node=true`");
            throw new IllegalStateException(badNpmVersion);
        }
    }

    boolean folderIsAcceptableByNpm(File folder) {
        boolean hidden;
        Objects.requireNonNull(folder);
        boolean bl = hidden = folder.isHidden() || folder.getPath().contains(File.separator + ".");
        if (!(hidden || folder.exists() && folder.isDirectory())) {
            this.getLogger().warn("Failed to check whether npm accepts the folder '{}', because the folder doesn't exist or not a directory", (Object)folder);
            return true;
        }
        if (FrontendUtils.isWindows() && folder.getAbsolutePath().matches(".*[\\s+].*")) {
            try {
                FrontendVersion foundNpmVersion = this.getNpmVersion();
                return FrontendUtils.isVersionAtLeast(foundNpmVersion, WHITESPACE_ACCEPTING_NPM_VERSION);
            }
            catch (FrontendUtils.UnknownVersionException e) {
                this.getLogger().warn("Error checking if npm accepts path '{}'", (Object)folder, (Object)e);
            }
        }
        return true;
    }

    File getNpmCacheDir() throws FrontendUtils.CommandExecutionException, IllegalStateException {
        ArrayList<String> npmCacheCommand = new ArrayList<String>(this.getNpmExecutable(false));
        npmCacheCommand.add("config");
        npmCacheCommand.add("get");
        npmCacheCommand.add("cache");
        npmCacheCommand.add("--global");
        String output = FrontendUtils.executeCommand(npmCacheCommand);
        output = this.removeLineBreaks(output);
        if (output.isEmpty()) {
            throw new IllegalStateException(String.format("Command '%s' returned an empty path", String.join((CharSequence)" ", npmCacheCommand)));
        }
        return new File(output);
    }

    private FrontendVersion getNpmVersion() throws FrontendUtils.UnknownVersionException {
        ArrayList<String> npmVersionCommand = new ArrayList<String>(this.getNpmExecutable(false));
        npmVersionCommand.add("--version");
        return FrontendUtils.getVersion("npm", npmVersionCommand);
    }

    public Map<String, String> getWebpackNodeEnvironment() {
        HashMap<String, String> environment = new HashMap<String, String>();
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(this.getNodeExecutable(), "-p", "crypto.createHash('md4')");
        try {
            Process process = processBuilder.start();
            int errorLevel = process.waitFor();
            if (errorLevel != 0) {
                environment.put("NODE_OPTIONS", "--openssl-legacy-provider");
            }
        }
        catch (IOException e) {
            this.getLogger().error("IO error while determining --openssl-legacy-provider parameter requirement", (Throwable)e);
        }
        catch (InterruptedException e) {
            this.getLogger().error("Interrupted while determining --openssl-legacy-provider parameter requirement", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return environment;
    }

    private File getExecutable(String dir, String location) {
        File file = new File(dir, location);
        if (this.frontendToolsLocator.verifyTool(file)) {
            return file;
        }
        return null;
    }

    private Pair<String, String> getNodeCommands() {
        if (FrontendUtils.isWindows()) {
            return new Pair<String, String>("node.exe", "node/node.exe");
        }
        return new Pair<String, String>("node", "node/node");
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(FrontendTools.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<ProxyConfig.Proxy> readProxySettingsFromNpmrcFile(String fileDescription, File npmrc) {
        if (!npmrc.exists()) {
            return Collections.emptyList();
        }
        try (FileReader fileReader = new FileReader(npmrc);){
            String proxyUrl;
            String httpsProxyUrl;
            ArrayList<ProxyConfig.Proxy> proxyList = new ArrayList<ProxyConfig.Proxy>(2);
            Properties properties = new Properties();
            properties.load(fileReader);
            String noproxy = properties.getProperty(NPMRC_NOPROXY_PROPERTY_KEY);
            if (noproxy != null) {
                noproxy = noproxy.replaceAll(",", "|");
            }
            if ((httpsProxyUrl = properties.getProperty(NPMRC_HTTPS_PROXY_PROPERTY_KEY)) != null) {
                proxyList.add(new ProxyConfig.Proxy("https-proxy - " + fileDescription, httpsProxyUrl, noproxy));
            }
            if ((proxyUrl = properties.getProperty(NPMRC_PROXY_PROPERTY_KEY)) != null) {
                proxyList.add(new ProxyConfig.Proxy("proxy - " + fileDescription, proxyUrl, noproxy));
            }
            ArrayList<ProxyConfig.Proxy> arrayList = proxyList;
            return arrayList;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private List<ProxyConfig.Proxy> readProxySettingsFromSystemProperties() {
        String proxyUrl;
        String httpsProxyUrl;
        ArrayList<ProxyConfig.Proxy> proxyList = new ArrayList<ProxyConfig.Proxy>(2);
        String noproxy = this.getNonNull(System.getProperty(SYSTEM_NOPROXY_PROPERTY_KEY), System.getProperty(SYSTEM_NOPROXY_PROPERTY_KEY.toLowerCase()));
        if (noproxy != null) {
            noproxy = noproxy.replaceAll(",", "|");
        }
        if ((httpsProxyUrl = this.getNonNull(System.getProperty(SYSTEM_HTTPS_PROXY_PROPERTY_KEY), System.getProperty(SYSTEM_HTTPS_PROXY_PROPERTY_KEY.toLowerCase()))) != null) {
            proxyList.add(new ProxyConfig.Proxy("https-proxy - system", httpsProxyUrl, noproxy));
        }
        if ((proxyUrl = this.getNonNull(System.getProperty(SYSTEM_HTTP_PROXY_PROPERTY_KEY), System.getProperty(SYSTEM_HTTP_PROXY_PROPERTY_KEY.toLowerCase()))) != null) {
            proxyList.add(new ProxyConfig.Proxy("proxy - system", proxyUrl, noproxy));
        }
        return proxyList;
    }

    private List<ProxyConfig.Proxy> readProxySettingsFromEnvironmentVariables() {
        String proxyUrl;
        String httpsProxyUrl;
        ArrayList<ProxyConfig.Proxy> proxyList = new ArrayList<ProxyConfig.Proxy>(2);
        String noproxy = this.getNonNull(System.getenv(SYSTEM_NOPROXY_PROPERTY_KEY), System.getenv(SYSTEM_NOPROXY_PROPERTY_KEY.toLowerCase()));
        if (noproxy != null) {
            noproxy = noproxy.replaceAll(",", "|");
        }
        if ((httpsProxyUrl = this.getNonNull(System.getenv(SYSTEM_HTTPS_PROXY_PROPERTY_KEY), System.getenv(SYSTEM_HTTPS_PROXY_PROPERTY_KEY.toLowerCase()))) != null) {
            proxyList.add(new ProxyConfig.Proxy("https-proxy - env", httpsProxyUrl, noproxy));
        }
        if ((proxyUrl = this.getNonNull(System.getenv(SYSTEM_HTTP_PROXY_PROPERTY_KEY), System.getenv(SYSTEM_HTTP_PROXY_PROPERTY_KEY.toLowerCase()))) != null) {
            proxyList.add(new ProxyConfig.Proxy("proxy - env", proxyUrl, noproxy));
        }
        return proxyList;
    }

    private String getNonNull(String ... valueArray) {
        for (String value : valueArray) {
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private List<String> getNpmExecutable(boolean removePnpmLock) {
        ArrayList<String> returnCommand = new ArrayList<String>(this.getNpmCliToolExecutable(NpmCliTool.NPM, new String[0]));
        returnCommand.add("--no-update-notifier");
        returnCommand.add("--no-audit");
        returnCommand.add("--scripts-prepend-node-path=true");
        if (removePnpmLock && new File(this.baseDir, "pnpm-lock.yaml").delete()) {
            this.getLogger().debug("pnpm-lock.yaml file is removed from " + this.baseDir);
        }
        return returnCommand;
    }

    private List<String> getNpmCliToolExecutable(NpmCliTool cliTool, String ... flags) {
        Optional<String> command;
        List<String> returnCommand = this.getNpmScriptCommand(this.baseDir, cliTool.getScript());
        boolean alternativeDirChecked = false;
        if (returnCommand.isEmpty() && this.forceAlternativeNode) {
            returnCommand = this.getNpmScriptCommand(this.getAlternativeDir(), cliTool.getScript());
            alternativeDirChecked = true;
        }
        if (returnCommand.isEmpty() && (command = this.frontendToolsLocator.tryLocateTool(cliTool.getCommand()).map(File::getAbsolutePath)).isPresent()) {
            returnCommand = Collections.singletonList(command.get());
        }
        if (!alternativeDirChecked && returnCommand.isEmpty()) {
            returnCommand = this.getNpmScriptCommand(this.getAlternativeDir(), cliTool.getScript());
        }
        if (flags.length > 0) {
            returnCommand = new ArrayList<String>(returnCommand);
            Collections.addAll(returnCommand, flags);
        }
        return returnCommand;
    }

    private List<String> getNpmScriptCommand(String dir, String scriptName) {
        File file = new File(dir, "node/node_modules/npm/bin/" + scriptName);
        ArrayList<String> returnCommand = new ArrayList<String>();
        if (file.canRead()) {
            returnCommand.add(this.doGetNodeExecutable());
            returnCommand.add(file.getAbsolutePath());
        }
        return returnCommand;
    }

    List<String> getSuitablePnpm() {
        String pnpmSpecifier = this.ignoreVersionChecks ? "pnpm" : "pnpm@5";
        List pnpmCommand = Stream.of(pnpmSpecifier).map(pnpm -> this.getNpmCliToolExecutable(NpmCliTool.NPX, "--yes", "--quiet", (String)pnpm)).filter(this::validatePnpmVersion).findFirst().orElseThrow(() -> new IllegalStateException("Found too old 'pnpm'. If installed into the project 'node_modules', upgrade 'pnpm' to at least " + SUPPORTED_PNPM_VERSION.getFullVersion()));
        this.getLogger().info("using '{}' for frontend package installation", (Object)String.join((CharSequence)" ", pnpmCommand));
        return pnpmCommand;
    }

    private boolean validatePnpmVersion(List<String> pnpmCommand) {
        String commandLine = String.join((CharSequence)" ", pnpmCommand);
        try {
            boolean versionAccepted;
            ArrayList<String> versionCmd = new ArrayList<String>(pnpmCommand);
            versionCmd.add("--version");
            FrontendVersion pnpmVersion = FrontendUtils.getVersion("pnpm", versionCmd);
            boolean versionNewEnough = FrontendUtils.isVersionAtLeast(pnpmVersion, SUPPORTED_PNPM_VERSION);
            boolean bl = versionAccepted = this.ignoreVersionChecks || versionNewEnough;
            if (!versionAccepted) {
                this.getLogger().info("pnpm '{}' is version {} which is not supported (expected >={})", new Object[]{commandLine, pnpmVersion.getFullVersion(), SUPPORTED_PNPM_VERSION.getFullVersion()});
            }
            return versionAccepted;
        }
        catch (FrontendUtils.UnknownVersionException e) {
            this.getLogger().warn("version check '{}' failed", (Object)commandLine, (Object)e);
            return false;
        }
    }

    private String buildBadVersionString(String tool, String version, String ... extraUpdateInstructions) {
        StringBuilder extraInstructions = new StringBuilder();
        for (String instruction : extraUpdateInstructions) {
            extraInstructions.append("%n  - or ").append(instruction);
        }
        return String.format(BAD_VERSION, tool, version, String.format(extraInstructions.toString(), new Object[0]), "vaadin.ignoreVersionChecks");
    }

    private String getAlternativeDir() {
        return this.alternativeDirGetter.get();
    }

    private String doGetNodeExecutable() {
        if (this.forceAlternativeNode) {
            return this.forceAlternativeNodeExecutable();
        }
        return this.getNodeExecutable();
    }

    private String removeLineBreaks(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return String.join((CharSequence)"", str.split(System.lineSeparator()));
    }

    private static enum NpmCliTool {
        NPM("npm", "npm-cli.js"),
        NPX("npx", "npx-cli.js");

        private final String name;
        private final String script;

        private NpmCliTool(String tool, String script) {
            this.name = tool;
            this.script = script;
        }

        String getCommand() {
            return FrontendUtils.isWindows() ? this.name + ".cmd" : this.name;
        }

        String getScript() {
            return this.script;
        }
    }
}

