/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.internal.JsonCodec;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.NodeMap;
import java.io.Serializable;
import java.util.stream.Stream;

public abstract class AbstractPropertyMap
extends NodeMap {
    public AbstractPropertyMap(StateNode node) {
        super(node);
    }

    public void setProperty(String name, Serializable value, boolean emitChange) {
        assert (name != null);
        assert (AbstractPropertyMap.isValidValueType(value));
        this.put(name, value, emitChange);
    }

    public boolean hasProperty(String name) {
        return this.contains(name);
    }

    public void removeProperty(String name) {
        super.remove(name);
    }

    public void removeAllProperties() {
        super.clear();
    }

    public Serializable getProperty(String name) {
        return this.get(name);
    }

    public Stream<String> getPropertyNames() {
        return this.keySet().stream();
    }

    public static boolean isValidValueType(Serializable value) {
        if (value == null) {
            return true;
        }
        Class<?> type = ReflectTools.convertPrimitiveType(value.getClass());
        return JsonCodec.canEncodeWithoutTypeInfo(type) || StateNode.class.isAssignableFrom(type);
    }
}

