/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.OptionalParameter;
import com.vaadin.flow.router.ParameterDeserializer;
import com.vaadin.flow.router.RouteData;
import com.vaadin.flow.router.internal.DefaultErrorHandler;
import com.vaadin.flow.server.auth.AnonymousAllowed;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.safety.Whitelist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="div")
@AnonymousAllowed
@DefaultErrorHandler
public class RouteNotFoundError
extends Component
implements HasErrorParameter<NotFoundException> {
    @Override
    public int setErrorParameter(BeforeEnterEvent event, ErrorParameter<NotFoundException> parameter) {
        if (RouteNotFoundError.getLogger().isDebugEnabled()) {
            RouteNotFoundError.getLogger().debug(parameter.hasCustomMessage() ? parameter.getCustomMessage() : "Route is not found", (Throwable)parameter.getCaughtException());
        }
        String path = event.getLocation().getPath();
        Object additionalInfo = "";
        if (parameter.hasCustomMessage()) {
            additionalInfo = "Reason: " + parameter.getCustomMessage();
        }
        path = Jsoup.clean((String)path, (Whitelist)Whitelist.none());
        additionalInfo = Jsoup.clean((String)additionalInfo, (Whitelist)Whitelist.none());
        boolean productionMode = event.getUI().getSession().getConfiguration().isProductionMode();
        String template = RouteNotFoundError.getErrorHtml(productionMode);
        if (template.contains("{{routes}}")) {
            template = template.replace("{{routes}}", this.getRoutes(event));
        }
        template = template.replace("{{additionalInfo}}", (CharSequence)additionalInfo);
        template = template.replace("{{path}}", path);
        this.getElement().setChild(0, new Html(template).getElement());
        return 404;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(RouteNotFoundError.class);
    }

    private static String getErrorHtml(boolean productionMode) {
        if (productionMode) {
            return LazyInit.PRODUCTION_MODE_TEMPLATE;
        }
        return RouteNotFoundError.readHtmlFile("RouteNotFoundError_dev.html");
    }

    private static String readHtmlFile(String templateName) {
        String string;
        block8: {
            InputStream stream = RouteNotFoundError.class.getResourceAsStream(templateName);
            try {
                string = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    RouteNotFoundError.getLogger().error("Unable to read " + templateName, (Throwable)e);
                    return "Could not navigate to '{{path}}'";
                }
            }
            stream.close();
        }
        return string;
    }

    private String getRoutes(BeforeEnterEvent event) {
        List<RouteData> routes = event.getSource().getRegistry().getRegisteredRoutes();
        TreeMap<String, Class> routeTemplates = new TreeMap<String, Class>();
        for (RouteData route : routes) {
            routeTemplates.put(route.getTemplate(), route.getNavigationTarget());
            route.getRouteAliases().forEach(alias -> routeTemplates.put(alias.getTemplate(), alias.getNavigationTarget()));
        }
        ArrayList routeElements = new ArrayList();
        routeTemplates.forEach((k, v) -> routeElements.add(this.routeTemplateToHtml((String)k, (Class<? extends Component>)v)));
        return routeElements.stream().map(Node::outerHtml).collect(Collectors.joining());
    }

    private Element routeTemplateToHtml(String routeTemplate, Class<? extends Component> navigationTarget) {
        Object text = routeTemplate;
        if (text == null || ((String)text).isEmpty()) {
            text = "<root>";
        }
        if (!routeTemplate.contains(":")) {
            return this.elementAsLink(routeTemplate, (String)text);
        }
        text = ParameterDeserializer.isAnnotatedParameter(navigationTarget, OptionalParameter.class) ? (String)text + " (supports optional parameter)" : (String)text + " (requires parameter)";
        return new Element("li").text((String)text);
    }

    private Element elementAsLink(String url, String text) {
        Element link = new Element("a").attr("href", url).text(text);
        return new Element("li").appendChild((Node)link);
    }

    private static class LazyInit {
        private static final String PRODUCTION_MODE_TEMPLATE = RouteNotFoundError.readHtmlFile("RouteNotFoundError_prod.html");

        private LazyInit() {
        }
    }
}

