/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.googlecode.gentyref.GenericTypeReflector;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.OneTimeInitializerPredicate;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.server.AmbiguousRouteConfigurationException;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.startup.AbstractAnnotationValidator;
import com.vaadin.flow.server.startup.AbstractRouteRegistryInitializer;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import com.vaadin.flow.server.startup.VaadinInitializerException;
import com.vaadin.flow.server.startup.VaadinServletContextStartupInitializer;
import java.util.Set;
import javax.servlet.annotation.HandlesTypes;

@HandlesTypes(value={Route.class, RouteAlias.class})
public class RouteRegistryInitializer
extends AbstractRouteRegistryInitializer
implements VaadinServletContextStartupInitializer {
    @Override
    public void initialize(Set<Class<?>> classSet, VaadinContext context) throws VaadinInitializerException {
        try {
            Set<Class<?>> routesSet = AbstractAnnotationValidator.removeHandleTypesSelfReferences(classSet, this);
            ApplicationRouteRegistry routeRegistry = ApplicationRouteRegistry.getInstance(context);
            Set<Class<? extends Component>> routes = this.validateRouteClasses(context, routesSet.stream());
            routeRegistry.update(() -> {
                if (this.removePreviousRoutes(context, routeRegistry)) {
                    this.configureStaticRoutesRegistry(context, routes);
                }
                this.configureRoutes(routes, routeRegistry);
            });
            routeRegistry.setPwaConfigurationClass(this.validatePwaClass(context, routes.stream().map(clazz -> clazz)));
        }
        catch (InvalidRouteConfigurationException irce) {
            throw new VaadinInitializerException("Exception while registering Routes on servlet startup", irce);
        }
    }

    private void configureStaticRoutesRegistry(VaadinContext context, Set<Class<? extends Component>> routes) {
        PreviouslyStoredRoutesRegistry registry = new PreviouslyStoredRoutesRegistry(context);
        this.configureRoutes(routes, registry);
        context.setAttribute(registry);
    }

    private boolean removePreviousRoutes(VaadinContext context, ApplicationRouteRegistry registry) {
        Lookup lookup = context.getAttribute(Lookup.class);
        OneTimeInitializerPredicate oneTimeInitializer = lookup.lookup(OneTimeInitializerPredicate.class);
        if (oneTimeInitializer != null && oneTimeInitializer.runOnce()) {
            return false;
        }
        PreviouslyStoredRoutesRegistry prevoiusRegistry = context.getAttribute(PreviouslyStoredRoutesRegistry.class);
        if (prevoiusRegistry != null) {
            prevoiusRegistry.getRegisteredRoutes().forEach(routeData -> {
                registry.removeRoute(routeData.getTemplate());
                routeData.getRouteAliases().forEach(alias -> registry.removeRoute(alias.getTemplate()));
            });
        }
        return true;
    }

    private void configureRoutes(Set<Class<? extends Component>> routes, ApplicationRouteRegistry routeRegistry) {
        RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry(routeRegistry);
        routeConfiguration.update(() -> this.setAnnotatedRoutes(routeConfiguration, routes));
    }

    private void setAnnotatedRoutes(RouteConfiguration routeConfiguration, Set<Class<? extends Component>> routes) {
        for (Class<? extends Component> navigationTarget : routes) {
            try {
                routeConfiguration.setAnnotatedRoute(navigationTarget);
            }
            catch (AmbiguousRouteConfigurationException exception) {
                if (this.handleAmbiguousRoute(routeConfiguration, exception.getConfiguredNavigationTarget(), navigationTarget)) continue;
                throw exception;
            }
        }
    }

    private boolean handleAmbiguousRoute(RouteConfiguration routeConfiguration, Class<? extends Component> configuredNavigationTarget, Class<? extends Component> navigationTarget) {
        if (GenericTypeReflector.isSuperType(navigationTarget, configuredNavigationTarget)) {
            return true;
        }
        if (GenericTypeReflector.isSuperType(configuredNavigationTarget, navigationTarget)) {
            routeConfiguration.removeRoute(configuredNavigationTarget);
            routeConfiguration.setAnnotatedRoute(navigationTarget);
            return true;
        }
        return false;
    }

    private static class PreviouslyStoredRoutesRegistry
    extends ApplicationRouteRegistry {
        private PreviouslyStoredRoutesRegistry(VaadinContext context) {
            super(context);
        }
    }
}

