/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.router.internal.BeforeEnterHandler;
import com.vaadin.flow.router.internal.BeforeLeaveHandler;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Deque;

public class Postpone
implements Serializable {
    private final ArrayDeque<BeforeLeaveHandler> remainingLeaveListeners;
    private final ArrayDeque<BeforeEnterHandler> remainingNavigationListeners;

    private Postpone(Deque<BeforeLeaveHandler> beforeLeave, Deque<BeforeEnterHandler> beforeNavigation) {
        this.remainingLeaveListeners = new ArrayDeque<BeforeLeaveHandler>(beforeLeave);
        this.remainingNavigationListeners = new ArrayDeque<BeforeEnterHandler>(beforeNavigation);
    }

    public static Postpone withLeaveObservers(Deque<BeforeLeaveHandler> beforeLeave) {
        return new Postpone(beforeLeave, new ArrayDeque<BeforeEnterHandler>());
    }

    public static Postpone withNavigationObservers(Deque<BeforeEnterHandler> beforeNavigation) {
        return new Postpone(new ArrayDeque<BeforeLeaveHandler>(), beforeNavigation);
    }

    public Deque<BeforeLeaveHandler> getLeaveObservers() {
        return this.remainingLeaveListeners;
    }

    public Deque<BeforeEnterHandler> getNavigationObservers() {
        return this.remainingNavigationListeners;
    }
}

