/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.template.internal;

import com.vaadin.flow.component.template.internal.InjectableFieldConsumer;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;

public class ParserData {
    private final Map<String, String> tagById;
    private final Map<Field, String> idByField;
    private final Map<String, Map<String, String>> attributesById;

    public ParserData(Map<Field, String> fields, Map<String, String> tags, Map<String, Map<String, String>> attributes) {
        this.tagById = Collections.unmodifiableMap(tags);
        this.idByField = Collections.unmodifiableMap(fields);
        this.attributesById = Collections.unmodifiableMap(attributes);
    }

    public void forEachInjectedField(InjectableFieldConsumer consumer) {
        this.idByField.forEach((field, id) -> consumer.apply((Field)field, (String)id, this.tagById.get(id)));
    }

    public Map<String, String> getAttributes(String id) {
        Map<String, String> attrs = this.attributesById.get(id);
        if (attrs == null) {
            return Collections.emptyMap();
        }
        return attrs;
    }
}

