/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.BootstrapHandlerHelper;
import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.flow.internal.BrowserLiveReloadAccessor;
import com.vaadin.flow.internal.LocaleUtil;
import com.vaadin.flow.internal.UsageStatisticsExporter;
import com.vaadin.flow.internal.springcsrf.SpringCsrfTokenUtil;
import com.vaadin.flow.server.AppShellRegistry;
import com.vaadin.flow.server.BootstrapHandler;
import com.vaadin.flow.server.Mode;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.IndexHtmlResponse;
import com.vaadin.flow.server.communication.JavaScriptBootstrapHandler;
import com.vaadin.flow.server.frontend.FrontendUtils;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Optional;
import org.jsoup.Jsoup;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexHtmlRequestHandler
extends JavaScriptBootstrapHandler {
    private static final String SCRIPT = "script";
    private static final String SCRIPT_INITIAL = "initial";
    public static final String LIVE_RELOAD_PORT_ATTR = "livereload.port";

    @Override
    public boolean synchronizedHandleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        IndexHtmlResponse indexHtmlResponse;
        if (this.writeErrorCodeIfRequestLocationIsInvalid(request, response)) {
            return true;
        }
        DeploymentConfiguration config = session.getConfiguration();
        VaadinService service = request.getService();
        Document indexDocument = config.isProductionMode() ? IndexHtmlRequestHandler.getCachedIndexHtmlDocument(service) : IndexHtmlRequestHandler.getIndexHtmlDocument(service);
        IndexHtmlRequestHandler.prependBaseHref(request, indexDocument);
        Element htmlElement = (Element)indexDocument.getElementsByTag("html").get(0);
        if (!htmlElement.hasAttr("lang")) {
            Locale locale = LocaleUtil.getLocale(LocaleUtil::getI18NProvider);
            htmlElement.attr("lang", locale.getLanguage());
        }
        JsonObject initialJson = Json.createObject();
        if (service.getBootstrapInitialPredicate().includeInitialUidl(request)) {
            this.includeInitialUidl(initialJson, session, request, response);
            indexHtmlResponse = new IndexHtmlResponse(request, response, indexDocument, UI.getCurrent());
            session.setAttribute("clientRoutingMode", Boolean.TRUE);
        } else {
            indexHtmlResponse = new IndexHtmlResponse(request, response, indexDocument);
        }
        this.addInitialFlow(initialJson, indexDocument, request);
        this.configureErrorDialogStyles(indexDocument);
        this.configureHiddenElementStyles(indexDocument);
        response.setContentType("text/html; charset=utf-8");
        VaadinContext context = session.getService().getContext();
        AppShellRegistry registry = AppShellRegistry.getInstance(context);
        if (!config.isProductionMode()) {
            UsageStatisticsExporter.exportUsageStatisticsToDocument(indexDocument);
        }
        IndexHtmlRequestHandler.setupPwa(indexDocument, session.getService());
        registry.modifyIndexHtml(indexDocument, request);
        this.storeAppShellTitleToUI(indexDocument);
        this.redirectToOldBrowserPageWhenNeeded(indexDocument);
        if (!config.isProductionMode()) {
            IndexHtmlRequestHandler.addScript(indexDocument, "window.Vaadin = window.Vaadin || {}; window.Vaadin.developmentMode = true;");
        }
        this.applyThemeVariant(indexDocument, context);
        if (config.isDevToolsEnabled()) {
            this.addDevTools(indexDocument, config, session, request);
            this.catchErrorsInDevMode(indexDocument);
            IndexHtmlRequestHandler.addLicenseChecker(indexDocument);
        }
        service.modifyIndexHtmlResponse(indexHtmlResponse);
        try {
            response.getOutputStream().write(indexDocument.html().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            IndexHtmlRequestHandler.getLogger().error("Error writing 'index.html' to response", (Throwable)e);
            return false;
        }
        return true;
    }

    private void applyThemeVariant(Document indexDocument, VaadinContext context) throws IOException {
        FrontendUtils.getThemeAnnotation(context).ifPresent(theme -> indexDocument.head().parent().attr("theme", theme.variant()));
    }

    private void redirectToOldBrowserPageWhenNeeded(Document indexDocument) {
        IndexHtmlRequestHandler.addScript(indexDocument, "if (!('CSSLayerBlockRule' in window)) {\n    window.location.search='v-r=oldbrowser';\n}\n");
    }

    private void catchErrorsInDevMode(Document indexDocument) {
        IndexHtmlRequestHandler.addScript(indexDocument, "window.Vaadin = window.Vaadin || {};window.Vaadin.ConsoleErrors = window.Vaadin.ConsoleErrors || [];const browserConsoleError = window.console.error.bind(window.console);console.error = (...args) => {    browserConsoleError(...args);    window.Vaadin.ConsoleErrors.push(args);};window.onerror = (message, source, lineno, colno, error) => {const location=source+':'+lineno+':'+colno;window.Vaadin.ConsoleErrors.push([message, '('+location+')']);};window.addEventListener('unhandledrejection', e => {    window.Vaadin.ConsoleErrors.push([e.reason]);});");
    }

    public static void addLicenseChecker(Document indexDocument) {
        IndexHtmlRequestHandler.addScript(indexDocument, "window.Vaadin = window.Vaadin || {};window.Vaadin.VaadinLicenseChecker = {  maybeCheck: (productInfo) => {  }};window.Vaadin.devTools = window.Vaadin.devTools || {};window.Vaadin.devTools.createdCvdlElements = window.Vaadin.devTools.createdCvdlElements || [];window.Vaadin.originalCustomElementDefineFn = window.Vaadin.originalCustomElementDefineFn || window.customElements.define;window.customElements.define = function (tagName, constructor, ...args) {const { cvdlName, version } = constructor;if (cvdlName && version) {  const { connectedCallback } = constructor.prototype;  constructor.prototype.connectedCallback = function () {    window.Vaadin.devTools.createdCvdlElements.push(this);    if (connectedCallback) {      connectedCallback.call(this);    }  }}window.Vaadin.originalCustomElementDefineFn.call(this, tagName, constructor, ...args);};");
    }

    private static void addScript(Document indexDocument, String script) {
        Element elm = new Element(SCRIPT);
        elm.attr(SCRIPT_INITIAL, "");
        elm.appendChild((Node)new DataNode(script));
        indexDocument.head().insertChildren(0, new Node[]{elm});
    }

    private void storeAppShellTitleToUI(Document indexDocument) {
        Element elm;
        if (UI.getCurrent() != null && (elm = indexDocument.head().selectFirst("title")) != null) {
            String appShellTitle = elm.text().isEmpty() ? elm.data() : elm.text();
            UI.getCurrent().getInternals().setAppShellTitle(appShellTitle);
        }
    }

    private void addDevTools(Document indexDocument, DeploymentConfiguration config, VaadinSession session, VaadinRequest request) {
        VaadinService service = session.getService();
        Optional<BrowserLiveReload> liveReload = BrowserLiveReloadAccessor.getLiveReloadFromService(service);
        if (liveReload.isPresent()) {
            VaadinServletContext vaadinServletContext;
            String customPort;
            Element devTools = new Element("vaadin-dev-tools");
            if (!config.isDevModeLiveReloadEnabled()) {
                devTools.attr("liveReloadDisabled", "");
            }
            devTools.attr("url", BootstrapHandlerHelper.getPushURL(session, request));
            BrowserLiveReload.Backend backend = liveReload.get().getBackend();
            if (backend != null) {
                devTools.attr("backend", backend.toString());
            }
            String liveReloadPort = "35729";
            VaadinContext context = service.getContext();
            if (context instanceof VaadinServletContext && (customPort = (String)(vaadinServletContext = (VaadinServletContext)context).getContext().getAttribute(LIVE_RELOAD_PORT_ATTR)) != null) {
                liveReloadPort = customPort;
            }
            devTools.attr("springbootlivereloadport", liveReloadPort);
            indexDocument.body().appendChild((Node)devTools);
        }
    }

    private void addInitialFlow(JsonObject initialJson, Document indexDocument, VaadinRequest request) {
        SpringCsrfTokenUtil.addTokenAsMetaTagsToHeadIfPresentInRequest(indexDocument.head(), request);
        Element elm = new Element(SCRIPT);
        elm.attr(SCRIPT_INITIAL, "");
        elm.appendChild((Node)new DataNode("window.Vaadin = window.Vaadin || {};window.Vaadin.TypeScript= " + JsonUtil.stringify((JsonValue)initialJson) + ";"));
        indexDocument.head().insertChildren(0, new Node[]{elm});
    }

    private void includeInitialUidl(JsonObject initialJson, VaadinSession session, VaadinRequest request, VaadinResponse response) {
        JsonObject initial = this.getInitialJson(request, response, session);
        initialJson.put(SCRIPT_INITIAL, (JsonValue)initial);
    }

    @Override
    protected boolean canHandleRequest(VaadinRequest request) {
        return this.isRequestForHtml(request) && !BootstrapHandler.isFrameworkInternalRequest(request) && !BootstrapHandler.isVaadinStaticFileRequest(request) && request.getService().getBootstrapUrlPredicate().isValidUrl(request);
    }

    @Override
    protected void initializeUIWithRouter(BootstrapHandler.BootstrapContext context, UI ui) {
        if (context.getService().getBootstrapInitialPredicate().includeInitialUidl(context.getRequest())) {
            ui.getInternals().getRouter().initializeUI(ui, context.getRoute());
        }
    }

    private void configureErrorDialogStyles(Document document) {
        Element styles = document.createElement("style");
        document.head().appendChild((Node)styles);
        IndexHtmlRequestHandler.setupErrorDialogs(styles);
    }

    private void configureHiddenElementStyles(Document document) {
        Element styles = document.createElement("style");
        document.head().appendChild((Node)styles);
        IndexHtmlRequestHandler.setupHiddenElement(styles);
    }

    private static void prependBaseHref(VaadinRequest request, Document indexDocument) {
        Elements base = indexDocument.head().getElementsByTag("base");
        String baseHref = IndexHtmlRequestHandler.getServiceUrl(request);
        if (base.isEmpty()) {
            indexDocument.head().prependElement("base").attr("href", baseHref);
        } else {
            base.first().attr("href", baseHref);
        }
    }

    private static Document getCachedIndexHtmlDocument(VaadinService service) {
        return service.getContext().getAttribute(IndexHtmlHolder.class, () -> new IndexHtmlHolder(service)).getDocument();
    }

    private static Document getIndexHtmlDocument(VaadinService service) throws IOException {
        DeploymentConfiguration config = service.getDeploymentConfiguration();
        String index = FrontendUtils.getIndexHtmlContent(service);
        if (index == null) {
            if (config.isProductionMode()) {
                throw new IOException("Unable to find index.html. It should be available on the classpath when running in production mode");
            }
            throw new IOException("Unable to find index.html. It should be available in the frontend folder when running in development mode");
        }
        Document indexHtmlDocument = Jsoup.parse((String)index);
        Mode mode = config.getMode();
        if (mode != Mode.PRODUCTION && mode == Mode.DEVELOPMENT_BUNDLE) {
            IndexHtmlRequestHandler.addGeneratedIndexContent(indexHtmlDocument, IndexHtmlRequestHandler.getStatsJson(config));
        }
        IndexHtmlRequestHandler.modifyIndexHtmlForVite(indexHtmlDocument);
        return indexHtmlDocument;
    }

    protected static void addGeneratedIndexContent(Document targetDocument, JsonObject statsJson) {
        Element indexHtmlScript = null;
        JsonArray entryScripts = statsJson.getArray("entryScripts");
        for (int i = 0; i < entryScripts.length(); ++i) {
            String entryScript = entryScripts.getString(i);
            if (entryScript.contains("webcomponenthtml")) continue;
            Element elm = new Element(SCRIPT);
            elm.attr("type", "module");
            elm.attr("src", entryScript);
            targetDocument.head().appendChild((Node)elm);
            if (!entryScript.contains("indexhtml")) continue;
            indexHtmlScript = elm;
        }
    }

    private static void modifyIndexHtmlForVite(Document indexHtmlDocument) {
        indexHtmlDocument.head().prepend("<script type='text/javascript'>window.JSCompiler_renameProperty = function(a) { return a;}</script>");
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(IndexHtmlRequestHandler.class);
    }

    static final class IndexHtmlHolder
    implements Serializable {
        private final transient Document indexHtmlDocument;

        private IndexHtmlHolder(VaadinService service) {
            try {
                this.indexHtmlDocument = IndexHtmlRequestHandler.getIndexHtmlDocument(service);
                this.indexHtmlDocument.outputSettings().prettyPrint(false);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private Document getDocument() {
            return this.indexHtmlDocument.clone();
        }
    }
}

