/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.internal.StringUtil;
import com.vaadin.flow.server.frontend.Options;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BundleUtils {
    private BundleUtils() {
    }

    public static Set<String> loadBundleImports() {
        JsonObject statsJson = BundleUtils.loadStatsJson();
        if (!statsJson.hasKey("bundleImports")) {
            return null;
        }
        HashSet<String> bundledImports = new HashSet<String>();
        JsonArray bundleImports = statsJson.getArray("bundleImports");
        for (int i = 0; i < bundleImports.length(); ++i) {
            String jsImport = bundleImports.getString(i);
            bundledImports.add(jsImport);
            bundledImports.add(jsImport.replace("/theme/lumo/", "/src/"));
            bundledImports.add(jsImport.replace("/theme/material/", "/src/"));
            bundledImports.add(jsImport.replaceFirst("^Frontend/generated/jar-resources/", "./"));
            bundledImports.add(jsImport.replaceFirst("^Frontend/generated/jar-resources/", ""));
            bundledImports.add(jsImport.replaceFirst("^Frontend/", "./"));
            bundledImports.add(jsImport.replaceFirst("^Frontend/", ""));
        }
        return Collections.unmodifiableSet(bundledImports);
    }

    static JsonObject loadStatsJson() {
        URL statsUrl = BundleUtils.class.getClassLoader().getResource("META-INF/VAADIN/config/stats.json");
        if (statsUrl == null) {
            return Json.createObject();
        }
        try {
            return Json.parse((String)IOUtils.toString((URL)statsUrl, (Charset)StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            BundleUtils.getLogger().warn("Unable to parse META-INF/VAADIN/config/stats.json", (Throwable)e);
            return Json.createObject();
        }
    }

    public static String getChunkId(Class<? extends Component> componentClass) {
        return BundleUtils.getChunkId(componentClass.getName());
    }

    public static String getChunkId(String className) {
        return StringUtil.getHash(className, StandardCharsets.UTF_8);
    }

    public static String getChunkHash(List<String> chunkLines) {
        ArrayList<String> sortedChunkLines = new ArrayList<String>(chunkLines);
        Collections.sort(sortedChunkLines);
        return StringUtil.getHash(String.join((CharSequence)";", sortedChunkLines), StandardCharsets.UTF_8);
    }

    public static boolean isPreCompiledProductionBundle() {
        JsonObject stats = BundleUtils.loadStatsJson();
        return stats.hasKey("pre-compiled");
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(BundleUtils.class);
    }

    public static void copyPackageLockFromBundle(Options options) {
        String lockFile = options.isEnablePnpm() ? "pnpm-lock.yaml" : "package-lock.json";
        File packageLock = new File(options.getNpmFolder(), lockFile);
        if (packageLock.exists()) {
            return;
        }
        try {
            BundleUtils.copyAppropriatePackageLock(options, packageLock);
        }
        catch (IOException ioe) {
            BundleUtils.getLogger().error("Failed to copy existing `" + lockFile + "` to use", (Throwable)ioe);
        }
    }

    private static void copyAppropriatePackageLock(Options options, File packageLock) throws IOException {
        File devPackageLock;
        String packageLockFile;
        File devBundleFolder = new File(options.getNpmFolder(), "src/main/dev-bundle");
        String string = packageLockFile = options.isEnablePnpm() ? "pnpm-lock.yaml" : "package-lock.json";
        if (devBundleFolder.exists() && (devPackageLock = new File(devBundleFolder, packageLockFile)).exists()) {
            FileUtils.copyFile((File)devPackageLock, (File)packageLock);
            return;
        }
        URL resource = options.getClassFinder().getResource("vaadin-dev-bundle/" + packageLockFile);
        if (resource != null) {
            FileUtils.write((File)packageLock, (CharSequence)IOUtils.toString((URL)resource, (Charset)StandardCharsets.UTF_8), (Charset)StandardCharsets.UTF_8);
        }
    }
}

