/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.OptionalParameter;
import com.vaadin.flow.router.ParameterDeserializer;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.router.RouteData;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.RoutesChangedListener;
import com.vaadin.flow.router.WildcardParameter;
import com.vaadin.flow.router.internal.AbstractRouteRegistry;
import com.vaadin.flow.router.internal.RouteUtil;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.SessionRouteRegistry;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class RouteConfiguration
implements Serializable {
    private RouteRegistry handledRegistry;
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("/\\{[\\s\\S]*}");

    private RouteConfiguration(RouteRegistry registry) {
        this.handledRegistry = registry;
    }

    public static RouteConfiguration forSessionScope() {
        return new RouteConfiguration(RouteConfiguration.getSessionRegistry());
    }

    public static RouteConfiguration forApplicationScope() {
        return new RouteConfiguration(RouteConfiguration.getApplicationRegistry());
    }

    public static RouteConfiguration forRegistry(RouteRegistry registry) {
        return new RouteConfiguration(registry);
    }

    public List<RouteData> getAvailableRoutes() {
        return this.handledRegistry.getRegisteredRoutes();
    }

    public boolean isPathRegistered(String path) {
        if (this.handledRegistry instanceof AbstractRouteRegistry) {
            return ((AbstractRouteRegistry)this.handledRegistry).getConfiguration().hasRoute(path);
        }
        return this.getAvailableRoutes().stream().anyMatch(routeData -> routeData.getUrl().equals(path) || routeData.getRouteAliases().stream().anyMatch(routeAliasData -> routeAliasData.getUrl().equals(path)));
    }

    public boolean isRouteRegistered(Class<? extends Component> route) {
        return this.handledRegistry.getTargetUrl(route).isPresent();
    }

    public Optional<Class<? extends Component>> getRoute(String pathString) {
        return this.getRoute(pathString, Collections.emptyList());
    }

    public Optional<Class<? extends Component>> getRoute(String pathString, List<String> segments) {
        return this.handledRegistry.getNavigationTarget(pathString, segments);
    }

    public Registration addRoutesChangeListener(RoutesChangedListener listener) {
        return this.handledRegistry.addRoutesChangeListener(listener);
    }

    public void update(Command command) {
        this.handledRegistry.update(command);
    }

    public void setAnnotatedRoute(Class<? extends Component> navigationTarget) {
        if (!navigationTarget.isAnnotationPresent(Route.class)) {
            String message = String.format("Given navigationTarget %s is missing the '@Route' annotation.", navigationTarget.getName());
            throw new InvalidRouteConfigurationException(message);
        }
        String route = RouteUtil.getRoutePath(navigationTarget, navigationTarget.getAnnotation(Route.class));
        this.handledRegistry.setRoute(route, navigationTarget, RouteUtil.getParentLayouts(navigationTarget, route));
        for (RouteAlias alias : (RouteAlias[])navigationTarget.getAnnotationsByType(RouteAlias.class)) {
            String path = RouteUtil.getRouteAliasPath(navigationTarget, alias);
            this.handledRegistry.setRoute(path, navigationTarget, RouteUtil.getParentLayouts(navigationTarget, path));
        }
    }

    public void setParentAnnotatedRoute(String path, Class<? extends Component> navigationTarget) {
        this.handledRegistry.setRoute(path, navigationTarget, RouteUtil.getParentLayoutsForNonRouteTarget(navigationTarget));
    }

    public void setRoute(String path, Class<? extends Component> navigationTarget) {
        this.setRoute(path, navigationTarget, Collections.emptyList());
    }

    public void setRoute(String path, Class<? extends Component> navigationTarget, List<Class<? extends RouterLayout>> parentChain) {
        this.handledRegistry.setRoute(path, navigationTarget, parentChain);
    }

    public void setRoute(String path, Class<? extends Component> navigationTarget, Class<? extends RouterLayout> ... parentChain) {
        this.handledRegistry.setRoute(path, navigationTarget, Arrays.asList(parentChain));
    }

    public void removeRoute(Class<? extends Component> navigationTarget) {
        this.handledRegistry.removeRoute(navigationTarget);
    }

    public void removeRoute(String path) {
        this.handledRegistry.removeRoute(path);
    }

    public void removeRoute(String path, Class<? extends Component> navigationTarget) {
        this.handledRegistry.removeRoute(path, navigationTarget);
    }

    public RouteRegistry getHandledRegistry() {
        return this.handledRegistry;
    }

    public String getUrl(Class<? extends Component> navigationTarget) {
        if (HasUrlParameter.class.isAssignableFrom(navigationTarget) && !this.isAnnotatedParameter(navigationTarget, OptionalParameter.class, WildcardParameter.class)) {
            String message = String.format("Navigation target '%s' requires a parameter and can not be resolved. Use 'public <T, C extends Component & HasUrlParameter<T>> String getUrl(Class<? extends C> navigationTarget, T parameter)' instead", navigationTarget.getName());
            throw new IllegalArgumentException(message);
        }
        return this.getUrlBase(navigationTarget, this.getUrlForTarget(navigationTarget, this.handledRegistry));
    }

    public Optional<String> getUrlBase(Class<? extends Component> navigationTarget) {
        Optional<String> targetUrl = this.handledRegistry.getTargetUrl(navigationTarget);
        return targetUrl.map(url -> this.getUrlBase(navigationTarget, (String)url));
    }

    public <T, C extends Component> String getUrl(Class<? extends C> navigationTarget, T parameter) {
        if (parameter == null) {
            return this.getUrl(navigationTarget);
        }
        return this.getUrl(navigationTarget, Collections.singletonList(parameter));
    }

    public <T, C extends Component> String getUrl(Class<? extends C> navigationTarget, List<T> parameters) {
        List<String> serializedParameters = this.serializeUrlParameters(Objects.requireNonNull(parameters));
        String routeString = this.getUrlForTarget(navigationTarget, this.handledRegistry);
        if (!parameters.isEmpty()) {
            routeString = routeString.replace("{" + parameters.get(0).getClass().getSimpleName() + "}", serializedParameters.stream().collect(Collectors.joining("/")));
        } else if (ParameterDeserializer.isAnnotatedParameter(navigationTarget, OptionalParameter.class) || ParameterDeserializer.isAnnotatedParameter(navigationTarget, WildcardParameter.class)) {
            routeString = PARAMETER_PATTERN.matcher(routeString).replaceAll("");
        } else {
            throw new NotFoundException(String.format("The navigation target '%s' has a non optional parameter that needs to be given.", navigationTarget.getName()));
        }
        Optional<Class<? extends Component>> registryTarget = this.handledRegistry.getNavigationTarget(routeString, serializedParameters);
        if (registryTarget.isPresent() && !this.hasUrlParameters(registryTarget.get()) && !registryTarget.get().equals(navigationTarget)) {
            throw new NotFoundException(String.format("Url matches existing navigation target '%s' with higher priority.", registryTarget.get().getName()));
        }
        return this.trimRouteString(routeString);
    }

    private static RouteRegistry getApplicationRegistry() {
        return ApplicationRouteRegistry.getInstance(VaadinService.getCurrent().getContext());
    }

    private static RouteRegistry getSessionRegistry() {
        return SessionRouteRegistry.getSessionRegistry(VaadinSession.getCurrent());
    }

    private String getUrlForTarget(Class<? extends Component> navigationTarget, RouteRegistry registry) {
        Optional<String> targetUrl = registry.getTargetUrl(navigationTarget);
        if (!targetUrl.isPresent()) {
            throw new NotFoundException("No route found for given navigation target!");
        }
        return targetUrl.get();
    }

    private String trimRouteString(String routeString) {
        if (routeString.startsWith("/")) {
            routeString = routeString.substring(1);
        }
        return routeString;
    }

    @SafeVarargs
    private final boolean isAnnotatedParameter(Class<? extends Component> navigationTarget, Class<? extends Annotation> ... parameterAnnotations) {
        for (Class<? extends Annotation> annotation : parameterAnnotations) {
            if (!ParameterDeserializer.isAnnotatedParameter(navigationTarget, annotation)) continue;
            return true;
        }
        return false;
    }

    private boolean hasUrlParameters(Class<? extends Component> navigationTarget) {
        return HasUrlParameter.class.isAssignableFrom(navigationTarget);
    }

    private <T> List<String> serializeUrlParameters(List<T> urlParameters) {
        return urlParameters.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
    }

    private String getUrlBase(Class<? extends Component> navigationTarget, String targetUrl) {
        String routeString = targetUrl;
        if (this.isAnnotatedParameter(navigationTarget, OptionalParameter.class, WildcardParameter.class) || HasUrlParameter.class.isAssignableFrom(navigationTarget)) {
            routeString = PARAMETER_PATTERN.matcher(routeString).replaceAll("");
        }
        return this.trimRouteString(routeString);
    }
}

