/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.component.page.BodySize;
import com.vaadin.flow.component.page.Inline;
import com.vaadin.flow.component.page.Meta;
import com.vaadin.flow.component.page.Push;
import com.vaadin.flow.component.page.Viewport;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.server.AppShellRegistry;
import com.vaadin.flow.server.InvalidApplicationConfigurationException;
import com.vaadin.flow.server.PWA;
import com.vaadin.flow.server.PageConfigurator;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.startup.ClassLoaderAwareServletContainerInitializer;
import com.vaadin.flow.server.startup.ServletDeployer;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.HandlesTypes;
import javax.servlet.annotation.WebListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HandlesTypes(value={AppShellConfigurator.class, Meta.class, Meta.Container.class, PWA.class, Inline.class, Inline.Container.class, Viewport.class, BodySize.class, PageTitle.class, PageConfigurator.class, Push.class})
@WebListener
public class VaadinAppShellInitializer
implements ClassLoaderAwareServletContainerInitializer,
ServletContextListener,
Serializable {
    @Override
    public void process(Set<Class<?>> classes, ServletContext context) throws ServletException {
        Collection registrations = context.getServletRegistrations().values();
        if (registrations.isEmpty()) {
            return;
        }
        DeploymentConfiguration config = ServletDeployer.StubServletConfig.createDeploymentConfiguration(context, (ServletRegistration)registrations.iterator().next(), VaadinServlet.class);
        VaadinAppShellInitializer.init(classes, context, config);
    }

    public static void init(Set<Class<?>> classes, ServletContext context, DeploymentConfiguration config) {
        List classesImplementingPageConfigurator;
        if (config.useV14Bootstrap()) {
            return;
        }
        AppShellRegistry registry = AppShellRegistry.getInstance(new VaadinServletContext(context));
        registry.reset();
        if (classes == null || classes.isEmpty()) {
            return;
        }
        ArrayList offendingAnnotations = new ArrayList();
        classes.stream().sorted((a, b) -> registry.isShell((Class<?>)a) ? -1 : (registry.isShell((Class<?>)b) ? 1 : 0)).forEach(clz -> {
            if (registry.isShell((Class<?>)clz)) {
                registry.setShell((Class<? extends AppShellConfigurator>)clz);
                VaadinAppShellInitializer.getLogger().info("Using {} class for configuring `index.html` response", (Object)clz.getName());
            } else {
                String error = registry.validateClass((Class<?>)clz);
                if (error != null) {
                    offendingAnnotations.add(error);
                }
            }
        });
        if (!offendingAnnotations.isEmpty()) {
            if (registry.getShell() == null) {
                String message = String.format("%n%nFound app shell configuration annotations in non `AppShellConfigurator` classes.%nPlease create a custom class implementing `AppShellConfigurator` and move the following annotations to it:%n  %s%n", String.join((CharSequence)"\n  ", offendingAnnotations));
                VaadinAppShellInitializer.getLogger().error(message);
            } else {
                String message = String.format("%n%nFound app shell configuration annotations in non `AppShellConfigurator` classes.%nThe following annotations must be either removed or moved to the '%s' class:%n  %s%n", registry.getShell(), String.join((CharSequence)"\n  ", offendingAnnotations));
                throw new InvalidApplicationConfigurationException(message);
            }
        }
        if (!(classesImplementingPageConfigurator = classes.stream().filter(clz -> PageConfigurator.class.isAssignableFrom((Class<?>)clz)).map(Class::getName).collect(Collectors.toList())).isEmpty()) {
            String message = String.join((CharSequence)"\n - ", classesImplementingPageConfigurator);
            if (registry.getShell() != null) {
                message = String.format("%n%nThe `PageConfigurator` interface is deprecated since Vaadin 15 and has no effect.%nPlease, configure the page in %s, and remove the `PageConfigurator` from: %n - %s%n", registry.getShell().getName(), message);
                throw new InvalidApplicationConfigurationException(message);
            }
            message = String.format("%n%nThe `PageConfigurator` interface is deprecated since Vaadin 15 and has no effect.%nPlease, create a class implementing `AppShellConfigurator`, and remove `PageConfigurator` from: %n  - %s%n", message);
            VaadinAppShellInitializer.getLogger().error(message);
        }
    }

    public static List<Class<? extends Annotation>> getValidAnnotations() {
        return Arrays.stream(VaadinAppShellInitializer.getHandledTypes()).filter(Class::isAnnotation).map(clz -> clz).collect(Collectors.toList());
    }

    public static List<Class<?>> getValidSupers() {
        return Arrays.stream(VaadinAppShellInitializer.getHandledTypes()).filter(clz -> !clz.isAnnotation()).collect(Collectors.toList());
    }

    private static Class<?>[] getHandledTypes() {
        HandlesTypes annotation = VaadinAppShellInitializer.class.getAnnotation(HandlesTypes.class);
        assert (annotation != null);
        return annotation.value();
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(VaadinAppShellInitializer.class);
    }

    public void contextInitialized(ServletContextEvent sce) {
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

