/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import java.util.Scanner;

public final class StringUtil {
    public static final String removeComments(String code) {
        State state = State.NORMAL;
        StringBuilder result = new StringBuilder();
        Scanner scanner = new Scanner(code);
        scanner.useDelimiter("");
        while (scanner.hasNext()) {
            String character = scanner.next();
            switch (state) {
                case NORMAL: {
                    if (character.equals("/") && scanner.hasNext()) {
                        String nextCharacter = scanner.next();
                        if (nextCharacter.equals("/")) {
                            state = State.IN_LINE_COMMENT;
                            break;
                        }
                        if (nextCharacter.equals("*")) {
                            state = State.IN_BLOCK_COMMENT;
                            break;
                        }
                        result.append(character).append(nextCharacter);
                        break;
                    }
                    result.append(character);
                    if (!character.equals("\"")) break;
                    state = State.IN_STRING;
                    break;
                }
                case IN_STRING: {
                    result.append(character);
                    if (character.equals("\"")) {
                        state = State.NORMAL;
                        break;
                    }
                    if (!character.equals("\\") || !scanner.hasNext()) break;
                    result.append(scanner.next());
                    break;
                }
                case IN_LINE_COMMENT: {
                    if (!character.equals("\n")) break;
                    result.append(character);
                    state = State.NORMAL;
                    break;
                }
                case IN_BLOCK_COMMENT: {
                    if (!character.equals("*") || !scanner.hasNext() || !scanner.next().equals("/")) break;
                    state = State.NORMAL;
                }
            }
        }
        scanner.close();
        return result.toString();
    }

    private static enum State {
        NORMAL,
        IN_LINE_COMMENT,
        IN_BLOCK_COMMENT,
        IN_STRING;

    }
}

