/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.DevModeHandler;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.frontend.FallbackChunk;
import com.vaadin.flow.server.frontend.FrontendToolsLocator;
import com.vaadin.flow.server.frontend.FrontendVersion;
import com.vaadin.flow.server.frontend.WebpackConnectionException;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontendUtils {
    protected static final String DEFAULT_PNPM_VERSION = "4.5.0";
    private static final String PNMP_INSTALLED_BY_NPM_FOLDER = "node_modules/pnpm/";
    private static final String PNMP_INSTALLED_BY_NPM = "node_modules/pnpm/bin/pnpm.js";
    public static final String PROJECT_BASEDIR = "project.basedir";
    public static final String DEFAULT_NODE_DIR = "./";
    public static final String NODE_MODULES = "node_modules/";
    public static final String FRONTEND = "frontend/";
    public static final String DEFAULT_FRONTEND_DIR = "./frontend/";
    public static final String WEBPACK_CONFIG = "webpack.config.js";
    public static final String WEBPACK_GENERATED = "webpack.generated.js";
    public static final String TARGET = "target/";
    public static final String FLOW_NPM_PACKAGE_NAME = "@vaadin/flow-frontend/";
    public static final String DEAULT_FLOW_RESOURCES_FOLDER = "target/flow-frontend";
    public static final String DEFAULT_GENERATED_DIR = "target/frontend/";
    public static final String IMPORTS_NAME = "generated-flow-imports.js";
    public static final String IMPORTS_D_TS_NAME = "generated-flow-imports.d.ts";
    public static final String INDEX_HTML = "index.html";
    public static final String INDEX_TS = "index.ts";
    public static final String INDEX_JS = "index.js";
    public static final String DEFAULT_CONNECT_JAVA_SOURCE_FOLDER = "src/main/java";
    public static final String DEFAULT_CONNECT_APPLICATION_PROPERTIES = "src/main/resources/application.properties";
    public static final String DEFAULT_CONNECT_OPENAPI_JSON_FILE = "target/generated-resources/openapi.json";
    public static final String DEFAULT_CONNECT_GENERATED_TS_DIR = "./frontend/generated/";
    public static final String FALLBACK_IMPORTS_NAME = "generated-flow-imports-fallback.js";
    public static final String PARAM_GENERATED_DIR = "vaadin.frontend.generated.folder";
    public static final String PARAM_FRONTEND_DIR = "vaadin.frontend.frontend.folder";
    public static final String PARAM_IGNORE_VERSION_CHECKS = "vaadin.ignoreVersionChecks";
    public static final String WEBPACK_PREFIX_ALIAS = "Frontend/";
    public static final String TOKEN_FILE = "config/flow-build-info.json";
    public static final String EXPORT_CHUNK = "export";
    public static final String CHUNKS = "chunks";
    public static final String FALLBACK = "fallback";
    public static final String CSS_IMPORTS = "cssImports";
    public static final String JS_MODULES = "jsModules";
    public static final String PARAM_TOKEN_FILE = "vaadin.frontend.token.file";
    public static final String INSTALL_NODE_LOCALLY = "%n  $ mvn com.github.eirslett:frontend-maven-plugin:1.7.6:install-node-and-npm -DnodeVersion=\"v12.14.0\" ";
    public static final String DISABLE_CHECK = "%nYou can disable the version check using -D%s=true";
    private static final String NO_CONNECTION = "Webpack-dev-server couldn't be reached for %s.%nCheck the startup logs for exceptions in running webpack-dev-server.%nIf server should be running in production mode check that production mode flag is set correctly.";
    private static final String NODE_NOT_FOUND = "%n%n======================================================================================================%nVaadin requires node.js & npm to be installed. Please install the latest LTS version of node.js (with npm) either by:%n  1) following the https://nodejs.org/en/download/ guide to install it globally. This is the recommended way.%n  2) running the following Maven plugin goal to install it in this project:%n  $ mvn com.github.eirslett:frontend-maven-plugin:1.7.6:install-node-and-npm -DnodeVersion=\"v12.14.0\" %n%nNote that in case you don't install it globally, you'll need to install it again for another Vaadin project.%nIn case you have just installed node.js globally, it was not discovered, so you need to restart your system to get the path variables updated.%n======================================================================================================%n";
    private static final String SHOULD_WORK = "%n%n======================================================================================================%nYour installed '%s' version (%s) is not supported but should still work. Supported versions are %d.%d+%nYou can install a new one:%n  - by following the https://nodejs.org/en/download/ guide to install it globally%n  - or by running the frontend-maven-plugin goal to install it in this project:%n  $ mvn com.github.eirslett:frontend-maven-plugin:1.7.6:install-node-and-npm -DnodeVersion=\"v12.14.0\" %n%nYou can disable the version check using -D%s=true%n======================================================================================================%n";
    private static final String TOO_OLD = "%n%n======================================================================================================%nYour installed '%s' version (%s) is too old. Supported versions are %d.%d+%nPlease install a new one either:%n  - by following the https://nodejs.org/en/download/ guide to install it globally%n  - or by running the frontend-maven-plugin goal to install it in this project:%n  $ mvn com.github.eirslett:frontend-maven-plugin:1.7.6:install-node-and-npm -DnodeVersion=\"v12.14.0\" %n%nYou can disable the version check using -D%s=true%n======================================================================================================%n";
    private static final String BAD_VERSION = "%n%n======================================================================================================%nYour installed '%s' version (%s) is known to have problems.%nPlease update to a new one either:%n  - by following the https://nodejs.org/en/download/ guide to install it globally%s%n  - or by running the frontend-maven-plugin goal to install it in this project:%n  $ mvn com.github.eirslett:frontend-maven-plugin:1.7.6:install-node-and-npm -DnodeVersion=\"v12.14.0\" %n%nYou can disable the version check using -D%s=true%n======================================================================================================%n";
    private static final List<FrontendVersion> NPM_BLACKLISTED_VERSIONS = Arrays.asList(new FrontendVersion("6.11.0"), new FrontendVersion("6.11.1"), new FrontendVersion("6.11.2"));
    private static final FrontendVersion SUPPORTED_NODE_VERSION = new FrontendVersion(10, 0);
    private static final FrontendVersion SHOULD_WORK_NODE_VERSION = new FrontendVersion(8, 9);
    private static final FrontendVersion SUPPORTED_NPM_VERSION = new FrontendVersion(5, 6);
    private static final FrontendVersion SHOULD_WORK_NPM_VERSION = new FrontendVersion(5, 5);
    private static final FrontendVersion SUPPORTED_PNPM_VERSION = new FrontendVersion(4, 4);
    private static FrontendToolsLocator frontendToolsLocator = new FrontendToolsLocator();
    private static String operatingSystem = null;
    public static final String YELLOW = "\u001b[38;5;111m%s\u001b[0m";
    public static final String RED = "\u001b[38;5;196m%s\u001b[0m";
    public static final String GREEN = "\u001b[38;5;35m%s\u001b[0m";

    private FrontendUtils() {
    }

    public static String getOsName() {
        if (operatingSystem == null) {
            operatingSystem = System.getProperty("os.name");
        }
        return operatingSystem;
    }

    public static boolean isWindows() {
        return FrontendUtils.getOsName().startsWith("Windows");
    }

    public static String getNodeExecutable(String baseDir) {
        String command = FrontendUtils.isWindows() ? "node.exe" : "node";
        String defaultNode = FrontendUtils.isWindows() ? "node/node.exe" : "node/node";
        return FrontendUtils.getExecutable(baseDir, command, defaultNode).getAbsolutePath();
    }

    public static List<String> getNpmExecutable(String baseDir) {
        return FrontendUtils.getNpmExecutable(baseDir, true);
    }

    public static List<String> getPnpmExecutable(String baseDir) {
        FrontendUtils.ensurePnpm(baseDir);
        List<String> pnpmCommand = FrontendUtils.getPnpmExecutable(baseDir, true);
        if (!pnpmCommand.isEmpty()) {
            pnpmCommand.add("--shamefully-hoist=true");
        }
        return pnpmCommand;
    }

    public static List<String> getPnpmExecutable(String baseDir, boolean failOnAbsence) {
        ArrayList<String> returnCommand = new ArrayList<String>();
        Optional<File> localPnpmScript = FrontendUtils.getLocalPnpmScript(baseDir);
        if (localPnpmScript.isPresent()) {
            returnCommand.add(FrontendUtils.getNodeExecutable(baseDir));
            returnCommand.add(localPnpmScript.get().getAbsolutePath());
        } else {
            String command;
            String string = command = FrontendUtils.isWindows() ? "pnpm.cmd" : "pnpm";
            if (failOnAbsence) {
                returnCommand.add(FrontendUtils.getExecutable(baseDir, command, null).getAbsolutePath());
            } else {
                returnCommand.addAll(frontendToolsLocator.tryLocateTool(command).map(File::getPath).map(Collections::singletonList).orElse(Collections.emptyList()));
            }
        }
        return returnCommand;
    }

    public static List<String> getBowerExecutable(String baseDir) {
        File file = new File(baseDir, "node_modules/bower/bin/bower");
        if (file.canRead()) {
            return Arrays.asList(FrontendUtils.getNodeExecutable(baseDir), file.getAbsolutePath());
        }
        String command = FrontendUtils.isWindows() ? "bower.cmd" : "bower";
        return frontendToolsLocator.tryLocateTool(command).map(File::getPath).map(Collections::singletonList).orElse(Collections.emptyList());
    }

    private static File getExecutable(String baseDir, String cmd, String defaultLocation) {
        File file = null;
        try {
            file = defaultLocation == null ? (File)frontendToolsLocator.tryLocateTool(cmd).orElse(null) : Optional.of(new File(baseDir, defaultLocation)).filter(frontendToolsLocator::verifyTool).orElseGet(() -> frontendToolsLocator.tryLocateTool(cmd).orElse(null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (file == null) {
            throw new IllegalStateException(String.format(NODE_NOT_FOUND, new Object[0]));
        }
        return file;
    }

    public static String streamToString(InputStream inputStream) {
        String ret = "";
        try {
            return IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8).replaceAll("\\R", System.lineSeparator());
        }
        catch (IOException exception) {
            LoggerFactory.getLogger(FrontendUtils.class).warn("Couldn't close template input stream", (Throwable)exception);
            return ret;
        }
    }

    public static ProcessBuilder createProcessBuilder(List<String> command) {
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        File commandFile = new File(command.get(0));
        if (commandFile.isAbsolute()) {
            String pathEnvVar;
            String commandPath = commandFile.getParent();
            Map<String, String> environment = processBuilder.environment();
            String path = environment.get(pathEnvVar = FrontendUtils.isWindows() ? environment.keySet().stream().filter("PATH"::equalsIgnoreCase).findFirst().orElse("Path") : "PATH");
            if (path == null || path.isEmpty()) {
                path = commandPath;
            } else if (!path.contains(commandPath)) {
                path = path + File.pathSeparatorChar + commandPath;
            }
            environment.put(pathEnvVar, path);
        }
        return processBuilder;
    }

    public static String getStatsContent(VaadinService service) throws IOException {
        DeploymentConfiguration config = service.getDeploymentConfiguration();
        InputStream content = null;
        if (!config.isProductionMode() && config.enableDevServer()) {
            content = FrontendUtils.getStatsFromWebpack();
        }
        if (config.isStatsExternal()) {
            content = FrontendUtils.getStatsFromExternalUrl(config.getExternalStatsUrl(), service.getContext());
        }
        if (content == null) {
            content = FrontendUtils.getStatsFromClassPath(service);
        }
        return content != null ? IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8) : null;
    }

    public static String getIndexHtmlContent(VaadinService service) throws IOException {
        String indexHtmlPathInDevMode = "/VAADIN/index.html";
        String indexHtmlPathInProductionMode = "META-INF/VAADIN/index.html";
        return FrontendUtils.getFileContent(service, indexHtmlPathInDevMode, indexHtmlPathInProductionMode);
    }

    private static String getFileContent(VaadinService service, String pathInDevMode, String pathInProductionMode) throws IOException {
        DeploymentConfiguration config = service.getDeploymentConfiguration();
        InputStream content = null;
        if (!config.isProductionMode() && config.enableDevServer()) {
            content = FrontendUtils.getFileFromWebpack(pathInDevMode);
        }
        if (content == null) {
            content = FrontendUtils.getFileFromClassPath(service, pathInProductionMode);
        }
        return content != null ? FrontendUtils.streamToString(content) : null;
    }

    private static InputStream getFileFromClassPath(VaadinService service, String filePath) {
        InputStream stream = service.getClassLoader().getResourceAsStream(filePath);
        if (stream == null) {
            FrontendUtils.getLogger().error("Cannot get the '{}' from the classpath", (Object)filePath);
        }
        return stream;
    }

    public static String getStatsHash(VaadinService service) throws IOException {
        DeploymentConfiguration config = service.getDeploymentConfiguration();
        if (!config.isProductionMode() && config.enableDevServer()) {
            DevModeHandler handler = DevModeHandler.getDevModeHandler();
            HttpURLConnection statsConnection = handler.prepareConnection("/stats.hash", "GET");
            if (statsConnection.getResponseCode() != 200) {
                throw new WebpackConnectionException(String.format(NO_CONNECTION, "getting the stats content hash."));
            }
            return FrontendUtils.streamToString(statsConnection.getInputStream()).replaceAll("\"", "");
        }
        return "";
    }

    private static InputStream getStatsFromWebpack() throws IOException {
        DevModeHandler handler = DevModeHandler.getDevModeHandler();
        HttpURLConnection statsConnection = handler.prepareConnection("/stats.json", "GET");
        if (statsConnection.getResponseCode() != 200) {
            throw new WebpackConnectionException(String.format(NO_CONNECTION, "downloading stats.json"));
        }
        return statsConnection.getInputStream();
    }

    private static InputStream getStatsFromExternalUrl(String externalStatsUrl, VaadinContext context) {
        String url;
        if (externalStatsUrl.startsWith("/")) {
            VaadinRequest request = VaadinRequest.getCurrent();
            url = FrontendUtils.getHostString(request) + externalStatsUrl;
        } else {
            url = externalStatsUrl;
        }
        try {
            URL uri = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)uri.openConnection();
            connection.setRequestMethod("GET");
            connection.setReadTimeout(60000);
            connection.setConnectTimeout(60000);
            String lastModified = connection.getHeaderField("last-modified");
            if (lastModified != null) {
                LocalDateTime modified = ZonedDateTime.parse(lastModified, DateTimeFormatter.RFC_1123_DATE_TIME).toLocalDateTime();
                Stats statistics = context.getAttribute(Stats.class);
                if (statistics == null || modified.isAfter(statistics.getLastModified())) {
                    statistics = new Stats(FrontendUtils.streamToString(connection.getInputStream()), lastModified);
                    context.setAttribute(statistics);
                }
                return new ByteArrayInputStream(statistics.statsJson.getBytes(StandardCharsets.UTF_8));
            }
            return connection.getInputStream();
        }
        catch (IOException e) {
            FrontendUtils.getLogger().error("Failed to retrieve stats.json from the url {}.", (Object)url, (Object)e);
            return null;
        }
    }

    private static String getHostString(VaadinRequest request) {
        String host = request.getHeader("host");
        if (host == null) {
            host = "http://127.0.0.1:8080";
        } else if (!host.contains("://")) {
            String scheme = request.getHeader("scheme");
            if (scheme == null) {
                scheme = "http";
            }
            host = scheme + "://" + host;
        }
        return host;
    }

    private static InputStream getStatsFromClassPath(VaadinService service) {
        String stats = service.getDeploymentConfiguration().getStringProperty("statistics.file.path", "META-INF/VAADIN/config/stats.json").replaceFirst("^/", "");
        InputStream stream = service.getClassLoader().getResourceAsStream(stats);
        if (stream == null) {
            FrontendUtils.getLogger().error("Cannot get the 'stats.json' from the classpath '{}'", (Object)stats);
        }
        return stream;
    }

    private static InputStream getFileFromWebpack(String filePath) throws IOException {
        DevModeHandler handler = DevModeHandler.getDevModeHandler();
        return handler.prepareConnection(filePath, "GET").getInputStream();
    }

    public static String getStatsAssetsByChunkName(VaadinService service) throws IOException {
        DeploymentConfiguration config = service.getDeploymentConfiguration();
        if (!config.isProductionMode() && config.enableDevServer()) {
            DevModeHandler handler = DevModeHandler.getDevModeHandler();
            HttpURLConnection assetsConnection = handler.prepareConnection("/assetsByChunkName", "GET");
            if (assetsConnection.getResponseCode() != 200) {
                throw new WebpackConnectionException(String.format(NO_CONNECTION, "getting assets by chunk name."));
            }
            return FrontendUtils.streamToString(assetsConnection.getInputStream());
        }
        InputStream resourceAsStream = config.isStatsExternal() ? FrontendUtils.getStatsFromExternalUrl(config.getExternalStatsUrl(), service.getContext()) : FrontendUtils.getStatsFromClassPath(service);
        if (resourceAsStream == null) {
            return null;
        }
        try (Scanner scan = new Scanner(resourceAsStream, StandardCharsets.UTF_8.name());){
            StringBuilder assets = new StringBuilder();
            assets.append("{");
            FrontendUtils.scanToAssetChunkStart(scan, assets);
            while (scan.hasNextLine()) {
                String line = scan.nextLine().trim();
                if ("}".equals(line) || "},".equals(line)) {
                    String string = assets.append("}").toString();
                    return string;
                }
                if (line.endsWith("}") || line.endsWith("},")) {
                    String string = assets.append(line.substring(0, line.indexOf(125)).trim()).append("}").toString();
                    return string;
                }
                if (line.contains("{")) break;
                assets.append(line);
            }
            FrontendUtils.getLogger().error("Could not parse assetsByChunkName from stats.json");
        }
        return null;
    }

    private static void scanToAssetChunkStart(Scanner scan, StringBuilder assets) {
        do {
            String line;
            if (!(line = scan.nextLine().trim()).startsWith("\"assetsByChunkName\"")) continue;
            if (line.endsWith("{")) break;
            assets.append(line.substring(line.indexOf(123) + 1).trim());
            break;
        } while (scan.hasNextLine());
    }

    public static void validateNodeAndNpmVersion(String baseDir) {
        try {
            ArrayList<String> nodeVersionCommand = new ArrayList<String>();
            nodeVersionCommand.add(FrontendUtils.getNodeExecutable(baseDir));
            nodeVersionCommand.add("--version");
            FrontendVersion nodeVersion = FrontendUtils.getVersion("node", nodeVersionCommand);
            FrontendUtils.validateToolVersion("node", nodeVersion, SUPPORTED_NODE_VERSION, SHOULD_WORK_NODE_VERSION);
        }
        catch (UnknownVersionException e) {
            FrontendUtils.getLogger().warn("Error checking if node is new enough", (Throwable)e);
        }
        try {
            ArrayList<String> npmVersionCommand = new ArrayList<String>(FrontendUtils.getNpmExecutable(baseDir, false));
            npmVersionCommand.add("--version");
            FrontendVersion npmVersion = FrontendUtils.getVersion("npm", npmVersionCommand);
            FrontendUtils.validateToolVersion("npm", npmVersion, SUPPORTED_NPM_VERSION, SHOULD_WORK_NPM_VERSION);
            FrontendUtils.checkForFaultyNpmVersion(npmVersion);
        }
        catch (UnknownVersionException e) {
            FrontendUtils.getLogger().warn("Error checking if npm is new enough", (Throwable)e);
        }
    }

    public static void ensurePnpm(String baseDir) {
        if (FrontendUtils.isPnpmTooOldOrAbsent(baseDir)) {
            File packageJson = new File(baseDir, "package.json");
            File tempFile = null;
            boolean packageJsonExists = packageJson.canRead();
            if (packageJsonExists) {
                try {
                    tempFile = File.createTempFile("package", "json");
                    FileUtils.copyFile((File)packageJson, (File)tempFile);
                }
                catch (IOException exception) {
                    throw new IllegalStateException("Couldn't make a copy of package.json file", exception);
                }
                packageJson.delete();
            }
            try {
                JsonObject pkgJson = Json.createObject();
                pkgJson.put("name", "temp");
                pkgJson.put("license", "UNLICENSED");
                pkgJson.put("repository", "npm/npm");
                pkgJson.put("description", "Temporary package for pnpm installation");
                FileUtils.writeLines((File)packageJson, Collections.singletonList(pkgJson.toJson()));
                JsonObject lockJson = Json.createObject();
                lockJson.put("lockfileVersion", 1.0);
                FileUtils.writeLines((File)new File(baseDir, "package-lock.json"), Collections.singletonList(lockJson.toJson()));
            }
            catch (IOException e) {
                FrontendUtils.getLogger().warn("Couldn't create temporary package.json");
            }
            LoggerFactory.getLogger((String)"dev-updater").info("Installing pnpm v{} locally. It is suggested to install it globally using 'npm add -g pnpm@{}'", (Object)DEFAULT_PNPM_VERSION, (Object)DEFAULT_PNPM_VERSION);
            FrontendUtils.installPnpm(baseDir, FrontendUtils.getNpmExecutable(baseDir, false));
            new File(baseDir, "package-lock.json").delete();
            if (packageJsonExists && tempFile != null) {
                try {
                    FileUtils.copyFile((File)tempFile, (File)packageJson);
                }
                catch (IOException exception) {
                    throw new IllegalStateException("Couldn't restore package.json file back", exception);
                }
                tempFile.delete();
            }
        }
    }

    private static boolean isPnpmTooOldOrAbsent(String baseDir) {
        List<String> pnpmCommand = FrontendUtils.getPnpmExecutable(baseDir, false);
        if (!pnpmCommand.isEmpty()) {
            try {
                ArrayList<String> versionCmd = new ArrayList<String>(pnpmCommand);
                versionCmd.add("--version");
                FrontendVersion pnpmVersion = FrontendUtils.getVersion("pnpm", versionCmd);
                if (FrontendUtils.isVersionAtLeast(pnpmVersion, SUPPORTED_PNPM_VERSION)) {
                    return false;
                }
                FrontendUtils.getLogger().warn(String.format("installed pnpm ('%s', version %s) is too old, installing supported version locally", String.join((CharSequence)" ", pnpmCommand), pnpmVersion.getFullVersion()));
            }
            catch (UnknownVersionException e) {
                FrontendUtils.getLogger().warn("Error checking pnpm version, installing pnpm locally", (Throwable)e);
            }
        }
        return true;
    }

    static void checkForFaultyNpmVersion(FrontendVersion npmVersion) {
        if (NPM_BLACKLISTED_VERSIONS.contains(npmVersion)) {
            String badNpmVersion = FrontendUtils.buildBadVersionString("npm", npmVersion.getFullVersion(), "by updating your global npm installation with `npm install -g npm@latest`");
            throw new IllegalStateException(badNpmVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installPnpm(String baseDir, List<String> installCommand) {
        ArrayList<String> command = new ArrayList<String>();
        command.addAll(installCommand);
        command.add("install");
        command.add("pnpm@4.5.0");
        FrontendUtils.console(YELLOW, FrontendUtils.commandToString(baseDir, command));
        ProcessBuilder builder = FrontendUtils.createProcessBuilder(command);
        builder.environment().put("ADBLOCK", "1");
        builder.directory(new File(baseDir));
        builder.redirectInput(ProcessBuilder.Redirect.INHERIT);
        builder.redirectError(ProcessBuilder.Redirect.INHERIT);
        Process process = null;
        try {
            process = builder.start();
            FrontendUtils.getLogger().debug("Output of `{}`:", (Object)command.stream().collect(Collectors.joining(" ")));
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                String stdoutLine;
                while ((stdoutLine = reader.readLine()) != null) {
                    FrontendUtils.getLogger().debug(stdoutLine);
                }
            }
            int errorCode = process.waitFor();
            if (errorCode != 0) {
                FrontendUtils.getLogger().error("Couldn't install 'pnpm'");
            } else {
                FrontendUtils.getLogger().debug("Pnpm is successfully installed");
            }
        }
        catch (IOException | InterruptedException e) {
            FrontendUtils.getLogger().error("Error when running `npm install`", (Throwable)e);
        }
        finally {
            if (process != null) {
                process.destroyForcibly();
            }
        }
    }

    private static String buildTooOldString(String tool, String version, int supportedMajor, int supportedMinor) {
        return String.format(TOO_OLD, tool, version, supportedMajor, supportedMinor, PARAM_IGNORE_VERSION_CHECKS);
    }

    private static String buildShouldWorkString(String tool, String version, int supportedMajor, int supportedMinor) {
        return String.format(SHOULD_WORK, tool, version, supportedMajor, supportedMinor, PARAM_IGNORE_VERSION_CHECKS);
    }

    private static String buildBadVersionString(String tool, String version, String ... extraUpdateInstructions) {
        StringBuilder extraInstructions = new StringBuilder();
        for (String instruction : extraUpdateInstructions) {
            extraInstructions.append("%n  - or ").append(instruction);
        }
        return String.format(BAD_VERSION, tool, version, extraInstructions.toString(), PARAM_IGNORE_VERSION_CHECKS);
    }

    public static String getProjectFrontendDir(DeploymentConfiguration configuration) {
        return configuration.getStringProperty(PARAM_FRONTEND_DIR, DEFAULT_FRONTEND_DIR);
    }

    public static boolean isWebpackConfigFile(File file) throws IOException {
        return file.exists() && FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8).contains("./webpack.generated.js");
    }

    public static String getUnixRelativePath(Path source, Path target) {
        return FrontendUtils.getUnixPath(source.relativize(target));
    }

    public static String getUnixPath(Path source) {
        return source.toString().replaceAll("\\\\", "/");
    }

    public static FallbackChunk readFallbackChunk(JsonObject object) {
        if (!object.hasKey(CHUNKS)) {
            return null;
        }
        JsonObject obj = object.getObject(CHUNKS);
        if (!obj.hasKey(FALLBACK)) {
            return null;
        }
        obj = obj.getObject(FALLBACK);
        ArrayList<String> fallbackModles = new ArrayList<String>();
        JsonArray modules = obj.getArray(JS_MODULES);
        for (int i = 0; i < modules.length(); ++i) {
            fallbackModles.add(modules.getString(i));
        }
        ArrayList<FallbackChunk.CssImportData> fallbackCss = new ArrayList<FallbackChunk.CssImportData>();
        JsonArray css = obj.getArray(CSS_IMPORTS);
        for (int i = 0; i < css.length(); ++i) {
            fallbackCss.add(FrontendUtils.createCssData(css.getObject(i)));
        }
        return new FallbackChunk(fallbackModles, fallbackCss);
    }

    private static FallbackChunk.CssImportData createCssData(JsonObject object) {
        String value = null;
        String id = null;
        String include = null;
        String themeFor = null;
        if (object.hasKey("value")) {
            value = object.getString("value");
        }
        if (object.hasKey("id")) {
            id = object.getString("id");
        }
        if (object.hasKey("include")) {
            include = object.getString("include");
        }
        if (object.hasKey("themeFor")) {
            themeFor = object.getString("themeFor");
        }
        return new FallbackChunk.CssImportData(value, id, include, themeFor);
    }

    static void validateToolVersion(String tool, FrontendVersion toolVersion, FrontendVersion supported, FrontendVersion shouldWork) {
        if ("true".equalsIgnoreCase(System.getProperty(PARAM_IGNORE_VERSION_CHECKS))) {
            return;
        }
        if (FrontendUtils.isVersionAtLeast(toolVersion, supported)) {
            return;
        }
        if (FrontendUtils.isVersionAtLeast(toolVersion, shouldWork)) {
            FrontendUtils.getLogger().warn(FrontendUtils.buildShouldWorkString(tool, toolVersion.getFullVersion(), supported.getMajorVersion(), supported.getMinorVersion()));
            return;
        }
        throw new IllegalStateException(FrontendUtils.buildTooOldString(tool, toolVersion.getFullVersion(), supported.getMajorVersion(), supported.getMinorVersion()));
    }

    static boolean isVersionAtLeast(FrontendVersion toolVersion, FrontendVersion required) {
        int major = toolVersion.getMajorVersion();
        int minor = toolVersion.getMinorVersion();
        return major > required.getMajorVersion() || major == required.getMajorVersion() && minor >= required.getMinorVersion();
    }

    private static FrontendVersion getVersion(String tool, List<String> versionCommand) throws UnknownVersionException {
        try {
            Process process = FrontendUtils.createProcessBuilder(versionCommand).start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new UnknownVersionException(tool, "Using command " + String.join((CharSequence)" ", versionCommand));
            }
            String output = FrontendUtils.streamToString(process.getInputStream());
            return new FrontendVersion(FrontendUtils.parseVersionString(output));
        }
        catch (IOException | InterruptedException e) {
            throw new UnknownVersionException(tool, "Using command " + String.join((CharSequence)" ", versionCommand), e);
        }
    }

    static String parseVersionString(String output) throws IOException {
        Optional<String> lastOuput = Stream.of(output.split("\n")).filter(line -> !line.matches("^[ ]*$")).reduce((first, second) -> second);
        return lastOuput.map(line -> line.replaceFirst("^v", "")).orElseThrow(() -> new IOException("No output"));
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(FrontendUtils.class);
    }

    private static Optional<File> getLocalPnpmScript(String baseDir) {
        File npmInstalled = new File(baseDir, PNMP_INSTALLED_BY_NPM);
        if (npmInstalled.canRead()) {
            return Optional.of(npmInstalled);
        }
        File movedPnpmScript = new File(baseDir, "node_modules/.ignored_pnpm/bin/pnpm.js");
        if (movedPnpmScript.canRead()) {
            return Optional.of(movedPnpmScript);
        }
        movedPnpmScript = new File(baseDir, "node_modules/.ignored/pnpm/bin/pnpm.js");
        if (movedPnpmScript.canRead()) {
            return Optional.of(movedPnpmScript);
        }
        return Optional.empty();
    }

    private static List<String> getNpmExecutable(String baseDir, boolean removePnpmLock) {
        File file = new File(baseDir, "node/node_modules/npm/bin/npm-cli.js");
        ArrayList<String> returnCommand = new ArrayList<String>();
        if (file.canRead()) {
            returnCommand.add(FrontendUtils.getNodeExecutable(baseDir));
            returnCommand.add(file.getAbsolutePath());
        } else {
            String command = FrontendUtils.isWindows() ? "npm.cmd" : "npm";
            returnCommand.add(FrontendUtils.getExecutable(baseDir, command, null).getAbsolutePath());
        }
        returnCommand.add("--no-update-notifier");
        returnCommand.add("--no-audit");
        if (removePnpmLock) {
            new File(baseDir, "pnpm-lock.yaml").delete();
        }
        return returnCommand;
    }

    static File getVaadinHomeDirectory() {
        File home = FileUtils.getUserDirectory();
        if (!home.exists()) {
            throw new IllegalStateException("The user directory '" + home.getAbsolutePath() + "' doesn't exist");
        }
        if (!home.isDirectory()) {
            throw new IllegalStateException("The path '" + home.getAbsolutePath() + "' is not a directory");
        }
        File vaadinFolder = new File(home, ".vaadin");
        if (vaadinFolder.exists()) {
            if (vaadinFolder.isDirectory()) {
                return vaadinFolder;
            }
            throw new IllegalStateException("The path '" + vaadinFolder.getAbsolutePath() + "' is not a directory. This path is used to store vaadin related data. Please either remove the file or create a directory");
        }
        try {
            FileUtils.forceMkdir((File)vaadinFolder);
            return vaadinFolder;
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Couldn't create '.vaadin' folder inside home directory '" + home.getAbsolutePath() + "'", exception);
        }
    }

    public static String commandToString(String baseDir, List<String> command) {
        return "\n" + WordUtils.wrap((String)String.join((CharSequence)" ", command).replace(baseDir, "."), (int)50).replace("\r", "").replace("\n", " \\ \n    ") + "\n";
    }

    public static void console(String format, Object message) {
        System.out.print(String.format(format, message));
    }

    private static class Stats
    implements Serializable {
        private final String lastModified;
        protected final String statsJson;

        public Stats(String statsJson, String lastModified) {
            this.statsJson = statsJson;
            this.lastModified = lastModified;
        }

        public LocalDateTime getLastModified() {
            return ZonedDateTime.parse(this.lastModified, DateTimeFormatter.RFC_1123_DATE_TIME).toLocalDateTime();
        }
    }

    public static class UnknownVersionException
    extends Exception {
        public UnknownVersionException(String tool, String extraInfo) {
            super("Unable to detect version of " + tool + ". " + extraInfo);
        }

        public UnknownVersionException(String tool, String extraInfo, Exception cause) {
            super("Unable to detect version of " + tool + ". " + extraInfo, cause);
        }
    }
}

