/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.connect.generator.OpenApiSpecGenerator;
import com.vaadin.flow.server.frontend.AbstractTaskConnectGenerator;
import java.io.File;
import java.util.Collections;
import java.util.Objects;

public class TaskGenerateOpenApi
extends AbstractTaskConnectGenerator {
    private final File javaSourceFolder;
    private final transient ClassLoader classLoader;
    private final File output;

    TaskGenerateOpenApi(File properties, File javaSourceFolder, ClassLoader classLoader, File output) {
        super(properties);
        Objects.requireNonNull(javaSourceFolder, "Source paths should not be null.");
        Objects.requireNonNull(output, "OpenAPI output file should not be null.");
        Objects.requireNonNull(classLoader, "ClassLoader should not be null.");
        this.javaSourceFolder = javaSourceFolder;
        this.classLoader = classLoader;
        this.output = output;
    }

    @Override
    public void execute() throws ExecutionFailedException {
        OpenApiSpecGenerator openApiSpecGenerator = new OpenApiSpecGenerator(this.readApplicationProperties());
        openApiSpecGenerator.generateOpenApiSpec(Collections.singletonList(this.javaSourceFolder.toPath()), this.classLoader, this.output.toPath());
    }
}

