/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.internal;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.UIInternalUpdater;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.router.ErrorNavigationEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationEvent;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.NavigationStateBuilder;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.RouteNotFoundError;
import com.vaadin.flow.router.internal.ErrorStateRenderer;
import com.vaadin.flow.router.internal.ErrorTargetEntry;
import com.vaadin.flow.router.internal.NavigationStateRenderer;
import com.vaadin.flow.server.AppShellRegistry;
import com.vaadin.flow.server.VaadinService;
import java.io.Serializable;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JavaScriptBootstrapUI
extends UI {
    public static final String SERVER_ROUTING = "clientRoutingMode";
    static final String CLIENT_PUSHSTATE_TO = "setTimeout(() => window.history.pushState(null, '', $0))";
    static final String CLIENT_NAVIGATE_TO = "window.dispatchEvent(new CustomEvent('vaadin-router-go', {detail: new URL($0, document.baseURI)}))";
    Element wrapperElement;
    private NavigationState clientViewNavigationState;
    private boolean navigationInProgress = false;

    public JavaScriptBootstrapUI() {
        super(new JavaScriptUIInternalUpdater());
    }

    @Override
    public Stream<Component> getChildren() {
        if (this.wrapperElement == null) {
            return super.getChildren();
        }
        Stream.Builder childComponents = Stream.builder();
        this.wrapperElement.getChildren().forEach(childElement -> ComponentUtil.findComponents(childElement, childComponents::add));
        return childComponents.build();
    }

    @ClientCallable
    public void connectClient(String clientElementTag, String clientElementId, String flowRoute) {
        if (this.wrapperElement == null) {
            this.wrapperElement = new Element(clientElementTag);
            this.getElement().getStateProvider().appendVirtualChild(this.getElement().getNode(), this.wrapperElement, "@id", clientElementId);
        }
        boolean postponed = this.renderViewForRoute(new Location(this.removeFirstSlash(flowRoute)));
        this.wrapperElement.executeJs("this.serverConnected($0)", Boolean.valueOf(postponed));
        this.getSession().setAttribute(SERVER_ROUTING, Boolean.FALSE);
    }

    @ClientCallable
    public void leaveNavigation(String route) {
        boolean postponed = this.navigateToPlaceholder(new Location(this.removeFirstSlash(route)));
        this.wrapperElement.executeJs("this.serverConnected($0)", Boolean.valueOf(postponed));
    }

    private boolean navigateToPlaceholder(Location location) {
        if (this.clientViewNavigationState == null) {
            this.clientViewNavigationState = new NavigationStateBuilder(this.getRouter()).withTarget(ClientViewPlaceholder.class).build();
        }
        return this.handleNavigation(location, this.clientViewNavigationState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean renderViewForRoute(Location location) {
        if (!this.shouldHandleNavigation(location)) {
            return false;
        }
        try {
            this.getInternals().setLastHandledNavigation(location);
            Optional<NavigationState> navigationState = this.getRouter().resolveNavigationTarget(location);
            if (navigationState.isPresent()) {
                boolean bl = this.handleNavigation(location, navigationState.get());
                return bl;
            }
            if (this.navigateToPlaceholder(location)) {
                boolean bl = true;
                return bl;
            }
            this.handleErrorNavigation(location);
        }
        catch (Exception exception) {
            boolean bl = this.handleExceptionNavigation(location, exception);
            return bl;
        }
        finally {
            this.getInternals().clearLastHandledNavigation();
        }
        return false;
    }

    private boolean shouldHandleNavigation(Location location) {
        return !this.getInternals().hasLastHandledLocation() || !this.sameLocation(this.getInternals().getLastHandledLocation(), location);
    }

    private boolean sameLocation(Location oldLocation, Location newLocation) {
        return this.removeLastSlash(newLocation.getPathWithQueryParameters()).equals(this.removeLastSlash(oldLocation.getPathWithQueryParameters()));
    }

    private String removeFirstSlash(String route) {
        return route.replaceFirst("^/+", "");
    }

    private String removeLastSlash(String route) {
        return route.replaceFirst("/+$", "");
    }

    private boolean handleNavigation(Location location, NavigationState navigationState) {
        NavigationEvent navigationEvent = new NavigationEvent(this.getRouter(), location, this, NavigationTrigger.CLIENT_SIDE);
        NavigationStateRenderer clientNavigationStateRenderer = new NavigationStateRenderer(navigationState);
        clientNavigationStateRenderer.handle(navigationEvent);
        this.adjustPageTitle();
        return this.getInternals().getContinueNavigationAction() != null;
    }

    private boolean handleExceptionNavigation(Location location, Exception exception) {
        Optional<ErrorTargetEntry> maybeLookupResult = this.getRouter().getErrorNavigationTarget(exception);
        if (!maybeLookupResult.isPresent()) {
            throw new RuntimeException(exception);
        }
        ErrorTargetEntry lookupResult = maybeLookupResult.get();
        ErrorParameter<? extends Exception> errorParameter = new ErrorParameter<Exception>(lookupResult.getHandledExceptionType(), exception, exception.getMessage());
        ErrorStateRenderer errorStateRenderer = new ErrorStateRenderer(new NavigationStateBuilder(this.getRouter()).withTarget(lookupResult.getNavigationTarget()).build());
        ErrorNavigationEvent errorNavigationEvent = new ErrorNavigationEvent(this.getRouter(), location, this, NavigationTrigger.CLIENT_SIDE, errorParameter);
        errorStateRenderer.handle(errorNavigationEvent);
        return this.getInternals().getContinueNavigationAction() != null;
    }

    private void adjustPageTitle() {
        String newTitle = this.getInternals().getTitle();
        String appTitle = AppShellRegistry.getInstance(VaadinService.getCurrent().getContext()).getTitle();
        if ((newTitle == null || newTitle.isEmpty()) && !appTitle.isEmpty()) {
            this.getInternals().cancelPendingTitleUpdate();
            this.getInternals().setTitle(appTitle);
        }
    }

    private void handleErrorNavigation(Location location) {
        NavigationState errorNavigationState = this.getRouter().resolveRouteNotFoundNavigationTarget().orElse(this.getDefaultNavigationError());
        ErrorStateRenderer errorStateRenderer = new ErrorStateRenderer(errorNavigationState);
        NotFoundException notFoundException = new NotFoundException("Couldn't find route for '" + location.getPath() + "'");
        ErrorParameter<NotFoundException> errorParameter = new ErrorParameter<NotFoundException>(NotFoundException.class, notFoundException);
        ErrorNavigationEvent errorNavigationEvent = new ErrorNavigationEvent(this.getRouter(), location, this, NavigationTrigger.CLIENT_SIDE, errorParameter);
        errorStateRenderer.handle(errorNavigationEvent);
    }

    private NavigationState getDefaultNavigationError() {
        return new NavigationStateBuilder(this.getRouter()).withTarget(RouteNotFoundError.class).build();
    }

    @Override
    public void navigate(String pathname, QueryParameters queryParameters) {
        Location location = new Location(pathname, queryParameters);
        if (Boolean.TRUE.equals(this.getSession().getAttribute(SERVER_ROUTING))) {
            this.renderViewForRoute(location);
        } else {
            String execJs;
            if (this.navigationInProgress || this.getInternals().hasLastHandledLocation() && this.sameLocation(this.getInternals().getLastHandledLocation(), location)) {
                return;
            }
            this.navigationInProgress = true;
            NavigationState navigationState = this.getRouter().resolveNavigationTarget(location).orElse(null);
            if (navigationState != null) {
                this.handleNavigation(location, navigationState);
                execJs = CLIENT_PUSHSTATE_TO;
            } else {
                execJs = CLIENT_NAVIGATE_TO;
            }
            this.navigationInProgress = false;
            this.getPage().executeJs(execJs, new Serializable[]{location.getPathWithQueryParameters()});
        }
    }

    @Tag(value="div")
    public static class ClientViewPlaceholder
    extends Component {
    }

    private static class JavaScriptUIInternalUpdater
    implements UIInternalUpdater {
        private JavaScriptUIInternalUpdater() {
        }

        @Override
        public void updateRoot(UI ui, HasElement oldRoot, HasElement newRoot) {
            JavaScriptBootstrapUI jsUI = this.castToJavaScriptUI(ui);
            Element wrapperElement = jsUI.wrapperElement;
            if (wrapperElement == null) {
                UIInternalUpdater.super.updateRoot(ui, oldRoot, newRoot);
                return;
            }
            Element rootElement = newRoot.getElement();
            if (newRoot instanceof ClientViewPlaceholder) {
                wrapperElement.removeAllChildren();
            } else if (!wrapperElement.equals(rootElement.getParent())) {
                if (oldRoot != null) {
                    oldRoot.getElement().removeFromParent();
                }
                rootElement.removeFromParent();
                wrapperElement.appendChild(rootElement);
            }
        }

        @Override
        public void moveToNewUI(UI oldUI, UI newUI) {
            JavaScriptBootstrapUI newJsUI = this.castToJavaScriptUI(newUI);
            JavaScriptBootstrapUI oldJsUI = this.castToJavaScriptUI(oldUI);
            Element oldRoot = oldJsUI.wrapperElement == null ? oldJsUI.getElement() : oldJsUI.wrapperElement;
            Element newRoot = newJsUI.wrapperElement == null ? newJsUI.getElement() : newJsUI.wrapperElement;
            oldRoot.getChildren().collect(Collectors.toList()).forEach(element -> {
                element.removeFromTree();
                newRoot.appendChild((Element)element);
            });
        }

        private JavaScriptBootstrapUI castToJavaScriptUI(UI ui) {
            assert (ui instanceof JavaScriptBootstrapUI);
            return (JavaScriptBootstrapUI)ui;
        }
    }
}

