/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.function;

import com.vaadin.flow.shared.communication.PushMode;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface DeploymentConfiguration
extends Serializable {
    public boolean isProductionMode();

    default public boolean useV14Bootstrap() {
        return this.getBooleanProperty("useDeprecatedV14Bootstrapping", false);
    }

    public boolean isRequestTiming();

    public boolean isXsrfProtectionEnabled();

    public boolean isSyncIdCheckEnabled();

    public int getHeartbeatInterval();

    public int getMaxMessageSuspendTimeout();

    public int getWebComponentDisconnect();

    public boolean isSendUrlsAsParameters();

    public boolean isCloseIdleSessions();

    public PushMode getPushMode();

    public String getPushURL();

    public Properties getInitParameters();

    public <T> T getApplicationOrSystemProperty(String var1, T var2, Function<String, T> var3);

    default public String getStringProperty(String propertyName, String defaultValue) {
        return this.getApplicationOrSystemProperty(propertyName, defaultValue, Function.identity());
    }

    default public boolean getBooleanProperty(String propertyName, boolean defaultValue) throws IllegalArgumentException {
        String booleanString = this.getStringProperty(propertyName, null);
        if (booleanString == null) {
            return defaultValue;
        }
        if (booleanString.isEmpty()) {
            return true;
        }
        boolean parsedBoolean = Boolean.parseBoolean(booleanString);
        if (Boolean.toString(parsedBoolean).equalsIgnoreCase(booleanString)) {
            return parsedBoolean;
        }
        throw new IllegalArgumentException(String.format("Property named '%s' is boolean, but contains incorrect value '%s' that is not boolean '%s'", propertyName, booleanString, parsedBoolean));
    }

    public String getUIClassName();

    public String getClassLoaderName();

    default public boolean disableAutomaticServletRegistration() {
        return this.getBooleanProperty("disable.automatic.servlet.registration", false);
    }

    default public boolean isBrotli() {
        return this.getBooleanProperty("brotli", false);
    }

    default public String getCompiledWebComponentsPath() {
        return this.getStringProperty("compiled.web.components.path", "vaadin-web-components");
    }

    default public List<String> getPolyfills() {
        return Arrays.asList(this.getStringProperty("module.polyfills", "").split("[, ]+")).stream().filter(polyfill -> !polyfill.isEmpty()).collect(Collectors.toList());
    }

    default public boolean enableDevServer() {
        return this.getBooleanProperty("enableDevServer", true);
    }

    default public boolean reuseDevServer() {
        return this.getBooleanProperty("reuseDevServer", true);
    }

    default public boolean isStatsExternal() {
        return this.getBooleanProperty("external.stats.file", false);
    }

    default public String getExternalStatsUrl() {
        return this.getStringProperty("external.stats.url", "/vaadin-static/VAADIN/config/stats.json");
    }

    default public boolean isEagerServerLoad() {
        return this.getBooleanProperty("eagerServerLoad", false);
    }

    default public boolean isPnpmEnabled() {
        return this.getBooleanProperty("pnpm.enable", false);
    }
}

