/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.BrowserLiveReload;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import org.atmosphere.cpr.AtmosphereResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BrowserLiveReloadImpl
implements BrowserLiveReload {
    private final ClassLoader classLoader;
    private final ConcurrentLinkedQueue<WeakReference<AtmosphereResource>> atmosphereResources = new ConcurrentLinkedQueue();
    private BrowserLiveReload.Backend backend = null;
    private static final EnumMap<BrowserLiveReload.Backend, List<String>> IDENTIFIER_CLASSES = new EnumMap(BrowserLiveReload.Backend.class);

    BrowserLiveReloadImpl() {
        this(BrowserLiveReloadImpl.class.getClassLoader());
    }

    BrowserLiveReloadImpl(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public BrowserLiveReload.Backend getBackend() {
        if (this.backend != null) {
            return this.backend;
        }
        for (Map.Entry<BrowserLiveReload.Backend, List<String>> entry : IDENTIFIER_CLASSES.entrySet()) {
            BrowserLiveReload.Backend backendCandidate = entry.getKey();
            boolean found = true;
            for (String clazz : entry.getValue()) {
                try {
                    this.classLoader.loadClass(clazz);
                }
                catch (ClassNotFoundException e) {
                    BrowserLiveReloadImpl.getLogger().debug("Class {} not found, excluding {}", (Object)clazz, (Object)backendCandidate);
                    found = false;
                    break;
                }
            }
            if (!found) continue;
            this.backend = backendCandidate;
            break;
        }
        return this.backend;
    }

    @Override
    public void setBackend(BrowserLiveReload.Backend backend) {
        assert (backend != null);
        this.backend = backend;
    }

    @Override
    public void onConnect(AtmosphereResource resource) {
        resource.suspend(-1L);
        this.atmosphereResources.add(new WeakReference<AtmosphereResource>(resource));
        resource.getBroadcaster().broadcast((Object)"{\"command\": \"hello\"}", resource);
    }

    @Override
    public void onDisconnect(AtmosphereResource resource) {
        if (!this.atmosphereResources.removeIf(resourceRef -> resource.equals(resourceRef.get()))) {
            String uuid = resource.uuid();
            BrowserLiveReloadImpl.getLogger().warn("Push connection {} is not a live-reload connection or already closed", (Object)uuid);
        }
    }

    @Override
    public boolean isLiveReload(AtmosphereResource resource) {
        return this.atmosphereResources.stream().anyMatch(resourceRef -> resource.equals(resourceRef.get()));
    }

    @Override
    public void reload() {
        this.atmosphereResources.forEach((Consumer<WeakReference<AtmosphereResource>>)((Consumer<WeakReference>)resourceRef -> {
            AtmosphereResource resource = (AtmosphereResource)resourceRef.get();
            if (resource != null) {
                resource.getBroadcaster().broadcast((Object)"{\"command\": \"reload\"}", resource);
            }
        }));
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)BrowserLiveReloadImpl.class.getName());
    }

    static {
        IDENTIFIER_CLASSES.put(BrowserLiveReload.Backend.JREBEL, Collections.singletonList("com.vaadin.flow.server.jrebel.JRebelInitializer"));
        IDENTIFIER_CLASSES.put(BrowserLiveReload.Backend.HOTSWAP_AGENT, Collections.singletonList("org.hotswap.agent.plugin.vaadin.VaadinIntegration"));
        IDENTIFIER_CLASSES.put(BrowserLiveReload.Backend.SPRING_BOOT_DEVTOOLS, Arrays.asList("com.vaadin.flow.spring.SpringServlet", "org.springframework.boot.devtools.livereload.LiveReloadServer"));
    }
}

