/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.Router;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class NavigationState
implements Serializable {
    private Class<? extends Component> navigationTarget;
    private List<String> urlParameters;
    private String resolvedPath;
    private final Router router;

    public NavigationState(Router router) {
        this.router = router;
    }

    public Class<? extends Component> getNavigationTarget() {
        return this.navigationTarget;
    }

    public void setNavigationTarget(Class<? extends Component> navigationTarget) {
        Objects.requireNonNull(navigationTarget, "navigationTarget cannot be null");
        this.navigationTarget = navigationTarget;
    }

    public void setResolvedPath(String resolvedPath) {
        this.resolvedPath = resolvedPath;
    }

    public String getResolvedPath() {
        if (this.resolvedPath == null) {
            this.resolvedPath = RouteConfiguration.forRegistry(this.router.getRegistry()).getUrlBase(this.navigationTarget).orElse(null);
        }
        return this.resolvedPath;
    }

    public Optional<List<String>> getUrlParameters() {
        return Optional.ofNullable(this.urlParameters);
    }

    public void setUrlParameters(List<String> urlParameters) {
        this.urlParameters = urlParameters;
    }
}

