/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.RouterLayout;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class RouteBaseData<T extends RouteBaseData>
implements Comparable<T>,
Serializable {
    private final List<Class<? extends RouterLayout>> parentLayouts;
    private final String url;
    private final List<Class<?>> parameters;
    private final Class<? extends Component> navigationTarget;

    public RouteBaseData(List<Class<? extends RouterLayout>> parentLayouts, String url, List<Class<?>> parameters, Class<? extends Component> navigationTarget) {
        this.parentLayouts = Collections.unmodifiableList(parentLayouts);
        this.url = url;
        this.parameters = Collections.unmodifiableList(parameters);
        this.navigationTarget = navigationTarget;
    }

    public Class<? extends RouterLayout> getParentLayout() {
        if (this.parentLayouts.isEmpty()) {
            return null;
        }
        return this.parentLayouts.get(0);
    }

    public List<Class<? extends RouterLayout>> getParentLayouts() {
        return this.parentLayouts;
    }

    public String getUrl() {
        return this.url;
    }

    public List<Class<?>> getParameters() {
        return this.parameters;
    }

    public Class<? extends Component> getNavigationTarget() {
        return this.navigationTarget;
    }

    @Override
    public int compareTo(T otherRouteData) {
        return this.getUrl().compareToIgnoreCase(((RouteBaseData)otherRouteData).getUrl());
    }

    public boolean equals(Object obj) {
        if (obj instanceof RouteBaseData) {
            RouteBaseData other = (RouteBaseData)obj;
            return other.parentLayouts.equals(this.parentLayouts) && other.url.equals(this.url) && other.navigationTarget.equals(this.navigationTarget);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.parentLayouts, this.url, this.navigationTarget);
    }
}

