/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.LocationChangeEvent;
import com.vaadin.flow.router.NavigationEvent;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.ParameterDeserializer;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.AbstractNavigationStateRenderer;
import java.util.List;
import java.util.Optional;

public class NavigationStateRenderer
extends AbstractNavigationStateRenderer {
    public NavigationStateRenderer(NavigationState navigationState) {
        super(navigationState);
    }

    @Override
    protected List<Class<? extends RouterLayout>> getRouterLayoutTypes(Class<? extends Component> targetType, Router router) {
        NavigationState navigationState = this.getNavigationState();
        assert (targetType == navigationState.getNavigationTarget()) : "Trying to get layouts for wrong route target";
        return router.getRegistry().getRouteLayouts(navigationState.getResolvedPath(), targetType);
    }

    @Override
    protected void notifyNavigationTarget(Component componentInstance, NavigationEvent navigationEvent, BeforeEnterEvent beforeEnterEvent, LocationChangeEvent locationChangeEvent) {
        NavigationState navigationState = this.getNavigationState();
        Class<? extends Component> routeTargetType = navigationState.getNavigationTarget();
        Optional<List<String>> urlParameters = navigationState.getUrlParameters();
        if (urlParameters.isPresent()) {
            Object deserializedParameter = null;
            try {
                deserializedParameter = ParameterDeserializer.deserializeUrlParameters(routeTargetType, urlParameters.get());
            }
            catch (Exception e) {
                beforeEnterEvent.rerouteToError(NotFoundException.class, String.format("Failed to parse url parameter, exception: %s", e));
            }
            HasUrlParameter hasUrlParameter = (HasUrlParameter)((Object)componentInstance);
            hasUrlParameter.setParameter(beforeEnterEvent, deserializedParameter);
        }
    }
}

