/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.BodySize;
import com.vaadin.flow.component.page.Inline;
import com.vaadin.flow.component.page.Meta;
import com.vaadin.flow.component.page.Viewport;
import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.LocationChangeEvent;
import com.vaadin.flow.router.NavigationEvent;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.RouteUtil;
import com.vaadin.flow.server.BootstrapHandler;
import com.vaadin.flow.server.InitialPageSettings;
import com.vaadin.flow.server.InlineTargets;
import com.vaadin.flow.server.PageConfigurator;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.WebBrowser;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

class BootstrapUtils {
    private BootstrapUtils() {
    }

    static Optional<String> getViewportContent(BootstrapHandler.BootstrapContext context) {
        return context.getPageConfigurationAnnotation(Viewport.class).map(Viewport::value);
    }

    static Map<String, String> getMetaTargets(BootstrapHandler.BootstrapContext context) {
        List<Meta> metaAnnotations = context.getPageConfigurationAnnotations(Meta.class);
        boolean illegalValue = false;
        HashMap<String, String> map = new HashMap<String, String>();
        for (Meta meta : metaAnnotations) {
            if (!meta.name().isEmpty() && !meta.content().isEmpty()) {
                map.put(meta.name(), meta.content());
                continue;
            }
            illegalValue = true;
            break;
        }
        if (illegalValue) {
            throw new IllegalStateException("Meta tags added via Meta annotation contain null value on name or content attribute.");
        }
        return map;
    }

    static Optional<InitialPageSettings> getInitialPageSettings(BootstrapHandler.BootstrapContext context) {
        UI ui = context.getUI();
        Optional<PageConfigurator> pageConfigurator = ui.getChildren().filter(component -> component instanceof PageConfigurator).map(component -> (PageConfigurator)((Object)component)).findFirst();
        if (pageConfigurator.isPresent()) {
            InitialPageSettings settings = BootstrapUtils.createInitialPageSettingsObject(context);
            pageConfigurator.get().configurePage(settings);
            return Optional.of(settings);
        }
        return Optional.empty();
    }

    private static InitialPageSettings createInitialPageSettingsObject(BootstrapHandler.BootstrapContext context) {
        UI ui = context.getUI();
        VaadinRequest request = context.getRequest();
        WebBrowser browser = context.getSession().getBrowser();
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            pathInfo = "";
        } else {
            assert (pathInfo.startsWith("/"));
            pathInfo = pathInfo.substring(1);
        }
        Router router = ui.getRouter();
        NavigationEvent navigationEvent = new NavigationEvent(router, new Location(pathInfo, QueryParameters.full(request.getParameterMap())), ui, NavigationTrigger.PAGE_LOAD);
        List<HasElement> components = ui.getChildren().map(component -> component).collect(Collectors.toList());
        AfterNavigationEvent afterNavigationEvent = new AfterNavigationEvent(new LocationChangeEvent(navigationEvent.getSource(), navigationEvent.getUI(), navigationEvent.getTrigger(), navigationEvent.getLocation(), components));
        return new InitialPageSettings(request, ui, afterNavigationEvent, browser);
    }

    static String getBodySizeContent(BootstrapHandler.BootstrapContext context) {
        Optional<BodySize> bodySize = context.getPageConfigurationAnnotation(BodySize.class);
        String height = bodySize.map(BodySize::height).orElse("100vh");
        String width = bodySize.map(BodySize::width).orElse("100%");
        StringBuilder bodyString = new StringBuilder();
        bodyString.append("body {");
        if (!height.isEmpty()) {
            bodyString.append("height:").append(height).append(";");
        }
        if (!width.isEmpty()) {
            bodyString.append("width:").append(width).append(";");
        }
        bodyString.append("margin:0;");
        bodyString.append("}");
        return bodyString.toString();
    }

    static Optional<InlineTargets> getInlineTargets(BootstrapHandler.BootstrapContext context) {
        List<Inline> inlineAnnotations = context.getPageConfigurationAnnotations(Inline.class);
        if (inlineAnnotations.isEmpty()) {
            return Optional.empty();
        }
        InlineTargets inlines = new InlineTargets();
        inlineAnnotations.forEach(inline -> inlines.addInlineDependency((Inline)inline, context.getRequest()));
        return Optional.of(inlines);
    }

    /*
     * Exception decompiling
     */
    static String getDependencyContents(VaadinRequest request, String file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static InputStream getInlineResourceStream(VaadinRequest request, String file) {
        InputStream stream = request.getService().getClassLoader().getResourceAsStream(file);
        if (stream == null) {
            throw new IllegalStateException(String.format("File '%s' for inline resource is not available through the servlet context class loader.", file));
        }
        return stream;
    }

    public static Optional<Class<?>> resolvePageConfigurationHolder(UI ui, VaadinRequest request) {
        assert (ui != null);
        assert (request != null);
        if (ui.getRouter() == null) {
            return Optional.empty();
        }
        Optional<Class<?>> navigationTarget = ui.getRouter().resolveNavigationTarget(request.getPathInfo(), request.getParameterMap()).map(navigationState -> BootstrapUtils.resolveTopParentLayout(ui, navigationState));
        if (navigationTarget.isPresent()) {
            return navigationTarget;
        }
        return ui.getRouter().resolveRouteNotFoundNavigationTarget().map(state -> {
            List<Class<? extends RouterLayout>> layouts = RouteUtil.getParentLayoutsForNonRouteTarget(state.getNavigationTarget());
            if (layouts.isEmpty()) {
                return state.getNavigationTarget();
            }
            return layouts.get(layouts.size() - 1);
        });
    }

    private static Class<?> resolveTopParentLayout(UI ui, NavigationState navigationState) {
        Class<? extends RouterLayout> parentLayout = BootstrapUtils.getTopParentLayout(ui.getRouter(), navigationState);
        if (parentLayout != null) {
            return parentLayout;
        }
        return navigationState.getNavigationTarget();
    }

    private static Class<? extends RouterLayout> getTopParentLayout(Router router, NavigationState navigationState) {
        List<Class<? extends RouterLayout>> routeLayouts = router.getRegistry().getRouteLayouts(navigationState.getResolvedPath(), navigationState.getNavigationTarget());
        if (routeLayouts.isEmpty()) {
            return null;
        }
        return routeLayouts.get(routeLayouts.size() - 1);
    }

    private static /* synthetic */ boolean lambda$getDependencyContents$4(String string) {
        return !string.isEmpty();
    }
}

