/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.server.DefaultDeploymentConfiguration;
import com.vaadin.flow.server.PropertyDeploymentConfiguration;
import com.vaadin.flow.server.VaadinConfig;
import com.vaadin.flow.server.VaadinConfigurationException;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServletConfiguration;
import com.vaadin.flow.server.frontend.FallbackChunk;
import com.vaadin.flow.server.frontend.FrontendUtils;
import elemental.json.JsonObject;
import elemental.json.impl.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeploymentConfigurationFactory
implements Serializable {
    public static final Object FALLBACK_CHUNK = new Serializable(){};
    public static final String ERROR_DEV_MODE_NO_FILES = "There are neither 'flow-build-info.json' nor 'webpack.config.js' file available in the project/working directory. Ensure 'webpack.config.js' is present or trigger creation of 'flow-build-info.json' via running 'prepare-frontend' Maven goal.";
    public static final String DEV_FOLDER_MISSING_MESSAGE = "Running project in development mode with no access to folder '%s'.%nBuild project in production mode instead, see https://vaadin.com/docs/v15/flow/production/tutorial-production-mode-basic.html";
    private static final Logger logger = LoggerFactory.getLogger(DeploymentConfigurationFactory.class);

    private DeploymentConfigurationFactory() {
    }

    public static DeploymentConfiguration createDeploymentConfiguration(Class<?> systemPropertyBaseClass, VaadinConfig vaadinConfig) throws VaadinConfigurationException {
        return new DefaultDeploymentConfiguration(systemPropertyBaseClass, DeploymentConfigurationFactory.createInitParameters(systemPropertyBaseClass, vaadinConfig));
    }

    public static DeploymentConfiguration createPropertyDeploymentConfiguration(Class<?> systemPropertyBaseClass, VaadinConfig vaadinConfig) throws VaadinConfigurationException {
        return new PropertyDeploymentConfiguration(systemPropertyBaseClass, DeploymentConfigurationFactory.createInitParameters(systemPropertyBaseClass, vaadinConfig));
    }

    protected static Properties createInitParameters(Class<?> systemPropertyBaseClass, VaadinConfig vaadinConfig) throws VaadinConfigurationException {
        String name;
        Properties initParameters = new Properties();
        DeploymentConfigurationFactory.readUiFromEnclosingClass(systemPropertyBaseClass, initParameters);
        DeploymentConfigurationFactory.readConfigurationAnnotation(systemPropertyBaseClass, initParameters);
        VaadinContext context = vaadinConfig.getVaadinContext();
        Enumeration<String> e = context.getContextParameterNames();
        while (e.hasMoreElements()) {
            name = e.nextElement();
            initParameters.setProperty(name, context.getContextParameter(name));
        }
        e = vaadinConfig.getConfigParameterNames();
        while (e.hasMoreElements()) {
            name = e.nextElement();
            initParameters.setProperty(name, vaadinConfig.getConfigParameter(name));
        }
        DeploymentConfigurationFactory.readBuildInfo(initParameters);
        return initParameters;
    }

    private static void readBuildInfo(Properties initParameters) {
        String json = DeploymentConfigurationFactory.getTokenFileContents(initParameters);
        if (json != null) {
            JsonObject buildInfo = (JsonObject)JsonUtil.parse((String)json);
            DeploymentConfigurationFactory.setInitParametersUsingTokenData(initParameters, buildInfo);
            FallbackChunk fallbackChunk = FrontendUtils.readFallbackChunk(buildInfo);
            if (fallbackChunk != null) {
                initParameters.put(FALLBACK_CHUNK, fallbackChunk);
            }
        }
        try {
            DeploymentConfigurationFactory.verifyMode(json != null, DeploymentConfigurationFactory.hasWebpackConfig(initParameters));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void setInitParametersUsingTokenData(Properties initParameters, JsonObject buildInfo) {
        if (buildInfo.hasKey("productionMode")) {
            initParameters.setProperty("productionMode", String.valueOf(buildInfo.getBoolean("productionMode")));
        }
        if (buildInfo.hasKey("externalStatsFile") || buildInfo.hasKey("externalStatsUrl")) {
            initParameters.setProperty("enableDevServer", Boolean.toString(false));
            initParameters.setProperty("external.stats.file", Boolean.toString(true));
            if (buildInfo.hasKey("externalStatsUrl")) {
                initParameters.setProperty("external.stats.url", buildInfo.getString("externalStatsUrl"));
            }
            return;
        }
        if (buildInfo.hasKey("useDeprecatedV14Bootstrapping")) {
            initParameters.setProperty("useDeprecatedV14Bootstrapping", String.valueOf(buildInfo.getBoolean("useDeprecatedV14Bootstrapping")));
            System.clearProperty("vaadin.useDeprecatedV14Bootstrapping");
        }
        if (buildInfo.hasKey("eagerServerLoad")) {
            initParameters.setProperty("eagerServerLoad", String.valueOf(buildInfo.getBoolean("eagerServerLoad")));
            System.clearProperty("vaadin.eagerServerLoad");
        }
        if (buildInfo.hasKey("npmFolder")) {
            initParameters.setProperty("project.basedir", buildInfo.getString("npmFolder"));
            DeploymentConfigurationFactory.verifyFolderExists(initParameters, buildInfo.getString("npmFolder"));
        }
        if (buildInfo.hasKey("frontendFolder")) {
            initParameters.setProperty("vaadin.frontend.frontend.folder", buildInfo.getString("frontendFolder"));
            if (!buildInfo.hasKey("npmFolder") || !buildInfo.getString("frontendFolder").startsWith(buildInfo.getString("npmFolder"))) {
                DeploymentConfigurationFactory.verifyFolderExists(initParameters, buildInfo.getString("frontendFolder"));
            }
        }
        if (buildInfo.hasKey("enableDevServer")) {
            initParameters.setProperty("enableDevServer", String.valueOf(buildInfo.getBoolean("enableDevServer")));
        }
        if (buildInfo.hasKey("reuseDevServer")) {
            initParameters.setProperty("reuseDevServer", String.valueOf(buildInfo.getBoolean("reuseDevServer")));
        }
        if (buildInfo.hasKey("connect.javaSourceFolder")) {
            initParameters.setProperty("connect.javaSourceFolder", buildInfo.getString("connect.javaSourceFolder"));
        }
        if (buildInfo.hasKey("connect.openApiFile")) {
            initParameters.setProperty("connect.openApiFile", buildInfo.getString("connect.openApiFile"));
        }
        if (buildInfo.hasKey("connect.applicationProperties")) {
            initParameters.setProperty("connect.applicationProperties", buildInfo.getString("connect.applicationProperties"));
        }
        if (buildInfo.hasKey("connect.generated")) {
            initParameters.setProperty("connect.generated", buildInfo.getString("connect.generated"));
        }
        DeploymentConfigurationFactory.setDevModePropertiesUsingTokenData(initParameters, buildInfo);
    }

    private static void setDevModePropertiesUsingTokenData(Properties initParameters, JsonObject buildInfo) {
        if (initParameters.getProperty("pnpm.enable") == null && buildInfo.hasKey("pnpm.enable")) {
            initParameters.setProperty("pnpm.enable", String.valueOf(buildInfo.getBoolean("pnpm.enable")));
        }
        if (initParameters.getProperty("require.home.node") == null && buildInfo.hasKey("require.home.node")) {
            initParameters.setProperty("require.home.node", String.valueOf(buildInfo.getBoolean("require.home.node")));
        }
    }

    private static String getTokenFileContents(Properties initParameters) {
        String json = null;
        try {
            json = DeploymentConfigurationFactory.getResourceFromFile(initParameters);
            if (json == null) {
                json = DeploymentConfigurationFactory.getResourceFromClassloader();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return json;
    }

    private static String getResourceFromFile(Properties initParameters) throws IOException {
        File tokenFile;
        String json = null;
        String tokenLocation = initParameters.getProperty("vaadin.frontend.token.file");
        if (tokenLocation != null && (tokenFile = new File(tokenLocation)) != null && tokenFile.canRead()) {
            json = FileUtils.readFileToString((File)tokenFile, (Charset)StandardCharsets.UTF_8);
        }
        return json;
    }

    private static String getResourceFromClassloader() throws IOException {
        String json = null;
        String tokenResource = "META-INF/VAADIN/config/flow-build-info.json";
        ArrayList<URL> resources = Collections.list(DeploymentConfiguration.class.getClassLoader().getResources(tokenResource));
        URL resource = resources.stream().filter(url -> !url.getPath().endsWith("jar!/" + tokenResource)).findFirst().orElse(null);
        if (resource == null && !resources.isEmpty()) {
            json = DeploymentConfigurationFactory.getPossibleJarResource(resources);
        } else if (resource != null) {
            json = FrontendUtils.streamToString(resource.openStream());
        }
        return json;
    }

    private static String getPossibleJarResource(List<URL> resources) throws IOException {
        Objects.requireNonNull(resources);
        assert (!resources.isEmpty()) : "Possible jar resource requires resources to be available.";
        URL webpackGenerated = DeploymentConfiguration.class.getClassLoader().getResource("webpack.generated.js");
        if (DeploymentConfigurationFactory.countInstances(webpackGenerated.getPath(), "jar!/") >= 2) {
            for (URL resource : resources) {
                if (DeploymentConfigurationFactory.countInstances(resource.getPath(), "jar!/") != 1) continue;
                return FrontendUtils.streamToString(resource.openStream());
            }
        }
        URL firstResource = resources.get(0);
        if (resources.size() > 1) {
            String warningMessage = String.format("Unable to fully determine correct flow-build-info.%nAccepting file '%s' first match of '%s' possible.%nPlease verify flow-build-info file content.", firstResource.getPath(), resources.size());
            logger.warn(warningMessage);
        } else {
            String debugMessage = String.format("Unable to fully determine correct flow-build-info.%nAccepting file '%s'", firstResource.getPath());
            logger.debug(debugMessage);
        }
        return FrontendUtils.streamToString(firstResource.openStream());
    }

    private static int countInstances(String input, String value) {
        return input.split(value, -1).length - 1;
    }

    private static void verifyFolderExists(Properties initParameters, String folder) {
        Boolean productionMode = Boolean.parseBoolean(initParameters.getProperty("productionMode", "false"));
        if (!productionMode.booleanValue() && !new File(folder).exists()) {
            String message = String.format(DEV_FOLDER_MISSING_MESSAGE, folder);
            throw new IllegalStateException(message);
        }
    }

    private static void verifyMode(boolean hasTokenFile, boolean hasWebpackConfig) {
        if (!hasTokenFile && !hasWebpackConfig) {
            throw new IllegalStateException(ERROR_DEV_MODE_NO_FILES);
        }
        if (!hasTokenFile && hasWebpackConfig) {
            logger.warn("Found 'webpack.config.js' in the project/working directory. Will use it for webpack dev server.");
        }
    }

    private static boolean hasWebpackConfig(Properties initParameters) throws IOException {
        String baseDir = initParameters.getProperty("project.basedir");
        File projectBaseDir = baseDir == null ? new File(".") : new File(baseDir);
        File webPackConfig = new File(projectBaseDir, "webpack.config.js");
        return FrontendUtils.isWebpackConfigFile(webPackConfig);
    }

    private static void readUiFromEnclosingClass(Class<?> systemPropertyBaseClass, Properties initParameters) {
        Class<?> enclosingClass = systemPropertyBaseClass.getEnclosingClass();
        if (enclosingClass != null && UI.class.isAssignableFrom(enclosingClass)) {
            initParameters.put("UI", enclosingClass.getName());
        }
    }

    private static void readConfigurationAnnotation(Class<?> systemPropertyBaseClass, Properties initParameters) throws VaadinConfigurationException {
        Method[] methods;
        Optional<VaadinServletConfiguration> optionalConfigAnnotation = AnnotationReader.getAnnotationFor(systemPropertyBaseClass, VaadinServletConfiguration.class);
        if (!optionalConfigAnnotation.isPresent()) {
            return;
        }
        VaadinServletConfiguration configuration = optionalConfigAnnotation.get();
        for (Method method : methods = VaadinServletConfiguration.class.getDeclaredMethods()) {
            VaadinServletConfiguration.InitParameterName name = method.getAnnotation(VaadinServletConfiguration.InitParameterName.class);
            assert (name != null) : "All methods declared in VaadinServletConfiguration should have a @InitParameterName annotation";
            try {
                Object value = method.invoke((Object)configuration, new Object[0]);
                String stringValue = value instanceof Class ? ((Class)value).getName() : value.toString();
                initParameters.setProperty(name.value(), stringValue);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new VaadinConfigurationException("Could not read @VaadinServletConfiguration value " + method.getName(), e);
            }
        }
    }
}

