/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.connect.auth;

import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.connect.auth.AnonymousAllowed;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;

public class VaadinConnectAccessChecker {
    private boolean xsrfProtectionEnabled = true;

    public String check(Method method, HttpServletRequest request) {
        if (request.getUserPrincipal() != null) {
            return this.verifyAuthenticatedUser(method, request);
        }
        return this.verifyAnonymousUser(method, request);
    }

    public AnnotatedElement getSecurityTarget(Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new IllegalArgumentException(String.format("The method '%s' is not public hence cannot have a security target", method));
        }
        return this.hasSecurityAnnotation(method) ? method : method.getDeclaringClass();
    }

    private String verifyAnonymousUser(Method method, HttpServletRequest request) {
        if (!this.getSecurityTarget(method).isAnnotationPresent(AnonymousAllowed.class) || this.cannotAccessMethod(method, request)) {
            return "Anonymous access is not allowed";
        }
        return null;
    }

    private String verifyAuthenticatedUser(Method method, HttpServletRequest request) {
        if (this.cannotAccessMethod(method, request)) {
            return "Unauthorized access to Vaadin endpoint";
        }
        return null;
    }

    private boolean cannotAccessMethod(Method method, HttpServletRequest request) {
        return this.requestForbidden(request) || this.entityForbidden(this.getSecurityTarget(method), request);
    }

    private boolean requestForbidden(HttpServletRequest request) {
        if (!this.xsrfProtectionEnabled) {
            return false;
        }
        String csrfToken = (String)request.getSession().getAttribute(VaadinService.getCsrfTokenAttributeName());
        return csrfToken != null && !csrfToken.equals(request.getHeader("X-CSRF-Token"));
    }

    private boolean entityForbidden(AnnotatedElement entity, HttpServletRequest request) {
        return entity.isAnnotationPresent(DenyAll.class) || !entity.isAnnotationPresent(AnonymousAllowed.class) && !this.roleAllowed(entity.getAnnotation(RolesAllowed.class), request);
    }

    private boolean roleAllowed(RolesAllowed rolesAllowed, HttpServletRequest request) {
        if (rolesAllowed == null) {
            return true;
        }
        for (String role : rolesAllowed.value()) {
            if (!request.isUserInRole(role)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSecurityAnnotation(Method method) {
        return method.isAnnotationPresent(AnonymousAllowed.class) || method.isAnnotationPresent(PermitAll.class) || method.isAnnotationPresent(DenyAll.class) || method.isAnnotationPresent(RolesAllowed.class);
    }

    public void enableCsrf(boolean xsrfProtectionEnabled) {
        this.xsrfProtectionEnabled = xsrfProtectionEnabled;
    }
}

