/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.PWA;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;

public class PwaConfiguration
implements Serializable {
    public static final String DEFAULT_PATH = "manifest.webmanifest";
    public static final String DEFAULT_ICON = "icons/icon.png";
    public static final String DEFAULT_NAME = "Vaadin Flow Application";
    public static final String DEFAULT_THEME_COLOR = "#ffffff";
    public static final String DEFAULT_BACKGROUND_COLOR = "#f2f2f2";
    public static final String DEFAULT_DISPLAY = "standalone";
    public static final String DEFAULT_OFFLINE_PATH = "offline.html";
    private final String appName;
    private final String shortName;
    private final String description;
    private final String backgroundColor;
    private final String themeColor;
    private final String iconPath;
    private final String manifestPath;
    private final String offlinePath;
    private final String serviceWorkerPath = "sw.js";
    private final String display;
    private final String rootUrl;
    private final String startPath;
    private final boolean enabled;
    private final List<String> offlineResources;

    protected PwaConfiguration(PWA pwa, ServletContext servletContext) {
        String string = this.rootUrl = PwaConfiguration.hasContextPath(servletContext) ? servletContext.getContextPath() + "/" : "/";
        if (pwa != null) {
            this.appName = pwa.name();
            this.shortName = pwa.shortName().substring(0, Math.min(pwa.shortName().length(), 12));
            this.description = pwa.description();
            this.backgroundColor = pwa.backgroundColor();
            this.themeColor = pwa.themeColor();
            this.iconPath = PwaConfiguration.checkPath(pwa.iconPath());
            this.manifestPath = PwaConfiguration.checkPath(pwa.manifestPath());
            this.offlinePath = PwaConfiguration.checkPath(pwa.offlinePath());
            this.display = pwa.display();
            this.startPath = pwa.startPath().replaceAll("^/+", "");
            this.enabled = true;
            this.offlineResources = Arrays.asList(pwa.offlineResources());
        } else {
            this.appName = DEFAULT_NAME;
            this.shortName = "Flow PWA";
            this.description = "";
            this.backgroundColor = DEFAULT_BACKGROUND_COLOR;
            this.themeColor = DEFAULT_THEME_COLOR;
            this.iconPath = DEFAULT_ICON;
            this.manifestPath = DEFAULT_PATH;
            this.offlinePath = DEFAULT_OFFLINE_PATH;
            this.display = DEFAULT_DISPLAY;
            this.startPath = "";
            this.enabled = false;
            this.offlineResources = Collections.emptyList();
        }
    }

    private static boolean hasContextPath(ServletContext servletContext) {
        return servletContext != null && servletContext.getContextPath() != null && !servletContext.getContextPath().isEmpty();
    }

    private static String checkPath(String path) {
        return path.replaceAll("^[./]+", "");
    }

    public String getAppName() {
        return this.appName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public String getThemeColor() {
        return this.themeColor;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public String relIconPath() {
        return "/" + this.iconPath;
    }

    public String getManifestPath() {
        return this.manifestPath;
    }

    public String relManifestPath() {
        return "/" + this.manifestPath;
    }

    public String getOfflinePath() {
        return this.offlinePath;
    }

    public String relOfflinePath() {
        return "/" + this.offlinePath;
    }

    public String getServiceWorkerPath() {
        return "sw.js";
    }

    public String relServiceWorkerPath() {
        return "/sw.js";
    }

    public List<String> getOfflineResources() {
        return Collections.unmodifiableList(this.offlineResources);
    }

    public String getDisplay() {
        return this.display;
    }

    public String getStartUrl() {
        return this.rootUrl + this.startPath;
    }

    public String getRootUrl() {
        return this.rootUrl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

