/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.BootstrapHandlerHelper;
import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.flow.internal.BrowserLiveReloadAccess;
import com.vaadin.flow.internal.UsageStatisticsExporter;
import com.vaadin.flow.server.AppShellRegistry;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.IndexHtmlResponse;
import com.vaadin.flow.server.communication.JavaScriptBootstrapHandler;
import com.vaadin.flow.server.frontend.FrontendUtils;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.jsoup.Jsoup;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexHtmlRequestHandler
extends JavaScriptBootstrapHandler {
    private transient IndexHtmlResponse indexHtmlResponse;

    @Override
    public boolean synchronizedHandleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        Document indexDocument = IndexHtmlRequestHandler.getIndexHtmlDocument(request);
        IndexHtmlRequestHandler.prependBaseHref(request, indexDocument);
        JsonObject initialJson = Json.createObject();
        if (request.getService().getBootstrapInitialPredicate().includeInitialUidl(request)) {
            this.includeInitialUidl(initialJson, session, request, response);
            this.indexHtmlResponse = new IndexHtmlResponse(request, response, indexDocument, UI.getCurrent());
            session.setAttribute("clientRoutingMode", Boolean.TRUE);
        } else {
            this.indexHtmlResponse = new IndexHtmlResponse(request, response, indexDocument);
        }
        this.addInitialFlow(initialJson, indexDocument, session);
        this.configureErrorDialogStyles(indexDocument);
        IndexHtmlRequestHandler.showWebpackErrors(indexDocument);
        response.setContentType("text/html; charset=utf-8");
        VaadinContext context = session.getService().getContext();
        AppShellRegistry registry = AppShellRegistry.getInstance(context);
        DeploymentConfiguration config = session.getConfiguration();
        if (!config.isProductionMode()) {
            UsageStatisticsExporter.exportUsageStatisticsToDocument(indexDocument);
        }
        IndexHtmlRequestHandler.setupPwa(indexDocument, session.getService());
        registry.modifyIndexHtml(indexDocument, request);
        request.getService().modifyIndexHtmlResponse(this.indexHtmlResponse);
        if (config.isDevModeLiveReloadEnabled()) {
            this.addDevmodeGizmo(indexDocument, session, request);
        }
        try {
            response.getOutputStream().write(indexDocument.html().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            IndexHtmlRequestHandler.getLogger().error("Error writing 'index.html' to response", (Throwable)e);
            return false;
        }
        return true;
    }

    private void addDevmodeGizmo(Document indexDocument, VaadinSession session, VaadinRequest request) {
        BrowserLiveReload liveReload;
        VaadinService service = session.getService();
        BrowserLiveReloadAccess liveReloadAccess = service.getInstantiator().getOrCreate(BrowserLiveReloadAccess.class);
        BrowserLiveReload browserLiveReload = liveReload = liveReloadAccess != null ? liveReloadAccess.getLiveReload(service) : null;
        if (liveReload != null) {
            Element devmodeGizmo = new Element("vaadin-devmode-gizmo");
            devmodeGizmo.attr("url", BootstrapHandlerHelper.getPushURL(session, request));
            if (liveReload.getBackend() != null) {
                devmodeGizmo.attr("backend", liveReload.getBackend().toString());
            }
            devmodeGizmo.attr("springbootlivereloadport", Integer.toString(35729));
            indexDocument.body().appendChild((Node)devmodeGizmo);
        }
    }

    private void addInitialFlow(JsonObject initialJson, Document indexDocument, VaadinSession session) {
        String csrfToken = session.getCsrfToken();
        if (csrfToken != null) {
            initialJson.put("csrfToken", csrfToken);
        }
        Element elm = new Element("script");
        elm.attr("initial", "");
        elm.appendChild((Node)new DataNode("window.Vaadin = {TypeScript: " + JsonUtil.stringify((JsonValue)initialJson) + "};"));
        indexDocument.head().insertChildren(0, new Node[]{elm});
    }

    private void includeInitialUidl(JsonObject initialJson, VaadinSession session, VaadinRequest request, VaadinResponse response) {
        JsonObject initial = this.getInitialJson(request, response, session);
        initialJson.put("initial", (JsonValue)initial);
    }

    @Override
    protected boolean canHandleRequest(VaadinRequest request) {
        return request.getService().getBootstrapUrlPredicate().isValidUrl(request);
    }

    @Override
    protected void initializeUIWithRouter(VaadinRequest request, UI ui) {
        if (request.getService().getBootstrapInitialPredicate().includeInitialUidl(request)) {
            ui.getRouter().initializeUI(ui, request);
        }
    }

    private void configureErrorDialogStyles(Document document) {
        Element styles = document.createElement("style");
        document.head().appendChild((Node)styles);
        IndexHtmlRequestHandler.setupErrorDialogs(styles);
    }

    private static void prependBaseHref(VaadinRequest request, Document indexDocument) {
        Elements base = indexDocument.head().getElementsByTag("base");
        String baseHref = IndexHtmlRequestHandler.getServiceUrl(request);
        if (base.isEmpty()) {
            indexDocument.head().prependElement("base").attr("href", baseHref);
        } else {
            base.first().attr("href", baseHref);
        }
    }

    private static Document getIndexHtmlDocument(VaadinRequest request) throws IOException {
        String index = FrontendUtils.getIndexHtmlContent(request.getService());
        if (index != null) {
            return Jsoup.parse((String)index);
        }
        String frontendDir = FrontendUtils.getProjectFrontendDir(request.getService().getDeploymentConfiguration());
        String message = String.format("Failed to load content of '%1$sindex.html'.It is required to have '%1$sindex.html' file when using client side bootstrapping.", frontendDir);
        throw new IOException(message);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(IndexHtmlRequestHandler.class);
    }

    protected IndexHtmlResponse getIndexHtmlResponse() {
        return this.indexHtmlResponse;
    }
}

