/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.connect.generator;

import com.github.javaparser.resolution.declarations.ResolvedEnumConstantDeclaration;
import com.github.javaparser.resolution.types.ResolvedPrimitiveType;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.utils.Pair;
import com.vaadin.flow.server.connect.generator.GeneratorUtils;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

class SchemaResolver {
    private static final String SCHEMA_REF_PREFIX = "#/components/schemas/";
    private final Map<String, ResolvedReferenceType> foundTypes = new HashMap<String, ResolvedReferenceType>();

    SchemaResolver() {
    }

    Schema parseResolvedTypeToSchema(ResolvedType resolvedType) {
        if (resolvedType.isArray()) {
            return this.createArraySchema(resolvedType);
        }
        if (this.isNumberType(resolvedType)) {
            return new NumberSchema();
        }
        if (this.isStringType(resolvedType)) {
            return new StringSchema();
        }
        if (this.isCollectionType(resolvedType)) {
            return this.createCollectionSchema(resolvedType.asReferenceType());
        }
        if (this.isBooleanType(resolvedType)) {
            return new BooleanSchema();
        }
        if (this.isMapType(resolvedType)) {
            return this.createMapSchema(resolvedType);
        }
        if (this.isDateType(resolvedType)) {
            return new DateSchema();
        }
        if (this.isDateTimeType(resolvedType)) {
            return new DateTimeSchema();
        }
        if (this.isOptionalType(resolvedType)) {
            return this.createOptionalSchema(resolvedType.asReferenceType());
        }
        if (this.isUnhandledJavaType(resolvedType)) {
            return new ObjectSchema();
        }
        if (this.isTypeOf(resolvedType, Enum.class)) {
            return this.createEnumTypeSchema(resolvedType);
        }
        return this.createUserBeanSchema(resolvedType);
    }

    private Schema createArraySchema(ResolvedType type) {
        ArraySchema array = new ArraySchema();
        array.items(this.parseResolvedTypeToSchema(type.asArrayType().getComponentType()));
        return array;
    }

    private Schema createCollectionSchema(ResolvedReferenceType type) {
        ArraySchema array = new ArraySchema();
        List typeParametersMap = type.getTypeParametersMap();
        if (!typeParametersMap.isEmpty()) {
            ResolvedType collectionParameterType = (ResolvedType)((Pair)typeParametersMap.get((int)0)).b;
            array.items(this.parseResolvedTypeToSchema(collectionParameterType));
        }
        return array;
    }

    private Schema createOptionalSchema(ResolvedReferenceType type) {
        ResolvedType typeInOptional = (ResolvedType)((Pair)type.getTypeParametersMap().get((int)0)).b;
        Schema nestedTypeSchema = this.parseResolvedTypeToSchema(typeInOptional);
        return this.createNullableWrapper(nestedTypeSchema);
    }

    Schema createNullableWrapper(Schema nestedTypeSchema) {
        if (nestedTypeSchema.get$ref() == null) {
            nestedTypeSchema.setNullable(Boolean.valueOf(true));
            return nestedTypeSchema;
        }
        ComposedSchema nullableSchema = new ComposedSchema();
        nullableSchema.setNullable(Boolean.valueOf(true));
        nullableSchema.setAllOf(Collections.singletonList(nestedTypeSchema));
        return nullableSchema;
    }

    private Schema createMapSchema(ResolvedType type) {
        MapSchema mapSchema = new MapSchema();
        List typeParametersMap = type.asReferenceType().getTypeParametersMap();
        if (typeParametersMap.size() == 2) {
            ResolvedType mapValueType = (ResolvedType)((Pair)typeParametersMap.get((int)1)).b;
            mapSchema.additionalProperties((Object)this.parseResolvedTypeToSchema(mapValueType));
        }
        return mapSchema;
    }

    private boolean isOptionalType(ResolvedType resolvedType) {
        return resolvedType.isReferenceType() && this.isTypeOf(resolvedType, Optional.class);
    }

    private boolean isUnhandledJavaType(ResolvedType resolvedType) {
        return resolvedType.isReferenceType() && resolvedType.asReferenceType().getQualifiedName().startsWith("java.");
    }

    private boolean isDateTimeType(ResolvedType resolvedType) {
        return resolvedType.isReferenceType() && this.isTypeOf(resolvedType, LocalDateTime.class, Instant.class, LocalTime.class);
    }

    private boolean isDateType(ResolvedType resolvedType) {
        return resolvedType.isReferenceType() && this.isTypeOf(resolvedType, Date.class, LocalDate.class);
    }

    private boolean isNumberType(ResolvedType type) {
        if (type.isPrimitive()) {
            ResolvedPrimitiveType resolvedPrimitiveType = type.asPrimitive();
            return resolvedPrimitiveType != ResolvedPrimitiveType.BOOLEAN && resolvedPrimitiveType != ResolvedPrimitiveType.CHAR;
        }
        return this.isTypeOf(type, Number.class);
    }

    private boolean isCollectionType(ResolvedType type) {
        return !type.isPrimitive() && this.isTypeOf(type, Collection.class);
    }

    private boolean isMapType(ResolvedType type) {
        return !type.isPrimitive() && this.isTypeOf(type, Map.class);
    }

    private boolean isBooleanType(ResolvedType type) {
        if (type.isPrimitive()) {
            return type.asPrimitive() == ResolvedPrimitiveType.BOOLEAN;
        }
        return this.isTypeOf(type, Boolean.class);
    }

    private boolean isStringType(ResolvedType type) {
        if (type.isPrimitive()) {
            return type.asPrimitive() == ResolvedPrimitiveType.CHAR;
        }
        return this.isTypeOf(type, String.class, Character.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isTypeOf(ResolvedType type, Class ... clazz) {
        if (!type.isReferenceType()) {
            return false;
        }
        List classes = Arrays.stream(clazz).map(Class::getName).collect(Collectors.toList());
        if (classes.contains(type.asReferenceType().getQualifiedName())) return true;
        if (!type.asReferenceType().getAllAncestors().stream().map(ResolvedReferenceType::getQualifiedName).anyMatch(classes::contains)) return false;
        return true;
    }

    private Schema createEnumTypeSchema(ResolvedType resolvedType) {
        ResolvedReferenceType type = resolvedType.asReferenceType();
        List entries = type.getTypeDeclaration().asEnum().getEnumConstants().stream().map(ResolvedEnumConstantDeclaration::getName).collect(Collectors.toList());
        String qualifiedName = type.getQualifiedName();
        this.foundTypes.put(qualifiedName, type);
        StringSchema schema = new StringSchema();
        schema.name(qualifiedName);
        schema.setEnum(entries);
        schema.$ref(this.getFullQualifiedNameRef(qualifiedName));
        return schema;
    }

    private Schema createUserBeanSchema(ResolvedType resolvedType) {
        if (resolvedType.isReferenceType()) {
            String qualifiedName = resolvedType.asReferenceType().getQualifiedName();
            this.foundTypes.put(qualifiedName, resolvedType.asReferenceType());
            return new ObjectSchema().name(qualifiedName).$ref(this.getFullQualifiedNameRef(qualifiedName));
        }
        return new ObjectSchema();
    }

    String getFullQualifiedNameRef(String qualifiedName) {
        return SCHEMA_REF_PREFIX + qualifiedName;
    }

    String getSimpleRef(String ref) {
        if (GeneratorUtils.contains(ref, SCHEMA_REF_PREFIX)) {
            return GeneratorUtils.substringAfter(ref, SCHEMA_REF_PREFIX);
        }
        return ref;
    }

    void addFoundTypes(String qualifiedName, ResolvedReferenceType type) {
        this.foundTypes.put(qualifiedName, type);
    }

    ResolvedReferenceType getFoundTypeByQualifiedName(String qualifiedName) {
        return this.foundTypes.get(qualifiedName);
    }

    Map<String, ResolvedReferenceType> getFoundTypes() {
        return this.foundTypes;
    }
}

