/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.littemplate;

import com.vaadin.flow.component.littemplate.LitTemplate;
import com.vaadin.flow.component.littemplate.LitTemplateDataAnalyzer;
import com.vaadin.flow.component.polymertemplate.IdMapper;
import com.vaadin.flow.component.polymertemplate.TemplateDataAnalyzer;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.ReflectionCache;
import com.vaadin.flow.server.VaadinService;
import java.util.function.Consumer;

public class LitTemplateInitializer {
    private static final ReflectionCache<LitTemplate, TemplateDataAnalyzer.ParserData> CACHE = new ReflectionCache(templateClass -> new LitTemplateDataAnalyzer((Class<? extends LitTemplate>)templateClass).parseTemplate());
    private final LitTemplate template;
    private final TemplateDataAnalyzer.ParserData parserData;

    public LitTemplateInitializer(LitTemplate template, VaadinService service) {
        this.template = template;
        boolean productionMode = service.getDeploymentConfiguration().isProductionMode();
        Class<?> templateClass = template.getClass();
        TemplateDataAnalyzer.ParserData data = null;
        if (productionMode) {
            data = CACHE.get(templateClass);
        }
        if (data == null) {
            data = new LitTemplateDataAnalyzer(templateClass).parseTemplate();
        }
        this.parserData = data;
    }

    public void initChildElements() {
        IdMapper idMapper = new IdMapper(this.template);
        Consumer<Element> noOp = element -> {};
        this.parserData.forEachInjectedField((field, id, tag) -> idMapper.mapComponentOrElement(field, id, tag, noOp));
    }
}

