/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.JavaScriptBootstrapUI;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.SessionExpiredHandler;
import com.vaadin.flow.server.SynchronizedRequestHandler;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.ServerRpcHandler;
import com.vaadin.flow.server.communication.UidlWriter;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonType;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UidlRequestHandler
extends SynchronizedRequestHandler
implements SessionExpiredHandler {
    private ServerRpcHandler rpcHandler;
    public static final Pattern HASH_PATTERN = Pattern.compile("window.location.hash ?= ?'(.*?)'");
    public static final Pattern URL_PATTERN = Pattern.compile("^(.*)#(.+)$");
    public static final String PUSH_STATE_HASH = "setTimeout(() => history.pushState(null, null, location.pathname + location.search + '#%s'));";
    public static final String PUSH_STATE_LOCATION = "setTimeout(() => history.pushState(null, null, '%s'));";
    private static final String SYNC_ID = "\"syncId\"";
    private static final String RPC = "rpc";
    private static final String LOCATION = "location";
    private static final String CHANGES = "changes";
    private static final String EXECUTE = "execute";

    @Override
    protected boolean canHandleRequest(VaadinRequest request) {
        return HandlerHelper.isRequestType(request, HandlerHelper.RequestType.UIDL);
    }

    protected ServerRpcHandler createRpcHandler() {
        return new ServerRpcHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean synchronizedHandleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        UI uI = session.getService().findUI(request);
        if (uI == null) {
            UidlRequestHandler.commitJsonResponse(response, VaadinService.createUINotFoundJSON(false));
            return true;
        }
        try (StringWriter stringWriter = new StringWriter();){
            this.getRpcHandler(session).handleRpc(uI, request.getReader(), request);
            this.writeUidl(uI, stringWriter, false);
        }
        UidlRequestHandler.commitJsonResponse(response, stringWriter.toString());
        return true;
    }

    private void writeRefresh(VaadinResponse response) throws IOException {
        String json = VaadinService.createCriticalNotificationJSON(null, null, null, null);
        UidlRequestHandler.commitJsonResponse(response, json);
    }

    void writeUidl(UI ui, Writer writer, boolean resync) throws IOException {
        JsonObject uidl = this.createUidl(ui, resync);
        if (ui instanceof JavaScriptBootstrapUI) {
            this.removeOffendingMprHashFragment(uidl);
        }
        String responseString = "for(;;);[" + uidl.toJson() + "]";
        writer.write(responseString);
    }

    JsonObject createUidl(UI ui, boolean resync) {
        return new UidlWriter().createUidl(ui, false, resync);
    }

    private static final Logger getLogger() {
        return LoggerFactory.getLogger((String)UidlRequestHandler.class.getName());
    }

    @Override
    public boolean handleSessionExpired(VaadinRequest request, VaadinResponse response) throws IOException {
        if (!HandlerHelper.isRequestType(request, HandlerHelper.RequestType.UIDL)) {
            return false;
        }
        VaadinService service = request.getService();
        service.writeUncachedStringResponse(response, "application/json; charset=UTF-8", VaadinService.createSessionExpiredJSON(false));
        return true;
    }

    private ServerRpcHandler getRpcHandler(VaadinSession session) {
        session.checkHasLock();
        if (this.rpcHandler == null) {
            this.rpcHandler = this.createRpcHandler();
        }
        return this.rpcHandler;
    }

    public static void commitJsonResponse(VaadinResponse response, String json) throws IOException {
        response.setContentType("application/json; charset=UTF-8");
        response.setHeader("Cache-Control", "no-cache");
        byte[] b = json.getBytes(StandardCharsets.UTF_8);
        response.setContentLength(b.length);
        OutputStream outputStream = response.getOutputStream();
        outputStream.write(b);
        outputStream.flush();
    }

    private void removeOffendingMprHashFragment(JsonObject uidl) {
        if (!uidl.hasKey(EXECUTE)) {
            return;
        }
        JsonArray exec = uidl.getArray(EXECUTE);
        String location = null;
        int idx = -1;
        for (int i = 0; i < exec.length(); ++i) {
            JsonArray arr = (JsonArray)exec.get(i);
            for (int j = 0; j < arr.length(); ++j) {
                JsonObject json;
                if (!arr.get(j).getType().equals((Object)JsonType.STRING)) continue;
                String script = arr.getString(j);
                if (script.contains("history.pushState")) {
                    idx = i;
                    continue;
                }
                if (!script.startsWith(SYNC_ID) || (location = this.removeHashInV7Uidl(json = (JsonObject)JsonUtil.parse((String)("{" + script + "}")))) == null) continue;
                script = JsonUtil.stringify((JsonValue)json);
                script = script.substring(1, script.length() - 1);
                arr.set(j, script);
            }
        }
        if (location != null) {
            idx = idx >= 0 ? idx : exec.length();
            JsonArray arr = Json.createArray();
            arr.set(0, "");
            arr.set(1, String.format(location.startsWith("http") ? PUSH_STATE_LOCATION : PUSH_STATE_HASH, location));
            exec.set(idx, (JsonValue)arr);
        }
    }

    private String removeHashInV7Uidl(JsonObject json) {
        String removed = null;
        JsonArray changes = json.getArray(CHANGES);
        for (int i = 0; i < changes.length(); ++i) {
            String hash = this.removeHashInChange(changes.getArray(i));
            if (hash == null) continue;
            removed = hash;
        }
        JsonArray rpcs = json.getArray(RPC);
        for (int i = 0; i < rpcs.length(); ++i) {
            String hash = this.removeHashInRpc(rpcs.getArray(i));
            if (removed != null || hash == null) continue;
            removed = hash;
        }
        return removed;
    }

    private String removeHashInChange(JsonArray change) {
        if (change.length() < 3 || !change.get(2).getType().equals((Object)JsonType.ARRAY)) {
            return null;
        }
        JsonArray value = change.getArray(2);
        if (value.length() < 2 || !value.get(1).getType().equals((Object)JsonType.OBJECT)) {
            return null;
        }
        JsonObject location = value.getObject(1);
        if (!location.hasKey(LOCATION)) {
            return null;
        }
        String url = location.getString(LOCATION);
        Matcher match = URL_PATTERN.matcher(url);
        if (match.find()) {
            location.put(LOCATION, match.group(1));
        }
        return url;
    }

    private String removeHashInRpc(JsonArray rpc) {
        if (!(rpc.length() == 4 && rpc.get(1).getType().equals((Object)JsonType.STRING) && rpc.get(2).getType().equals((Object)JsonType.STRING) && rpc.get(3).getType().equals((Object)JsonType.ARRAY) && "com.vaadin.shared.extension.javascriptmanager.ExecuteJavaScriptRpc".equals(rpc.getString(1)) && "executeJavaScript".equals(rpc.getString(2)))) {
            return null;
        }
        JsonArray scripts = rpc.getArray(3);
        for (int j = 0; j < scripts.length(); ++j) {
            String exec = scripts.getString(j);
            Matcher match = HASH_PATTERN.matcher(exec);
            if (!match.find()) continue;
            scripts.set(j, ";");
            return match.group(1);
        }
        return null;
    }
}

