/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.dom.DebouncePhase;
import com.vaadin.flow.dom.Element;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.util.EventObject;

public class DomEvent
extends EventObject {
    private final JsonObject eventData;
    private final String eventType;
    private final DebouncePhase phase;

    public DomEvent(Element source, String eventType, JsonObject eventData) {
        super(source);
        assert (source != null);
        assert (eventType != null);
        assert (eventData != null);
        this.eventType = eventType;
        this.eventData = eventData;
        this.phase = DomEvent.extractPhase(eventData);
    }

    private static DebouncePhase extractPhase(JsonObject eventData) {
        JsonValue jsonValue = eventData.get("for");
        if (jsonValue == null) {
            return DebouncePhase.LEADING;
        }
        return DebouncePhase.forIdentifier(jsonValue.asString());
    }

    @Override
    public Element getSource() {
        return (Element)super.getSource();
    }

    public String getType() {
        return this.eventType;
    }

    public JsonObject getEventData() {
        return this.eventData;
    }

    public DebouncePhase getPhase() {
        return this.phase;
    }
}

