/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.ConfiguredRoutes;
import com.vaadin.flow.router.internal.PathUtil;
import com.vaadin.flow.router.internal.RouteModel;
import com.vaadin.flow.router.internal.RouteTarget;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConfigureRoutes
extends ConfiguredRoutes
implements Serializable {
    private final RouteModel routeModel;
    private final Map<String, RouteTarget> routeMap;
    private final Map<Class<? extends Component>, String> targetRouteMap;
    private final Map<Class<? extends Component>, RouteModel> targetRouteModelMap;
    private final Map<Class<? extends Exception>, Class<? extends Component>> exceptionTargetMap;

    public ConfigureRoutes() {
        this.routeModel = RouteModel.create(true);
        this.routeMap = new HashMap<String, RouteTarget>();
        this.targetRouteMap = new HashMap<Class<? extends Component>, String>();
        this.targetRouteModelMap = new HashMap<Class<? extends Component>, RouteModel>();
        this.exceptionTargetMap = new HashMap<Class<? extends Exception>, Class<? extends Component>>();
    }

    public ConfigureRoutes(ConfiguredRoutes original) {
        HashMap<String, RouteTarget> originalRouteMap = new HashMap<String, RouteTarget>();
        HashMap<Class<? extends Component>, String> originalTargetRouteMap = new HashMap<Class<? extends Component>, String>();
        HashMap<Class<? extends Exception>, Class<? extends Component>> originalExceptionTargetsMap = new HashMap<Class<? extends Exception>, Class<? extends Component>>();
        for (Map.Entry<String, RouteTarget> route : original.getRoutesMap().entrySet()) {
            originalRouteMap.put(route.getKey(), route.getValue());
        }
        originalTargetRouteMap.putAll(original.getTargetRoutes());
        originalExceptionTargetsMap.putAll(original.getExceptionHandlers());
        Map<Class<? extends Component>, RouteModel> originalTargetRouteModelMap = original.copyTargetRouteModels(true);
        this.routeModel = RouteModel.copy(original.getRouteModel(), true);
        this.routeMap = originalRouteMap;
        this.targetRouteMap = originalTargetRouteMap;
        this.targetRouteModelMap = originalTargetRouteModelMap;
        this.exceptionTargetMap = originalExceptionTargetsMap;
    }

    @Override
    protected Map<String, RouteTarget> getRoutesMap() {
        return this.routeMap;
    }

    @Override
    RouteModel getRouteModel() {
        return this.routeModel;
    }

    @Override
    public Map<Class<? extends Component>, String> getTargetRoutes() {
        return this.targetRouteMap;
    }

    @Override
    public Map<Class<? extends Exception>, Class<? extends Component>> getExceptionHandlers() {
        return this.exceptionTargetMap;
    }

    public void clear() {
        this.getRoutesMap().clear();
        this.getTargetRoutes().clear();
    }

    public void setRoute(String template, Class<? extends Component> navigationTarget) {
        this.setRoute(template, navigationTarget, null);
    }

    public void setRoute(String template, Class<? extends Component> navigationTarget, List<Class<? extends RouterLayout>> parentChain) {
        template = PathUtil.trimPath(template);
        RouteTarget target = new RouteTarget(navigationTarget, parentChain);
        this.getRouteModel().addRoute(template, target);
        if (!this.hasRouteTarget(navigationTarget)) {
            this.setTargetRoute(navigationTarget, template);
        }
        this.getTargetRouteModelMap().computeIfAbsent(navigationTarget, aClass -> RouteModel.create(true));
        this.getTargetRouteModelMap().get(navigationTarget).addRoute(template, target);
        this.getRoutesMap().put(template, target);
    }

    public void setTargetRoute(Class<? extends Component> navigationTarget, String path) {
        this.getTargetRoutes().put(navigationTarget, path);
    }

    public void setErrorRoute(Class<? extends Exception> exception, Class<? extends Component> errorTarget) {
        this.getExceptionHandlers().put(exception, errorTarget);
    }

    public void removeRoute(Class<? extends Component> target) {
        if (!this.hasRouteTarget(target)) {
            return;
        }
        this.getTargetRoutes().remove(target);
        this.getTargetRouteModelMap().remove(target).getRoutes().keySet().forEach(template -> {
            this.getRouteModel().removeRoute((String)template);
            this.getRoutesMap().remove(template);
        });
    }

    public void removeRoute(String template) {
        if (!this.hasTemplate(template)) {
            return;
        }
        RouteTarget removedRoute = this.getRoutesMap().remove(template);
        if (removedRoute != null) {
            String mainTemplate;
            Class<? extends Component> target = removedRoute.getTarget();
            RouteModel targetRouteModel = this.getTargetRouteModelMap().get(target);
            targetRouteModel.removeRoute(template);
            if (targetRouteModel.isEmpty()) {
                this.getTargetRouteModelMap().remove(target);
            }
            if (Objects.equals(template, mainTemplate = this.getTargetRoutes().get(target))) {
                if (targetRouteModel.isEmpty()) {
                    this.getTargetRoutes().remove(target);
                } else {
                    this.getTargetRoutes().put(target, targetRouteModel.getRoutes().keySet().iterator().next());
                }
            }
        }
        this.getRouteModel().removeRoute(template);
    }

    public void removeRoute(String template, Class<? extends Component> targetRoute) {
        if (!this.hasTemplate(template) || !this.getRoutesMap().get(template).containsTarget(targetRoute)) {
            return;
        }
        this.removeRoute(template);
    }

    @Override
    Map<Class<? extends Component>, RouteModel> getTargetRouteModelMap() {
        return this.targetRouteModelMap;
    }
}

