/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.FrontendUtils;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskInstallWebpackPlugins
implements FallibleCommand {
    private File nodeModulesFolder;

    public TaskInstallWebpackPlugins(File nodeModulesFolder) {
        this.nodeModulesFolder = nodeModulesFolder;
    }

    @Override
    public void execute() {
        this.getPlugins().forEach(plugin -> {
            try {
                this.generatePluginFiles((String)plugin);
            }
            catch (IOException ioe) {
                throw new UncheckedIOException("Installation of Flow webpack plugin '" + plugin + "' failed", ioe);
            }
        });
    }

    protected List<String> getPlugins() {
        try {
            JsonObject jsonFile = this.getJsonFile("plugins/webpack-plugins.json");
            if (jsonFile == null) {
                this.log().error("Couldn't locate plugins/webpack-plugins.json, no Webpack plugins for Flow will be installed.If webpack build fails validate flow-server jar content.");
                return Collections.emptyList();
            }
            JsonArray plugins = jsonFile.getArray("plugins");
            ArrayList<String> pluginsToInstall = new ArrayList<String>(plugins.length());
            for (int i = 0; i < plugins.length(); ++i) {
                pluginsToInstall.add(plugins.getString(i));
            }
            return pluginsToInstall;
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("Couldn't load webpack-plugins.json file", ioe);
        }
    }

    private void generatePluginFiles(String pluginName) throws IOException {
        String packageFile;
        JsonObject targetJson;
        File pluginTargetFile = new File(this.nodeModulesFolder, "@vaadin/" + pluginName);
        String pluginFolderName = "plugins/" + pluginName + "/";
        JsonObject packageJson = this.getJsonFile(pluginFolderName + "package.json");
        if (packageJson == null) {
            this.log().error("Couldn't locate '{}' for plugin '{}'. Plugin will not be installed.", (Object)"package.json", (Object)pluginName);
            return;
        }
        if (pluginTargetFile.exists() && new File(pluginTargetFile, "package.json").exists() && (targetJson = Json.parse((String)(packageFile = FileUtils.readFileToString((File)new File(pluginTargetFile, "package.json"), (Charset)StandardCharsets.UTF_8)))).hasKey("update") && !targetJson.getBoolean("update")) {
            return;
        }
        FileUtils.forceMkdir((File)pluginTargetFile);
        JsonArray files = packageJson.getArray("files");
        for (int i = 0; i < files.length(); ++i) {
            String file = files.getString(i);
            FileUtils.copyURLToFile((URL)this.getResourceUrl(pluginFolderName + file), (File)new File(pluginTargetFile, file));
        }
        FileUtils.copyURLToFile((URL)this.getResourceUrl(pluginFolderName + "package.json"), (File)new File(pluginTargetFile, "package.json"));
    }

    private JsonObject getJsonFile(String jsonFilePath) throws IOException {
        String jsonString;
        block17: {
            URL urlResource = this.getResourceUrl(jsonFilePath);
            if (urlResource == null) {
                return null;
            }
            File jsonFile = new File(urlResource.getFile());
            if (!jsonFile.exists()) {
                try (InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(jsonFilePath);){
                    if (resourceAsStream != null) {
                        jsonString = FrontendUtils.streamToString(resourceAsStream);
                        break block17;
                    }
                    JsonObject jsonObject = null;
                    return jsonObject;
                }
            }
            jsonString = FileUtils.readFileToString((File)jsonFile, (Charset)StandardCharsets.UTF_8);
        }
        return Json.parse((String)jsonString);
    }

    private URL getResourceUrl(String resource) {
        return this.getClass().getClassLoader().getResource(resource);
    }

    private Logger log() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

