/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.internal.HasUrlParameterFormat;
import com.vaadin.flow.router.internal.RouteTarget;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class NavigationState
implements Serializable {
    private Class<? extends Component> navigationTarget;
    private RouteTarget routeTarget;
    private RouteParameters routeParameters = RouteParameters.empty();
    private String resolvedPath;
    private final Router router;

    public NavigationState(Router router) {
        this.router = router;
    }

    public Class<? extends Component> getNavigationTarget() {
        return this.navigationTarget != null ? this.navigationTarget : (this.routeTarget != null ? this.routeTarget.getTarget() : null);
    }

    public void setNavigationTarget(Class<? extends Component> navigationTarget) {
        Objects.requireNonNull(navigationTarget, "navigationTarget cannot be null");
        this.navigationTarget = navigationTarget;
    }

    void setRouteTarget(RouteTarget routeTarget) {
        Objects.requireNonNull(routeTarget, "routeTarget cannot be null");
        this.routeTarget = routeTarget;
    }

    public RouteTarget getRouteTarget() {
        if (this.routeTarget == null && this.navigationTarget != null) {
            this.routeTarget = this.router.getRegistry().getRouteTarget(this.navigationTarget, this.routeParameters);
            if (this.routeTarget != null) assert (this.navigationTarget.equals(this.routeTarget.getTarget()));
        }
        return this.routeTarget;
    }

    public void setResolvedPath(String resolvedPath) {
        this.resolvedPath = resolvedPath;
    }

    public String getResolvedPath() {
        if (this.resolvedPath == null) {
            this.resolvedPath = this.router.getRegistry().getTargetUrl(this.getNavigationTarget(), this.getRouteParameters()).orElse(null);
        }
        return this.resolvedPath;
    }

    void setRouteParameters(RouteParameters routeParameters) {
        assert (routeParameters != null);
        this.routeParameters = routeParameters;
    }

    public RouteParameters getRouteParameters() {
        return this.routeParameters;
    }

    public Optional<List<String>> getUrlParameters() {
        return Optional.of(HasUrlParameterFormat.getParameterValues(this.getRouteParameters()));
    }

    @Deprecated
    public void setUrlParameters(List<String> parameters) {
        this.setRouteParameters(HasUrlParameterFormat.getParameters(parameters));
    }
}

