/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import elemental.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;

public class AbstractConfigurationFactory
implements Serializable {
    public static final String DEV_FOLDER_MISSING_MESSAGE = "Running project in development mode with no access to folder '%s'.%nBuild project in production mode instead, see https://vaadin.com/docs/v15/flow/production/tutorial-production-mode-basic.html";

    protected Map<String, String> getConfigParametersUsingTokenData(JsonObject buildInfo) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (buildInfo.hasKey("productionMode")) {
            params.put("productionMode", String.valueOf(buildInfo.getBoolean("productionMode")));
        }
        if (buildInfo.hasKey("externalStatsFile") || buildInfo.hasKey("externalStatsUrl")) {
            params.put("enableDevServer", Boolean.toString(false));
            params.put("external.stats.file", Boolean.toString(true));
            if (buildInfo.hasKey("externalStatsUrl")) {
                params.put("external.stats.url", buildInfo.getString("externalStatsUrl"));
            }
            return params;
        }
        if (buildInfo.hasKey("useDeprecatedV14Bootstrapping")) {
            params.put("useDeprecatedV14Bootstrapping", String.valueOf(buildInfo.getBoolean("useDeprecatedV14Bootstrapping")));
            System.clearProperty("vaadin.useDeprecatedV14Bootstrapping");
        }
        if (buildInfo.hasKey("eagerServerLoad")) {
            params.put("eagerServerLoad", String.valueOf(buildInfo.getBoolean("eagerServerLoad")));
            System.clearProperty("vaadin.eagerServerLoad");
        }
        if (buildInfo.hasKey("npmFolder")) {
            params.put("project.basedir", buildInfo.getString("npmFolder"));
            this.verifyFolderExists(params, buildInfo.getString("npmFolder"));
        }
        if (buildInfo.hasKey("frontendFolder")) {
            params.put("vaadin.frontend.frontend.folder", buildInfo.getString("frontendFolder"));
            if (!buildInfo.hasKey("npmFolder") || !buildInfo.getString("frontendFolder").startsWith(buildInfo.getString("npmFolder"))) {
                this.verifyFolderExists(params, buildInfo.getString("frontendFolder"));
            }
        }
        if (buildInfo.hasKey("enableDevServer")) {
            params.put("enableDevServer", String.valueOf(buildInfo.getBoolean("enableDevServer")));
        }
        if (buildInfo.hasKey("reuseDevServer")) {
            params.put("reuseDevServer", String.valueOf(buildInfo.getBoolean("reuseDevServer")));
        }
        if (buildInfo.hasKey("connect.javaSourceFolder")) {
            params.put("connect.javaSourceFolder", buildInfo.getString("connect.javaSourceFolder"));
        }
        if (buildInfo.hasKey("connect.openApiFile")) {
            params.put("connect.openApiFile", buildInfo.getString("connect.openApiFile"));
        }
        if (buildInfo.hasKey("connect.applicationProperties")) {
            params.put("connect.applicationProperties", buildInfo.getString("connect.applicationProperties"));
        }
        if (buildInfo.hasKey("project.frontend.generated")) {
            params.put("project.frontend.generated", buildInfo.getString("project.frontend.generated"));
        }
        this.setDevModePropertiesUsingTokenData(params, buildInfo);
        return params;
    }

    protected void setDevModePropertiesUsingTokenData(Map<String, String> params, JsonObject buildInfo) {
        if (params.get("pnpm.enable") == null && buildInfo.hasKey("pnpm.enable")) {
            params.put("pnpm.enable", String.valueOf(buildInfo.getBoolean("pnpm.enable")));
        }
        if (params.get("require.home.node") == null && buildInfo.hasKey("require.home.node")) {
            params.put("require.home.node", String.valueOf(buildInfo.getBoolean("require.home.node")));
        }
    }

    protected String getTokenFileContent(Function<String, String> locationProvider) {
        String location = locationProvider.apply("vaadin.frontend.token.file");
        String json = null;
        try {
            File tokenFile;
            if (location != null && (tokenFile = new File(location)) != null && tokenFile.canRead()) {
                json = FileUtils.readFileToString((File)tokenFile, (Charset)StandardCharsets.UTF_8);
            }
            return json;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected void verifyFolderExists(Map<String, String> params, String folder) {
        Boolean productionMode = Boolean.parseBoolean(params.getOrDefault("productionMode", "false"));
        if (!productionMode.booleanValue() && !new File(folder).exists()) {
            String message = String.format(DEV_FOLDER_MISSING_MESSAGE, folder);
            throw new IllegalStateException(message);
        }
    }
}

