/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.FrontendVersion;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import elemental.json.Json;
import elemental.json.JsonException;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NodeUpdater
implements FallibleCommand {
    static final String GENERATED_PREFIX = "GENERATED/";
    static final String DEPENDENCIES = "dependencies";
    static final String VAADIN_DEP_KEY = "vaadin";
    static final String HASH_KEY = "hash";
    static final String DEV_DEPENDENCIES = "devDependencies";
    private static final String DEP_LICENSE_KEY = "license";
    private static final String DEP_LICENSE_DEFAULT = "UNLICENSED";
    private static final String DEP_NAME_KEY = "name";
    private static final String DEP_NAME_DEFAULT = "no-name";
    private static final String DEP_MAIN_KEY = "main";
    protected static final String DEP_NAME_FLOW_DEPS = "@vaadin/flow-deps";
    protected static final String DEP_NAME_FLOW_JARS = "@vaadin/flow-frontend";
    protected static final String DEP_NAME_FORM_JARS = "@vaadin/form";
    private static final String FORM_FOLDER = "form";
    private static final String DEP_MAIN_VALUE = "index";
    private static final String DEP_VERSION_KEY = "version";
    private static final String DEP_VERSION_DEFAULT = "1.0.0";
    private static final String ROUTER_VERSION = "1.7.2";
    protected static final String POLYMER_VERSION = "3.2.0";
    protected final File npmFolder;
    protected final File nodeModulesFolder;
    protected final File generatedFolder;
    protected final File flowResourcesFolder;
    protected final File formResourcesFolder;
    protected final FrontendDependenciesScanner frontDeps;
    final ClassFinder finder;
    boolean modified;

    protected NodeUpdater(ClassFinder finder, FrontendDependenciesScanner frontendDependencies, File npmFolder, File generatedPath, File flowResourcesPath) {
        this.frontDeps = frontendDependencies;
        this.finder = finder;
        this.npmFolder = npmFolder;
        this.nodeModulesFolder = new File(npmFolder, "node_modules/");
        this.generatedFolder = generatedPath;
        this.flowResourcesFolder = flowResourcesPath;
        this.formResourcesFolder = new File(flowResourcesPath, FORM_FOLDER);
    }

    private File getPackageJsonFile() {
        return new File(this.npmFolder, "package.json");
    }

    static Set<String> getGeneratedModules(File directory, Set<String> excludes) {
        if (!directory.exists()) {
            return Collections.emptySet();
        }
        Function<String, String> unixPath = str -> str.replace("\\", "/");
        URI baseDir = directory.toURI();
        return FileUtils.listFiles((File)directory, (String[])new String[]{"js"}, (boolean)true).stream().filter(file -> {
            String path = (String)unixPath.apply(file.getPath());
            if (path.contains("/node_modules/")) {
                return false;
            }
            return excludes.stream().noneMatch(postfix -> path.endsWith((String)unixPath.apply((String)postfix)));
        }).map(file -> GENERATED_PREFIX + (String)unixPath.apply(baseDir.relativize(file.toURI()).getPath())).collect(Collectors.toSet());
    }

    String resolveResource(String importPath) {
        String resource;
        String resolved = importPath;
        if (!importPath.startsWith("@") && this.hasMetaInfResource(resource = resolved.replaceFirst("^\\./+", ""))) {
            if (!resolved.startsWith("./")) {
                this.log().warn("Use the './' prefix for files in JAR files: '{}', please update your component.", (Object)importPath);
            }
            resolved = "@vaadin/flow-frontend/" + resource;
        }
        return resolved;
    }

    private boolean hasMetaInfResource(String resource) {
        return this.finder.getResource("META-INF/frontend/" + resource) != null || this.finder.getResource("META-INF/resources/frontend/" + resource) != null;
    }

    JsonObject getPackageJson() throws IOException {
        JsonObject packageJson = NodeUpdater.getJsonFileContent(this.getPackageJsonFile());
        if (packageJson == null) {
            packageJson = Json.createObject();
            packageJson.put(DEP_NAME_KEY, DEP_NAME_DEFAULT);
            packageJson.put(DEP_LICENSE_KEY, DEP_LICENSE_DEFAULT);
        }
        NodeUpdater.addVaadinDefaultsToJson(packageJson);
        return packageJson;
    }

    JsonObject getResourcesPackageJson() throws IOException {
        JsonObject packageJson = NodeUpdater.getJsonFileContent(new File(this.flowResourcesFolder, "package.json"));
        if (packageJson == null) {
            packageJson = Json.createObject();
            packageJson.put(DEP_NAME_KEY, DEP_NAME_FLOW_JARS);
            packageJson.put(DEP_LICENSE_KEY, DEP_LICENSE_DEFAULT);
            packageJson.put(DEP_MAIN_KEY, DEP_MAIN_VALUE);
            packageJson.put(DEP_VERSION_KEY, DEP_VERSION_DEFAULT);
        }
        return packageJson;
    }

    JsonObject getFormResourcesPackageJson() throws IOException {
        JsonObject packageJson = NodeUpdater.getJsonFileContent(new File(this.formResourcesFolder, "package.json"));
        if (packageJson == null) {
            packageJson = Json.createObject();
            packageJson.put(DEP_NAME_KEY, DEP_NAME_FORM_JARS);
            packageJson.put(DEP_LICENSE_KEY, DEP_LICENSE_DEFAULT);
            packageJson.put(DEP_MAIN_KEY, DEP_MAIN_VALUE);
            packageJson.put(DEP_VERSION_KEY, DEP_VERSION_DEFAULT);
            packageJson.put("sideEffects", false);
        }
        return packageJson;
    }

    static JsonObject getJsonFileContent(File packageFile) throws IOException {
        JsonObject jsonContent = null;
        if (packageFile.exists()) {
            String fileContent = FileUtils.readFileToString((File)packageFile, (String)StandardCharsets.UTF_8.name());
            try {
                jsonContent = Json.parse((String)fileContent);
            }
            catch (JsonException e) {
                throw new JsonException(String.format("Cannot parse package file '%s'", packageFile));
            }
        }
        return jsonContent;
    }

    static void addVaadinDefaultsToJson(JsonObject json) {
        JsonObject vaadinPackages = NodeUpdater.computeIfAbsent(json, VAADIN_DEP_KEY, Json::createObject);
        NodeUpdater.computeIfAbsent(vaadinPackages, DEPENDENCIES, () -> {
            JsonObject dependencies = Json.createObject();
            NodeUpdater.getDefaultDependencies().forEach((arg_0, arg_1) -> ((JsonObject)dependencies).put(arg_0, arg_1));
            return dependencies;
        });
        NodeUpdater.computeIfAbsent(vaadinPackages, DEV_DEPENDENCIES, () -> {
            JsonObject devDependencies = Json.createObject();
            NodeUpdater.getDefaultDevDependencies().forEach((arg_0, arg_1) -> ((JsonObject)devDependencies).put(arg_0, arg_1));
            return devDependencies;
        });
        NodeUpdater.computeIfAbsent(vaadinPackages, HASH_KEY, () -> Json.create((String)""));
    }

    private static <T extends JsonValue> T computeIfAbsent(JsonObject jsonObject, String key, Supplier<T> valueSupplier) {
        JsonValue result = jsonObject.get(key);
        if (result == null) {
            result = (JsonValue)valueSupplier.get();
            jsonObject.put(key, result);
        }
        return (T)result;
    }

    static Map<String, String> getDefaultDependencies() {
        HashMap<String, String> defaults = new HashMap<String, String>();
        defaults.put("@vaadin/router", ROUTER_VERSION);
        defaults.put("@polymer/polymer", POLYMER_VERSION);
        defaults.put("lit-element", "2.3.1");
        return defaults;
    }

    static Map<String, String> getDefaultDevDependencies() {
        HashMap<String, String> defaults = new HashMap<String, String>();
        defaults.put("html-webpack-plugin", "4.5.1");
        defaults.put("typescript", "4.0.3");
        defaults.put("ts-loader", "8.0.12");
        defaults.put("fork-ts-checker-webpack-plugin", "6.2.1");
        defaults.put("webpack", "4.46.0");
        defaults.put("webpack-cli", "3.3.11");
        defaults.put("webpack-dev-server", "3.11.0");
        defaults.put("compression-webpack-plugin", "4.0.1");
        defaults.put("extra-watch-webpack-plugin", "1.0.3");
        defaults.put("webpack-merge", "4.2.2");
        defaults.put("css-loader", "4.2.1");
        defaults.put("extract-loader", "5.1.0");
        defaults.put("lit-css-loader", "0.0.4");
        defaults.put("file-loader", "6.2.0");
        defaults.put("loader-utils", "2.0.0");
        defaults.put("lit-element", "2.4.0");
        defaults.put("lit-html", "1.3.0");
        String WORKBOX_VERSION = "5.1.4";
        defaults.put("workbox-webpack-plugin", "5.1.4");
        defaults.put("workbox-core", "5.1.4");
        defaults.put("workbox-precaching", "5.1.4");
        defaults.put("glob", "7.1.6");
        defaults.put("webpack-manifest-plugin", "3.0.0");
        defaults.put("@types/validator", "13.1.0");
        defaults.put("validator", "13.1.17");
        defaults.put("construct-style-sheets-polyfill", "2.4.16");
        defaults.put("chokidar", "^3.5.0");
        return defaults;
    }

    boolean updateDefaultDependencies(JsonObject packageJson) {
        int added = 0;
        for (Map.Entry<String, String> entry : NodeUpdater.getDefaultDependencies().entrySet()) {
            added += this.addDependency(packageJson, DEPENDENCIES, entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : NodeUpdater.getDefaultDevDependencies().entrySet()) {
            added += this.addDependency(packageJson, DEV_DEPENDENCIES, entry.getKey(), entry.getValue());
        }
        if (added > 0) {
            this.log().info("Added {} default dependencies to main package.json", (Object)added);
        }
        return added > 0;
    }

    int addDependency(JsonObject json, String key, String pkg, String version) {
        Objects.requireNonNull(json, "Json object need to be given");
        Objects.requireNonNull(key, "Json sub object needs to be give.");
        Objects.requireNonNull(pkg, "dependency package needs to be defined");
        JsonObject vaadinDeps = json.getObject(VAADIN_DEP_KEY);
        if (!json.hasKey(key)) {
            json.put(key, (JsonValue)Json.createObject());
        }
        json = (JsonObject)json.get(key);
        if ((vaadinDeps = vaadinDeps.getObject(key)).hasKey(pkg)) {
            if (version == null) {
                version = vaadinDeps.getString(pkg);
            }
            return this.handleExistingVaadinDep(json, pkg, version, vaadinDeps);
        }
        vaadinDeps.put(pkg, version);
        if (!json.hasKey(pkg) || new FrontendVersion(version).isNewerThan(NodeUpdater.toVersion(json, pkg))) {
            json.put(pkg, version);
            this.log().debug("Added \"{}\": \"{}\" line.", (Object)pkg, (Object)version);
            return 1;
        }
        return 0;
    }

    private int handleExistingVaadinDep(JsonObject json, String pkg, String version, JsonObject vaadinDeps) {
        boolean added = false;
        if (json.hasKey(pkg)) {
            FrontendVersion packageVersion = NodeUpdater.toVersion(json, pkg);
            FrontendVersion newVersion = new FrontendVersion(version);
            FrontendVersion vaadinVersion = NodeUpdater.toVersion(vaadinDeps, pkg);
            if (vaadinVersion.isEqualTo(packageVersion) && !vaadinVersion.isEqualTo(newVersion)) {
                json.put(pkg, version);
                added = true;
            } else if (newVersion.isNewerThan(packageVersion)) {
                json.put(pkg, version);
                added = true;
            }
        } else {
            json.put(pkg, version);
            added = true;
        }
        vaadinDeps.put(pkg, version);
        if (added) {
            this.log().debug("Added \"{}\": \"{}\" line.", (Object)pkg, (Object)version);
        }
        return added ? 1 : 0;
    }

    private static FrontendVersion toVersion(JsonObject json, String key) {
        return new FrontendVersion(json.getString(key));
    }

    String writePackageFile(JsonObject packageJson) throws IOException {
        return this.writePackageFile(packageJson, new File(this.npmFolder, "package.json"));
    }

    String writeResourcesPackageFile(JsonObject packageJson) throws IOException {
        return this.writePackageFile(packageJson, new File(this.flowResourcesFolder, "package.json"));
    }

    String writeFormResourcesPackageFile(JsonObject packageJson) throws IOException {
        return this.writePackageFile(packageJson, new File(this.formResourcesFolder, "package.json"));
    }

    String writePackageFile(JsonObject json, File packageFile) throws IOException {
        this.log().debug("writing file {}.", (Object)packageFile.getAbsolutePath());
        FileUtils.forceMkdirParent((File)packageFile);
        String content = JsonUtil.stringify((JsonValue)json, (int)2) + "\n";
        FileUtils.writeStringToFile((File)packageFile, (String)content, (String)StandardCharsets.UTF_8.name());
        return content;
    }

    Logger log() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

